#define PROGNAME "Nav/2"
#define VERNUM  "Version 0.5"

#define WC_NAV2 "Nav2"

/* Constants */
#define TOOLBARHEIGHT   50
#define CTOOLS          8

/* Window and control identifiers */
#define ID_MAIN             0x0100
#define ID_TOOLBAR          0x0200
#define ID_CNFPLANINFO      0x0300
#define ID_PLANPOPUP        0x0400

#define IDS_HEAD_TO         0x0301
#define IDS_HEAD_LSALT      0x0302
#define IDS_HEAD_FL         0x0303
#define IDS_HEAD_TAS        0x0304
#define IDS_HEAD_TRMAG      0x0305
#define IDS_HEAD_WIND       0x0306
#define IDS_HEAD_HDGMAG     0x0307
#define IDS_HEAD_GS         0x0308
#define IDS_HEAD_DIST       0x0309
#define IDS_HEAD_ETI        0x030A
#define IDS_HEAD_PLNEST     0x030B
#define IDS_HEAD_ROUTEQUAL  0x030C
#define IDS_TITLE           0x030D

/* Menu ID's */
#define IDM_FILE            0x0101
#define IDM_NEW             0x0102
#define IDM_OPEN            0x0103
#define IDM_SAVE            0x0104
#define IDM_EXIT            0x0105
#define IDM_EDIT            0x0110
#define IDM_UNDO            0x0111
#define IDM_CUT             0x0112
#define IDM_COPY            0x0113
#define IDM_PASTE           0x0114
#define IDM_INSERT          0x0115
#define IDM_DELETE          0x0116

#define IDM_PLAN            0x0120
#define IDM_DEPART          0x0121

#define IDM_HELP            0x01F0
#define IDM_HINDEX          0x01F1
#define IDM_HGENERAL        0x01F2
#define IDM_HUSING          0x01F3
#define IDM_HEXTENDED       0x01F4
#define IDM_HABOUT          0x01F5

/* Popup menu ID's */
#define IDMP_AFTER          0x0401
#define IDMP_BEFORE         0x0402
#define IDMP_DELETE         0x0403
#define IDMP_EDIT           0x0404

#define ID_CBDEPART         0x0500

/* User-defined messages */
#define UM_INITSIZE     WM_USER
#define UM_FTDONE       WM_USER+1

typedef struct _WINDATA {
    HWND hwndToolbar;
    HWND hwndContainer;
    PRECORDCORE prcCurrentRecord;
    PPLAN pplan;
} WINDATA, *PWINDATA;

#define PWINDATAFROMHWND(hwnd) (PWINDATA)WinQueryWindowPtr((hwnd), 0)

typedef struct
{
    PSZ     to;                         // Next waypoint
    ULONG   lsalt;                      // Lowest safe altitude
    PSZ     fl;                         // Flight level
    PSZ     tas;                        // True airspeed
    PSZ     trmag;                      // Track (magnetic)
    PSZ     wind;                       // Wind
    PSZ     hdgmag;                     // Heading (magnetic)
    PSZ     gs;                         // Ground speed
    PSZ     dist;                       // Distance
    PSZ     eti;                        // Estimated time interval
    PSZ     plnest;                     // Planned eta
    PSZ     routequal;                  // Route qualifier
}  PLANREC, *PPLANREC;

PLANREC plandata[] =    /* Test data */
{
/*    To    LSALT   FL      TAS     TRMAG   WIND        HDGMAG  GS      DIST    ETI     PLNEST  RQ */
    {"KAT", 4800,   "A060", "140",  "275",  "275/10",   "275",  "130",  "35",   "17",   "45",   ""},
    {"BTH", 5500,   "A060", "140",  "287",  "275/10",   "286",  "130",  "36",   "17",   "02",   ""},
    {"MDG", 5300,   "A080", "140",  "345",  "275/10",   "341",  "134",  "52",   "23",   "25",   ""},
    {"KAD", 4700,   "A070", "140",  "125",  "275/10",   "122",  "147",  "25",   "10",   "35",   ""},
    {"ASSY",4700,   "A070", "140",  "125",  "275,10",   "122",  "147",  "90",   "37",   "12",   ""},
    {"BK",  1000,   "A015", "120",  "275",  "275/10",   "275",  "110",  "9",    "5",    "17",   ""}
};

typedef struct _fillthread {
    PNDINFO pnd;
    HWND hwndListBox;
    HWND hwndReply;
    HEV hevStop;
    HEV hevStopped;
} FT, *PFT;


