window.addEventListener( "load", function() {

  function setInvalidView(el,fInvalid)
  {
    if ( fInvalid ) el.classList.add( "pe__inputText_invalid" );
    else el.classList.remove( "pe__inputText_invalid" );
  }

  var fStorageLimit = true;
  var fDepthMax = true;
  var fNames = true;
  var fCopyTo = true;
  var timeoutAjaxUser = null;

  /* New user: names validator */

  const elNames = document.querySelector( "input[name='names']" );
  const regSplitNames = /\s*[,;\s]+/;

  function getNamesArray() {
    return Array.from( new Set( elNames.value.trim().toLowerCase().split( regSplitNames ) ) );
  }

  if ( elNames ) {
    fNames = false;
    utilInputOnChange( elNames, function(e) {
      const  aNames = getNamesArray();
      const  regName = /^[0-9a-z][0-9a-z\._-]*$/;
      fNames = aNames.length != 0;

      for(strName of aNames)
        if ( !regName.test( strName ) ) {
          fNames = false;
          break;
        }

      setInvalidView( this, !fNames );
      utilVldrtCheck();
    } );
  }

  /* User properties: disable OPER when ADMIN is checked. */
  const elFlagAdminCB = document.querySelector( "input[name='ADMIN']" );
  if ( elFlagAdminCB )
    elFlagAdminCB.addEventListener( "change", function(e) {
      document.querySelector( "input[name='OPER']" ).disabled = e.target.checked;
    } );

  /* User properties: storage limit input validator */
  utilInputOnChange( document.getElementById( "storage-limit" ), function(e) {
    const regStorageLimit = /^\s*(\d{1,9}(\.\d{1,3})?\s*(b|kb|k|mb|m|gb|g)?\s*)?$/i;

    fStorageLimit = regStorageLimit.test( this.value );
    utilVldrtCheck();
    setInvalidView( this, !fStorageLimit );
  } );

  /* User properties: depth-max input validator */
  utilInputOnChange( document.getElementById( "depth-max" ), function(e) {
    const regStorageLimit = /^\s*(\d{1,5}\s*)?$/;

    fDepthMax = regStorageLimit.test( this.value )
    utilVldrtCheck();
    setInvalidView( this, !fDepthMax );
  } );

  /* User properties: copy-to validator. */
  utilInputOnChange( document.querySelector( "input[name='copy-to']" ), function(e) {
    const  reg = /^\S+@\S+[^\.]?$/;
    const  el = this;
    const  elRes = document.querySelectorAll( "div#copy-to-result > div" );
    const  str = this.value.trim();

    if ( !str )
      fCopyTo = true;
    else if ( !reg.test( str ) )
      fCopyTo = false;
    else
    {
      fCopyTo = false;
      utilVldrtCheck();

      if ( timeoutAjaxUser != null )
        clearTimeout( timeoutAjaxUser );

      timeoutAjaxUser = setTimeout(
        function(str) {
          utilAJAX( "ajax_user?a=" + encodeURIComponent( str ),
            function(xmlRoot) {
              fCopyTo = xmlRoot.firstChild ? true : false;
              utilVldrtCheck();
              setInvalidView( el, !fCopyTo );
            }
          );
        }, 400, str );

      return;
    }
    utilVldrtCheck();
    setInvalidView( this, !fCopyTo );
  } );


  /* Send a list of names separated by spaces (replace "'" and ";" with SP). */
  if ( elNames ) {
    document.querySelector( "form" ).addEventListener( "submit",
      function(e) { elNames.value = getNamesArray().join( " " ); },
      true
    );
  }

  utilVldrtSet( function() {
    return fNames && fStorageLimit && fDepthMax && fCopyTo; } );


  el = document.getElementById( "domain-properties__delete-button" );
  if ( el )
    el.addEventListener( "click", function delBtn(e) {
      var strURI = this.href;

      confirmation( null, function() { document.location = strURI; } );
      e.preventDefault();
    },
    true );
} );
