var gl_iCheckedItems = 0;
var gl_elDrag = null;
var gl_elDragTag = null;
var gl_fnDrop = null;  // fn(element,indexFrom,indexTo)
var gl_iDragIndex = -1;

function _dragBegin(elTarget)
{
  if ( !elTarget || !elTarget.classList.contains("item-drag__pad") )
    return;
  gl_elDrag = elTarget.parentNode;
  gl_elDragTag = gl_elDrag;
  gl_elDrag.classList.add( "item-drag_current" );
  gl_iDragIndex = utilIndexOfElement( gl_elDrag );
}

function _dragMove(elTarget)
{
  if ( !gl_elDrag || !elTarget )
    return;

  var elDragTag;

  if ( elTarget.classList.contains("item-drag") )
    elDragTag = elTarget;
  else if ( elTarget.parentNode.classList.contains("item-drag") )
    elDragTag = elTarget.parentNode;
  else
    return;

  if ( gl_elDragTag == elDragTag )
    return;

  document.getSelection().removeAllRanges();

  gl_elDragTag = elDragTag;

  utilInsert( utilIndexOfElement(gl_elDragTag) >
                utilIndexOfElement(gl_elDrag),
              gl_elDrag, gl_elDragTag );

  return false;
}

function _dragEnd()
{
  if ( gl_elDrag == null )
    return;

  gl_elDrag.classList.remove( "item-drag_current" );

  const iNewIndex = utilIndexOfElement(gl_elDragTag);
  if ( ( gl_fnDrop != null ) && ( gl_iDragIndex != iNewIndex ) )
    if ( !gl_fnDrop( gl_elDrag, gl_iDragIndex, iNewIndex ) )
      // Return old position
      utilInsert( gl_iDragIndex > iNewIndex, gl_elDrag,
                  gl_elDrag.parentNode.children[gl_iDragIndex] );

  gl_elDrag = null;
}


function _setItemDrag(aItemDragPads)
{
  for(elPad of aItemDragPads)
  {
    elPad.addEventListener( "mousedown", function(e) {
      _dragBegin( e.currentTarget );
    });
  }

  document.addEventListener( "mousemove", function(e) {
    const el = document.elementFromPoint( e.clientX, e.clientY );
    _dragMove( el );
  });
  document.addEventListener( "mouseup", _dragEnd );
}

function listsSetOnDrop(fn)
{
  gl_fnDrop = fn;
}

window.addEventListener( "load", function() {

  // "[Delete]" for list
  el = document.getElementById( "list__del-btn" );
  if ( el )
    el.addEventListener( "click", function(e) {
      confirmation( "Are you sure you want to remove the selected items?",
        function() {
          document.getElementById( "list__del-form" ).submit();
        } );
    }, true );

  // "[X] All" for items list
  const aCB = document.querySelectorAll( "input[data-item]" );
  el = document.getElementById( "list__cb-all" ); 
  if ( aCB && el )
  {
    el.addEventListener( "change", function(e) {
      for(var iIdx = 0; iIdx < aCB.length; iIdx++)
        aCB[iIdx].checked = e.target.checked;

      gl_iCheckedItems = e.target.checked ? aCB.length : 0;
      document.getElementById( "list__del-btn" ).disabled = gl_iCheckedItems == 0;
    } );

    // Items checkboxes
    for(var iIdx = 0; iIdx < aCB.length; iIdx++)
      aCB[iIdx].addEventListener( "change", function(e) {
        gl_iCheckedItems += (e.target.checked ? 1 : -1);
        document.getElementById( "list__del-btn" ).disabled =
          gl_iCheckedItems == 0;
      }, true );
  }

  const aItemDrags = document.getElementsByClassName( "item-drag__pad" );
  if ( aItemDrags.length ) {
    _setItemDrag( aItemDrags );

    const elList = document.querySelector( ".main-content pe" );
    if ( elList ) {
      document.ondragstart = function() { return false; };

      elList.addEventListener( "touchstart", function(e) {
        _dragBegin( e.touches[0].target );
        if ( gl_elDrag )
          e.preventDefault();
      });

      elList.addEventListener( "touchmove", function(e) {
        _dragMove( document.elementFromPoint( e.touches[0].clientX, e.touches[0].clientY ) );
      });

      elList.addEventListener( "touchend", _dragEnd );
      elList.addEventListener( "touchcancel", _dragEnd );

      document.addEventListener("selectionchange",
        function() { document.getSelection().removeAllRanges(); }, false );
    }
  }

} );
