/*EXAMPLE REXXHOOK SCRIPT ____________________________________________________
  DESCRIPTION ________________________________________________________________
  This script checks how many active anonymous sessions the FTPd service has, 
  and denies anonymous access if more than 8 sessions are already active.
  
  RETURN VALUE _______________________________________________________________
  This script should return a full FTP response line to reject the anonymous 
  login. The response line should be according to FTP standards defined.
  ____________________________________________________________________________*/
PARSE ARG Session Arguments;

PARSE VALUE ipsVAR(Session, "%(usr.anon)|%(sessions.anonymous)|"), 
  WITH usr_anon"|"sessions_anonymous"|";

IF usr_anon THEN DO
  IF (sessions_anonymous > 8) THEN
    RETURN "421 No more anonymous logins accepted at this time, try again later.";

END;
/*____________________________________________________________________________*/