/*DOGET -- issues a requst to an http server.
   Typically, issues a GET request.
   However, DOGET will also send HEAD, POST, PUT, DELETE, TRACE, and OPTIONS requests
   Simple call: DOGET serveraddress requeststring                   

   For more info: DOGET ?

*/

/* ------------------------------------------------------------------- */

/*BEGINUSER*/

/*    -------- User changeable parameters   ---------- */


/* The default VERB (http method) to use .
   GET is the default (if use_verb='')
   POST and HEAD are not uncommon.
   PUT and DELETE, and TRACE and OPTIONS are other http/1.1 methods */
use_verb='GET'

/* The http version to report.
   Default is HTTP/1.1
   HTTP/1.0 can be used to emulate an older server */

http_ver='HTTP/1.1'


/* To enable delta-encoding (rfc3229), set this equal to a
   "delta cache" directory. This directory MUST be on a HPFS
   drive. If a relative directory, it's relative to the current directory.
   To NOT enable delta encoding, set delta_dir='' 

   Note: DELTA-encoding REQUIRES:
        * GNUDIFF.EXE must be in your OS/2 PATH (or in the current directory),
        * REXXLIB.DLL, RXGDIFF.DLL, RXGZIP, and GNUREGEX.DLL must be in your 
          OS/2 LIBPATH (or in the current directory)                  
        * If you've installed the SRE2003 DELTA module, you can use its
          version of DOGET (it is installed with the delta-parameters appropriately set)
          Look for it in the BIN\IM\DELTA directory of the SRE2003 directory . */

delta_dir='dcache'
delta_dir=''

/* Warn user when delta_dir has more than this many Mbytes.
   Also, give user opportunity to clean out old instances */
delta_dir_warning=20

/* Include no more than this many "etags" in an If-None-Match */
delta_max_etags=4

/* set to 1 to use GZIP to decompress, when GZIP is a Transfer Encoding 
   Enabling this option REQUIRES that you have rxGZIP.DLL installed on
   your computer */
do_gzip=1

/* Time to to pause before connecting to server (0= no pause)
   This can be interuppted by a key stroke.
   If you use a decimal (i.e.; 5.0 instead of 5), the DOGET will poll
   the keyboard every 1/10 second. Otherwise, it will poll the keyboard
   every second.  
       Since some earlier versions of OS/2 warp REXX do not support
       fractional values in syssleep, you make not be able to use this 
       "decimal" form).           */
do_pause=0

/* On POST requests, have contents emulate the output of an HTML FORM.
   This means conversion of " " to +, and other url encoding.
   It also means adding a x-www-urlencoded request header 
   1 = do this emualtion, 0= do not (send contents as is) */
emulate_form=0


/* the header file contains request headers to add include with a request.
   HEADER_FILE='' if you don't want to use a header file. Note that you
   can also add headers in interactive mode, and you can included headers in
   a DOGET-request file (if a DOGET-request file is used, the HEADER_FILE will
   NOT be used). */
header_file=''


/* the HOST: header to include with a request.  
     host_header='' means "include the SERVER name".  
    In ALMOST ALL cases, host_header='' SHOULD be used! */
host_header=''

/* the output file -- the contents of a response are written here
   (a prior version of the file will be overwritten)  */
outfile='doget.lst'

/* Display options:
   0 = extract and display response headers, and try and do several
       encodings. Write (possibly decoded) request body to outfile
   1 = write everything (headers and content), without decoding, to outfile
   2 = same as 1, but display response headers on screen
   3 = same as 2, but also write request (line and headers) to out file  */
output_mode=0


/* file to use to create an rsync signature file. Set RsyncFile='' to 
   suppress creation of an rsync signature */
RsyncFile=''

/* Number of blocks to use when creating rsync-signature request header.
   More blocks means longer request header, but more chances of a match 
   45 yields about a 500 byte header, which is pushing acceptable
   limits. Rsync_blocks must be  between 10 and 255  */
rsync_blocks=45

/* Save request, in a DOGET request file format, to DOGET.REQ.
   This can then be used to reissue a request (perhaps after
   you've modified it with a text editor). 
   Note that:
        > an older copy of DOGET.REQ will be overwritten
        > this is NOT done if you've started DOGET with a "request file"
        > there is a slight security risk -- if you use a username and 
          passwords, they are written to DOGET.REQ "in the clear"
    Set to 1 to enable, 0 to disable */
save_DOGET_request=1


/* If SENDCLOSE=1, then close tcp/ip connection after sending requests. 
   Otherwise, keep it open to listen for another request (from this same
   client). */
sendclose=1

/* file containing contents to upload. Used only in POST and PUT requests */
UploadFile=''

/* VIEWIT=1 to view (using VIEWER program) the body of the response.
   VIEWIT='' to NOT view (though response will be saved to outfile) */
viewit=''

/* viewer program to use (to view response). Leave blank
   to supress "view response?" option  */
viewer='E.EXE'

/* if viewer program is not a PM program (that is, if it's a simple
  "command line" program), set this to 1 to "close session after execution "*/
viewer_not_pm=0

/* Display extra status messages if verbose=1 */
verbose=0 

/*    -------- End of User changeable parameters   ---------- */

/*ENDUSER*/

ims_use='range,gdiff,diffe,gzip'  /* used in add_Delta_header */

call load /* load functions if necessary */


call checkansi  /* ansi screen stuff */

if delta_dir<>'' then do
   call check_delta_dir
   say "Using delta_dir of "delta_dir
end 

delta_dir=strip(delta_dir,'t','\')
httpport=80

gosock=0

parse arg server request coptions

parse source somewhere
parse var somewhere . . somewhere . ; somewhere=strip(somewhere)

say "      "cy_ye" Make a request to  an http server. "normal" (DOGET ? for the details ...)";say " "


if server='?' then do
  call show_intro
  exit
end

isbatch=0
if server<>'' & request=''  then do 
  if abbrev(translate(server),'=')=1 then do
    isbatch=1
  end
  else do
     if abbrev(translate(server),'HTTP://')=1 then do
         isbatch=0
     end 
     else do
         isbatch=yesno(' Is this a DOGET batch file ','No Yes','N')
         if isbatch=1 then  server='='||server
     end
  end
  if isbatch=0 then request='/'
end 



mehost=get_hostname()

if server='.' then server=mehost

crlf='0d0a'x                        /* constants */
opts="" ;upwd=""
ietags=0 ;etaglist='' ; efilelist=''
output_mode=0
oldverfile=''
batchmode=0
sshost=host_header

if abbrev(strip(server),'=') then do
   server=substr(server,2)
   call do_batch
   batchmode=1
   do_pause=0
end 

/* check rxgzlib availability (if delta_dir<>'', then it's already been checked */
if do_gzip=1 & delta_dir='' then do         /* Load the rxgzlib functions */
  if rxfuncquery('rxgzLoadFuncs')=1 then do
     foo=RxFuncAdd( 'rxgzLoadFuncs', 'rxgzLIB', 'rxgzLoadFuncs')
     if foo=0 then call rxgzLoadFuncs
  end
  if rxfuncquery('rxGZDeflateFile')=1 then do
     say "Warning: GZIP not supported, could not find RxGzLIB.DLL (is it in your LIBPATH?) "
     do_gzip=0
  end
end

if server="" then do 
    mehost=get_hostname()
    say " Please enter server address (ENTER= " mehost":"httpport')'
    call charout,"    "cy_ye":"normal" "

    parse pull server
    if server="" then server=mehost
end  /* Do */

server0=server

parse var server server ':' bport
if bport<>'' then httpport=bport

if request="" then  do
  cmd_mode=0
  say " Enter resource (on "server") to request: "
  call charout,"    "cy_ye":"normal" "
  parse pull request

  getmore=yesno('Select more options ','No Few_more Many_more','N')
  if getmore>0 then
       call do_getmore getmore
end
else do                 /* request is on command line. So possibly use header file, */
  if batchmode=0 & header_file<>'' then do   /*  and look for - options */
     cmd_mode=1
     iss=stream(header_file,'c','query size')
     if iss<>0 & iss<>'' then do
         afil=header_file
         goo=charin(afil,1,iss); foo=stream(afil,'c','close')
         say "Note: using request headers specified in "afil
         opts=opts||goo
     end 
     else do
         say bold"Warning: "normal" could not find header-file: "header_file
     end 
  end
end 

/* now deal with coptions from command line */
if coptions<>"" then do
   coptions=strip(coptions)
   if abbrev(coptions,'-')=0 then do
        say bold"Error:" normal" each option must start with a - "
        exit
   end 
   coptions=substr(coptions,2)
   copts=''
   do until coptions=''
      parse var coptions  aoption '-' coptions
      if copts="" then
            copts=aoption
      else
            copts=copts||'0d0a'x||aoption
   end
   if copts<>"" then do 
     afil=copts
     call do_batch 1
   end 
end 
if abbrev(translate(request),'HTTP://')=0 then request='/'strip(request,'l','/')

use_verb=translate(strip(word(use_verb,1)))


if use_verb='POST' | use_verb='PUT' then do
  if uploadFile='' then do 
      call get_upstuff
  end 
  else do
    uploadfile=strip(uploadfile)
    ssize=stream(uploadFile,'c','query size')
    if ssize='' | ssize=0 then do
       say "  "bold||use_verb||normal" error: could not read file: "uploadFile
       exit     
    end
    upstuff=charin(uploadFile,1,ssize)
    foo=stream(uploadFile,'c','close')
    say "  Total of "ssize" bytes in "uploadFile
  end
end

if save_doget_request=1 then do
   isave=saves.0+1
   saves.isave='SERVER: 'server0

   isave=isave+1
   saves.isave='USE_VERB: 'use_verb

   isave=isave+1
   saves.isave='HTTP_VER: 'http_ver

   isave=isave+1
   saves.isave='REQUEST: 'request

   isave=isave+1
   saves.isave='OUTFILE: 'outfile
   isave=isave+1
   saves.isave='OUTPUT_MODE: 'output_mode

   if use_verb='POST' | use_verb='PUT' then do
      isave=isave+1
      saves.isave='UPLOADFILE: 'uploadFILE
   end

   isave=isave+1
   saves.isave='Do_GZIP: 'do_gzip
   if viewit=1 then do
     isave=isaves+1
     saves.isave='View: 1'
   end
   if do_pause=1 then do
     isave=isaves+1
     saves.isave='Pause: 1 '
   end
   saves.0=isave
end 

family  ='AF_INET'

rc=1
if verify(server,'1234567890.')>0 then 
   rc=sockgethostbyname(server, "serv.0")  /* get dotaddress of server */
else
  serv.0addr=strip(server)
if rc=0 then do; say 'ERROR: Unable to resolve "'server'"'; exit; end
dotserver=serv.0addr                    /* .. */
say 
say cy_ye"Request sent to: "normal||"  "||reverse||dotserver||normal ;say " "

gosaddr.0family=family                  /* set up address */
gosaddr.0port  =httpport
gosaddr.0addr  =dotserver

tim1=time('r')
setup1:

gosock = SockSocket(family, "SOCK_STREAM", "IPPROTO_TCP")

gethead='GET'
if use_verb<>'' then gethead=use_verb
gethead=translate(gethead)

httpis='HTTP/1.1'
if http_ver<>'' then httpis=strip(word(http_ver,1))


if sshost='' then sshost=server

message=gethead' 'request' 'httpis||crlf
if strip(sshost)<>'.' then message=message||'HOST:'sshost||crlf

message=message||'Referer:do_get@'||mehost||crlf
message=message||'User-Agent: SRE2003_DOGET_v1.12d'||crlf 

if upwd<>' ' then
  message=message||'Authorization: '||upwd||crlf

if opts<>"" then do
   if right(opts,2)<>'0d0a'x then opts=opts||'0d0a'x
end 
message=message||opts
if sendclose=1 then do
  message=message||'Connection: close' crlf
  if save_doget_request=1 then do
     isave=saves.0+1
     saves.isave='SENDCLOSE=1'
     saves.0=isave
  end
end

if RsyncFile<>'' then do
   oldverfile=RsyncFile ; enable_rsync=1
   if pos('\',oldverfile)=0 then do
           oldverfile=deltas_dir'\'||strip(oldverfile)
   end /* do */
   if stream(oldverfile,'c','query exists')='' then do
      say " ... Problem: no such file (for rsync): "oldverfile
      enable_rsync=0
   end /* do */
   else do
      say " ... computing rsync synopsis for: "oldverfile
   end
   if save_doget_request=1 then do
     isave=saves.0+1
     saves.isave='RsyncFile='oldverfile
     saves.0=isave
   end
end 
if enable_rsync=1  then do
   aa=rsync_synopsis(oldverfile,rsync_blocks)
   say " ... Rsync-signature request header is "||length(aa)||" bytes long"
   message=message||'Rsync-signature: 'aa||crlf
end /* do */

if delta_dir<>'' then call add_delta_headers ims_use


if use_verb='POST' | use_verb='PUT' then do
  if use_verb='POST' then do
      if emulate_form=1 then do
         message=message||'Content-type:application/x-www-form-urlencoded'||crlf
         upstuff=fix_option(upstuff,1,1)
         ssize=length(upstuff)
      end
  end
  say bold"Request headers: "normal
  say message
  say " and "ssize" bytes in the request body " ; say

  message=message||'Content-Length: '||ssize||'0d0a'x
  message=message||crlf||upstuff

end
else do
  message=message||crlf         /* "blank line" sginals end of headers */
  say bold"The request: "normal
  say message
end


/* write doget.req? */
if saves.0>0 then do
   ddd='DOGET.REQ'
   foo=sysfiledelete(ddd)
   call lineout ddd,'; created 'date('n')||' '||time("n")
   do mm=1 to saves.0
      call lineout ddd,saves.mm
   end 
   call lineout ddd
   dddsize=stream(ddd,'c','query size')
   say "A DOGET request file was written to DOGET.REQ (# bytes="dddsize")"
end 


if do_pause=0 | datatype(do_pause)<>'NUM' then do
    nop
end 
else do
  iperi=pos('.',do_pause)
  dopp=do_pause*10
  towait=1 ; tostep=10
  if iperi>0 then do
      towait=0.1 ; tostep=1
  end 

  if norexxlib=0 then
     call charout,"Pausing for "do_pause" seconds; or hit any key to continue .... "
   else
     call charout,"Pausing for "do_pause" seconds .... "

  do jjj=1 to dopp by tostep
     if norexxlib=0 then do
       a=inkey('N')
       if length(a)>0 then leave
     end
     call syssleep(towait)
  end
  say
end


rc = SockConnect(gosock,"gosaddr.0")
if rc<0 then do; say 'ERROR: Unable to connect to "'server'"'; exit; end
rc = SockSend(gosock, message)
say bold' ...  request length = 'normal||rc " bytes "
/* Now wait for the response */
tim2=time('e')
rs=0
gots.=''
gots.0=0
runlen=0
do forever
  response=''
  rc = SockRecv(gosock, "response", 1000)
  if response<>'' then do
     rs=rs+1
     gots.rs=response   
     gots.0=rs
     runlen=runlen+length(response)
  end 
  if verbose=1 then say " ... :" runlen
  if rs=1 | (rs//10)=1 then say rs" ... got "runlen " bytes of the response "
  if rc<=0 then leave
end 

rc = SockClose(gosock)

tim3=time('e')
say  ' ... response complete. Got' runlen 'bytes.'

if runlen=0 then exit

got=''
do mm=1 to rs
   got=got||gots.mm
end 
drop gots.

findit=crlf||crlf
foo=pos(findit,got)
t1=substr(got,1,foo-1)

/* look for 401 return code */
parse var t1  line1 '0d0a'x t2
parse var line1 . icode .
if icode<>401  then signal writeit

if isdigest<>'DIGEST' then do
  goo1=yesno('  Unauthorized: retry with (new) password')
  if goo1<>1 then signal writeit
  isdigest=0
end

parse var upwd_hold gg username password
upwd=make_auth(t2,username,password)
if upwd<>0 then signal setup1

writeit:                        /* jump here to write stuff */


if output_mode>=2  then do
   say
   say cy_ye||"The response line, and response headers: "normal;say " "
   say t1
   if output_mode=2 then do
      t2=got
   end
   else do
      if use_verb='POST' | use_verb='PUT' then do
         t2=message||'0d0a'x||'-- end of request body --'||'0d0a'x||'0d0a'x||got
      end
      else do
         t2=message||got
      end 
   end
   signal outit
end 

if output_mode=1 then do             /* save response verbatim */
  t2=got
  signal outit
end

say
say cy_ye"The response line, and response headers: "normal;say " "
say t1

/* see if any transfer encodings to do */
telist='';CELIST=''
deltabase='';crange='';ccontrol=''
ims='' ; etag=''
do until t1=""
    parse var t1 aa '0d0a'x  t1
    parse  upper var aa a1a ':' a1b
    if a1a='TRANSFER-ENCODING' then telist=telist','a1b
    if a1a='CONTENT-ENCODING' then Celist=Celist','a1b
    if a1a='CACHE-CONTROL' then ccontrol=a1b
    if a1a='DELTA-BASE' then deltabase=strip(strip(a1b),,'"')
    if a1a='IM' then ims=strip(strip(a1b),,'"')
    if a1a='ETAG' then etag=strip(strip(a1b),,'"')
    if a1a='CONTENT-RANGE' then crange=strip(strip(a1b),,'"')
end 

celist=translate(strip(space(translate(celist,' ',','||'0d0a09'x),1)))

t2=substr(got,foo+length(findit))

/* if found transfer encodings, see if you can do 'em 
(you can always do chunk) */
if telist<>'' & output_mode=0 then do
   telist=translate(telist,' ',',')
   do ww=words(telist) to 1 by -1    /* always do in reverse order of encoding */
      atype=strip(word(telist,ww))
      select
         when abbrev(atype,'CHUNK')=1 then do
           say " "
           say " Chunked response -- "reverse"will unchunk "normal
           t2=unchunk(t2)
         end
         when (atype='GZIP' | atype='COMPRESS') & do_gzip=1 then do
            say " GZIP transfer-encoded response -- "reverse"will decompress "normal
            t2=sref_ungzip(t2)
         end /* do */
         otherwise nop             
      end      /* select */
   end          /* transfer encoding options */
end             /* telist not empty */


/* if found INSTANCE encodings, see if you can do 'em  */
if icode=226 & ims<>'' & output_mode=0 then do
   say
   diff_on_range=0 ; range1='' ; range2=''
   ims=translate(ims,' ',','||'0d0a0900'x)

/* check for range before gdiff or diffe */
   irr=wordpos('RANGE',ims)
   if irr>0 then do
       parse var crange range1 '-' range2 '/' .
   end 
   if irr>0 & irr < words(ims) then do
        irr2=max(wordpos('DIFFE',ims),wordpos('GDIFF',ims))
        if irr<irr2 then diff_on_range=1
   end 
   
   do ww=words(ims) to 1 by -1    /* always do in reverse order of encoding */
      atype=strip(word(ims,ww))
      select
         when (atype='GZIP' | atype='COMPRESS') then do
            say " "
            say " GZIP IM-encoding -- "reverse"will decompress "normal
            t2=sref_ungzip(t2)
            if t2='' then exit
         end 
         when atype='GDIFF'  then do
            t2=sref_unGdiff(deltabase,base_tag_list,T2)
            if t2='' then exit
            say  " unGDIFF applied to instance "
         end 
         when atype="DIFFE" then do
            t2=sref_unGNUdiff(deltabase,base_tag_list,T2)
            if t2='' then exit
            say " unGNUdiff applied to instance "
         end 
         otherwise nop             
      end      /* select */
   end          /* instance encoding options */
end             /* ims not empty */

if (icode=200 | icode=226) & delta_dir<>'' & crange='' then 
   call save_instance              /* use etag, delta_dir, and t2 globals */

/* if 304, then see if you can display the base-instance as is */
if icode=304 & delta_dir<>'' then  t2=get_instance()     /* use etag, etc. globals */

/* if found CONTENT encodings, see if you can do 'em  */
if Celist<>'' & output_mode=0 then do
   Celist=translate(Celist,' ',','||'0d0a0900'x)
   do ww=words(Celist) to 1 by -1    /* always do in reverse order of encoding */
      atype=strip(word(Celist,ww))
      select
         when (atype='GZIP' | atype='COMPRESS')  then do
            say " "
            say " GZIP content-encoding -- "reverse"will decompress "normal
            t2=sref_ungzip(t2)
         end /* do */
         otherwise nop             
      end      /* select */
   end          /* content encoding options */
end             /* celist not empty */

outit:
if outfile='' then do
   say "Done (results NOT saved) "

   exit 0
end 

eek=0
if outfile<>"." then do
  tt=outfile
  foo=sysfiledelete(tt)
  eek=charout(tt,t2,1)
  say " "
end
d1=strip(tim2-tim1,'t',0) ; d2=strip(tim3-tim2,'t',0)
amm=cy_ye"Elapsed time: "normal||bold||d1||normal "to establish connection. "bold||d2||normal " duration"
say amm

if eek<>0 then do
   say "Error: unable to write response to "outfile ": "eek
end
else do
  if outfile<>"." then do
     if output_mode<>0 then
         say "Entire response ("||length(t2)||" bytes in headers, body etc.) written to "bold||outfile||normal
     else
       say "A "||length(t2)||" byte response was written to "bold||outfile||normal
  end
end

d1=strip(tim2-tim1,,'0') ; d2=strip(tim3-tim2,,'0')
if viewer<>'' & ( cmd_mode=0 | viewit=1) then do
    aa=1
    if viewit<>1 then do
       aa=yesno(normal"  "bold"View the response (using "reverse||viewer||normal") ",,'N')
    end
   if aa=1 then do
      if viewer_not_pm=1 then
         arf='@START /f /c "'||strip(outfile)||' == DoGET request for '||strip(left(server' 'request,60))||'" 'viewer' 'outfile
      else
         arf='@START /f  "'||strip(outfile)||' == DoGET request for '||strip(left(server' 'request,60))||'" 'viewer' 'outfile
       address cmd arf
   end /* do */
end


exit 0

err1:
say "Rexx error "rc " at line "sigl
exit

abend:
tim3=time('e')
if gosock<>0 then do
  say "Closing socket "gosock
  rc=sockshutdown(gosock,2)
  rc = SockClose(gosock)
  dumpit=yesno('Write 'runlen' recieved bytes?')
  if dumpit=1 then do
     t2=''
     do mm=1 to rs
        t2=t2||gots.mm
     end 
     drop gots.
     signal outit
  end
  exit
end

/* --- Load the function library, if necessary --- */
load:

saves.0=0

signal on error name err1 ; signal on syntax name err1 
signal on halt name abend

if RxFuncQuery("SockLoadFuncs")=1 then do      /* already there */
  call RxFuncAdd "SockLoadFuncs","rxSock","SockLoadFuncs"
  call SockLoadFuncs
end

/* Load up advanced REXX functions */
foo=rxfuncquery('sysloadfuncs')
if foo=1 then do
  call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
  call SysLoadFuncs
end

norexxlib=0
foo=rxfuncquery('rexxlibregister')
if foo=1 then do
 oy=rxfuncadd( 'rexxlibregister','rexxlib', 'rexxlibregister')
 if oy=0 then call rexxlibregister
end
foo=rxfuncquery('inkey')
if foo=1 then  norexxlib=1



signal on error name err2 ; signal on syntax name err2
enable_rsync2=1
if rxfuncquery('rx_md4')=1  then do
    aa=RXFuncAdd( 'RXRsyncLoad', 'RXRSYNC', 'RxRsyncLoad')
    if aa=0 then call RxRsyncLoad
    if rxfuncquery('rx_md4')=1  then  enable_rsync2=0
end
signal on syntax name err1 ; signal on error name err1 
return
err2:
enable_rsync2=0
return 

/* get the hostname (aa.bb.cc) for this machine
   Developed by Timur Kazimirov  */

get_hostname:procedure
if \RxFuncQuery("SockLoadFuncs")
  then
    nop
  else
    do
      call RxFuncAdd "SockLoadFuncs","rxSock","SockLoadFuncs"
      call SockLoadFuncs
    end
dot_addr = SockGetHostId()
rc = SockGetHostByAddr(dot_addr, "host.")
return host.name


/******************/
/* check for delta prerequisitces */
check_delta_dir:

if delta_dir='' then return 0           /* no need to check */

if pos(':',delta_dir)=0 then do
   foo=strip(directory(),,'\')
   parse var foo adrive ':' .
end
else do
  delta_dir=strip(strip(delta_dir),'t','\')
  parse var delta_dir adrive ':' .
end

/* rexxlib is REQUIRED */
if norexxlib=1 then do
   say "Warning: DELTA not supported, could not find REXXLIB.DLL (is it in your LIBPATH?) "
   delta_dir=''
   return 0
end 

ddt=delta_dir
if right(ddt,1)=':' then ddt=ddt'\'
if dosisdir(ddt)=0 then do
   say 'Warning: DELTA not supported, no such directory='ddt
   delta_dir=''
   return 0
end 

ff=dosfilesys(adrive)
if abbrev(ff,'HP')=0 then do
   say 'Warning: DELTA not supported, 'adrive' drive not HPFS= 'ff
   delta_dir=''
   return 0  
end


/* load RXGDIFF dll */
if rxfuncquery('rxGdiff')=1  then do
    call RXFuncAdd 'RXGdiffLoad', 'RXGDIFF', 'RxGdiffLoad'
    call RxGdiffLoad
end
if rxfuncquery('rxGdiff')=1  then do
   say "Warning: DELTA not supported, could not find RxGDIFF.DLL (is it in your LIBPATH?) "
   delta_dir=''
   return 0
end

/* Load the rxgzlib functions */
if rxfuncquery('rxgzLoadFuncs')=1 then do
   foo=RxFuncAdd( 'rxgzLoadFuncs', 'rxgzLIB', 'rxgzLoadFuncs')
   call rxgzLoadFuncs
end
if rxfuncquery('rxGZDeflateFile')=1 then do
   say "Warning: DELTA not supported, could not find RxGzLIB.DLL (is it in your LIBPATH?) "
   delta_dir=''
   return 0
end


/* check that you can run gnudiff */
aa=rxqueue('S','SESSION')
do forever
 if queued()=0 then leave
 pull goo
end
/* expected response: diff - GNU diffutils 2.7.1 */
address cmd '@'GNUdiff ' -v |  rxqueue '
goo=''
if queued() then do
  pull goo
end 
aa=rxqueue('S',aa)
if goo='' then do
   say "Warning: DELTA not supported, GNUDIFF.EXE did not run (is it in your PATH?) "
   delta_dir=''
   return 0
end 
goo2=strip(translate(goo))
if abbrev(goo2,'DIFF')<>1 then do
   say "Warning: DELTA not supported, unexpected GNUDIFF version "
   delta_dir=''
   return 0
end

return 1


/****************/
/* figure out batch mode */
do_batch:
parse arg asis

if asis=1 then do
    goo=afil
end 
else do
  do_pause=0
  afil=strip(server)
  iss=stream(afil,'c','query size')
  if iss=0 | iss='' then do
     say 'Sorry, could not find 'afil
     exit
  end 
  goo=charin(afil,1,iss); foo=stream(afil,'c','close')
end

/* concatenate , lines, etc. */
goo2=''
roptions.=''
roptions.0=0

do until goo=''
   parse var goo aline '0d0a'x goo ; aline=strip(aline)
   if aline='' then iterate
   if  abbrev(aline,';')=1 then  iterate
   if abbrev(aline,',')=1 then
      goo2=goo2||subsrt(aline,2)
   else
      goo2=goo2||'0d0a'x||aline
end
do until goo2=''
   parse var goo2 aline '0d0a'x goo2 ; aline=strip(aline)
   if aline='' then iterate
   if abbrev(aline,',')=1 then iterate

   parse var aline atype ':' avalue ; atype=translate(strip(atype))
   atype=strip(translate(atype))
   select
      when atype='REQUEST' then  request=space(avalue,0)

      when atype="REQUEST_OPTION" | atype="OPTION" then do
           nreqopt=roptions.0+1
           roptions.nreqopt=fix_option(strip(avalue),1)
           roptions.0=nreqopt
      end 
      when atype='SERVER' then server=space(avalue,0)
      when atype="HTTP_VER" | atype="VER" then http_ver=space(avalue,0)
      when atype="USE_VERB" | atype="VERB" | atype="METHOD" then use_VERB=space(avalue,0)
      when atype='EMULATE_FORM' then emulate_form=space(avalue,0)

      when atype="HOST_HEADER" | atype="HOST:" then sshost=space(avalue,0)
      when atype='MODE' | atype="OUTPUT_MODE" then do
              output_mode=space(avalue,0)
              if output_mode=2  then output_mode=3
      end 

      when atype='VIEWIT' then viewit=space(avalue,0)
      when atype='DO_PAUSE' | atype="PAUSE" then do_pause=space(avalue,0)
      when atype='RSYNCFILE' then RsyncFile=space(avalue,0)
      when atype='UPLOADFILE' then UploadFile=space(avalue,0)

      when atype='HEADER' then do
        if opts<>'' then
          opts=opts||strip(avalue)||'0d0a'x
        else
           opts=strip(avalue)||'0d0a'x
      end 
      when atype='OUTFILE' | atype="OUTPUT" then outfile=space(avalue,0)
      when atype='DO_GZIP' then do_gzip=space(avalue,0)
      when atype='SENDCLOSE' then sendclose=space(avalue,0)
      when atype='USERNAME' then username=space(avalue,0)
      when atype='PASSWORD' then password=space(avalue,0)
      otherwise nop
   end
 end /* do */
if server='.' then server=mehost
if username<>'' then do
  upwd=username':'password
  if upwd<>' ' then do
    upwd=space(strip(upwd))
    upwd=mk_base64(translate(upwd,':',' '))
    upwd='Basic 'upwd
  end
end

if roptions.0>0 then do         /* add request options */
   iqadd=0
   if pos('?',request)=0 then do
        request=request||'?'
        iqadd=1
   end
   do mm=1 to roptions.0   
      if iqadd=1 then do
       request=request||roptions.mm
       iqadd=0
      end
      else do
         request=request||'&'||roptions.mm
      end
   end
end 


if dopause=1 then do
say cy_ye"Your request: "normal
   say "Server: " server
   say "Request selector: " request
   if upwd<>'' then say 'Authorization: 'upwd
   say reverse"Custom headers:"normal
   ao=opts
   do until ao=''
      parse var opts ali '0d0a'x ao
      say "    "ali
  end
  call charout,"hit any key to continue .... "
  foo=sysgetkey('noecho')

end 
say
batchmode=1
save_doget_request=0
return 1

/****************/
show_intro:
say clear_screen
say cy_ye"DOGET"normal" will issue a request to an HTTP server, and will:"
say "  "bold"*"normal" display the response headers "
say "  "bold"*"normal" save the  response body to: "reverse||outfile||normal
say "Although DOGET is typically used for "bold"GET"normal" method requests, other methods are"
say "supported; including HEAD, POST, PUT, DELETE, OPTIONS, and TRACE."
say
say bold"Features include:"
say "  "bold"*"normal" Inclusion of authorization info (username and password) --"
say "    "bold"basic"normal" and "bold"digest"normal" authentication are supported"
say "  "bold"*"normal" The ability to include custom request headers "
say "  "bold"*"normal" http/1.1 capabilities include unchunking, GZIP decompression, and"
say "    delta-encoding undifferencing"
say
say bold"Usage:"normal
say " Command line mode: "bold"DOGET"normal" "reverse"server"normal" "reverse" request"normal" ["reverse"-options"normal"] "
say "       * You can specify zero, one, or several different "reverse" -options"||normal
say "       * Examples: "bold"D:>doget  www.foobar.net   /sports/index.html"normal
say "       *           "bold"D:>doget  www.mysite.org /tst1.gif -use_verb: HEAD -mode: 2"normal

say " Batch mode:  "bold"DOGET"normal" = "reverse"filename.ext"normal
say '          * FILENAME.EXT should be the name of a 'bold'DOGET'normal' batch file. A batch'
say '            file can contain several options (one option per line). '
say " Interactive mode: just enter "bold"DOGET"normal" at an OS/2 prompt, and answer away..."
say


do forever
  say 
  vuparams=yesno("More info",'No OptionsInfo','N')
  if vuparams=0 then exit
  if vuparams=1 then call do_batchdoc
end

exit

/**************************/
do_batchdoc:

say
say "You can specify "reverse"options"normal" either on the command line, or in a DOGET batch file."
say "  * Command line: each option should begin with a "reverse"-"normal
say "  *   Batch file: each option should be on a seperate line." 
say "                  ... lines that begin with a ; are comments "
say "                  ... line that begin with ! are continuation lines"
say 
say "In both cases, the syntax of each option is... "
say "   "bold"Option:"normal" option_value "
say

      call charout,reverse||"hit any key to continue"||normal
      getmore=sysgetkey('echo');say 


say "The currently supported options are:"
say bold"   Do_GZIP: "normal' If 1,then attempt to unGZIP (if GZIP content/transfer encoding'
say bold"   DO_Pause: "normal' Pause before connecting to the server '
say bold" Emulate_FORM: "normal' Emulate HTML FORM when doing a POST request '
say bold" HOST_header:"normal" The value to use for  the Host: header. "
say bold"    Header: "normal' A header to add. You can have as many Header:  entries as needed.'
say     '             Example: 'bold' Header: X-relevance: few 'normal
say bold"  HTTP_VER: "normal' The HTTP version to report (such as HTTP/1.0 or HTTP/1.1)'
say bold"    Option: "normal' A request option. You can have many 'bold"Option:"normal" lines. Options will"
say     '             be added to the 'bold"Request:"normal" line after a ?, and are seperated by &"
say bold"   Outfile: "normal' Name of the output file'
say bold'Output_Mode: 'normal' What to write to outfile (0=response body, 1=full response,'
say'                2=request, and full response) '
say bold"  PassWord: "normal' Your password '
say bold" RsyncFile: "normal' A file to use to construct an rsync-synopsis'
say bold"   Request: "normal' the request "selector". '
say bold" SendClose: "normal' If 1, then immediately close the connection'
say bold'    Server: 'normal' IP name/number of the server. For example,'bold' www.mysite.org'normal
say bold" UploadFile: "normal' A file containing contents to use in PUT and POST requests'
say bold"  UserName: "normal' Your username '
say bold"  Use_VERB: "normal' The HTTP request method (GET HEAD POST PUT DELETE TRACE OPTIONS)'
say bold"    ViewIt: "normal' If ViewIt: 1, then display response (using 'reverse||viewer||normal

      call charout,reverse||"hit any key to continue"||normal
      getmore=sysgetkey('echo');say 

say
say bold"Notes:"normal
say bold"  * "normal'For almost all of these parameters, default values are  '
parse source goo goo1 doget_cmd
say '    set in the user-configurable parameters section of '
say '    'doget_cmd
say bold"  * In a BATCH file, the REQUEST and SERVER options are required! "
say
say bold" Examples of  BATCH files: "normal
say 'Example 1:'
say '         request: samples/dir.doc'
say '         server: www.mysite.org'
say '         header: x-wow: abc'
say '         Username: joey'
say '         password: skeezik'
say '         header: x-home: Maryland'
say '         outfile: d:\results\ver1.lst'
say '         do_pause: 1'
say
say 'Example 2'
say '         server: www.mysite.org'
say '         request: cgi-bin/test-cgi.cmd'
say '         option: foo=the first one'
say '         option: bar=the 2nd one'


      getmore=sysgetkey('echo');say 
return 0

/**************************/
do_vuparams:

foo=stream(somewhere,'c','open read')
if abbrev(strip(translate(foo)),'READY')=0 then do
   say "Sorry, can not read "somewhere
   exit
end 
jsz=stream(somewhere,'c','query size')
if jsz=0 | jsz='' then do
   say "Sorry, can not read "somewhere
   exit
end 
aa=charin(somewhere,1,jsz)
foo=stream(somewhere,'c','close')
parse var  aa . '/*BEGINUSER*/' stuff '/*ENDUSER*/' .

ii=0
commenton=0
do until stuff=''
   c2=0
   parse var stuff aline '0d0a'x stuff
   if pos('/*',aline)>0 then do
        parse var aline . '/*' aline ; aline='* 'aline
        commenton=1
   end 
   if pos('*/',aline)>0 then do
        parse var aline aline '*/' .
        c2=1
   end 
   if commenton=0 then
      say bold||aline||normal
   else
     say aline
   ii=ii+1
   if ii=20 then do
      aa=yesno("continue ....",,'Y')
      if aa=0 then return 1
      ii=0
   end 
   if c2=1 then commenton=0
end 
return 1

/**************/
/* ask user for a variety of other fields */
do_getmore:
isdigest=0
parse arg getmore 


uploadFile=''
use_verb1=yesno('Select request method:','GET HEAD POST 4_PUT DELETE TRACE OPTIONS ','G')+1
use_verb=strip(word('GET HEAD POST PUT DELETE TRACE OPTIONS ',use_verb1))

say 

rangereq=yesno('Range request?','No Yes 2','N')
if rangereq>0  then do
   if rangereq=1 then
     call charout,'Range  : From (0 to infinity): '
   else
     call charout,'Range 1: From (0 to infinity): '
   pull r1
   call charout,'         To ('r1+1' to infinity): '
   pull r2
   r1=strip(r1) ;r2=strip(r2)
   select
     when datatype(r1)<>'NUM' | datatype(r2)<>'NUM' then norange=1
     when r1>=r2 then norange=1
     when r1<0 then norange=1
     otherwise norange=0
   end
   if norange=1 then do
        say "Bad values for range. Range request will NOT be made "r1 ','r2
   end 
   else do
      arr='Range: bytes='||r1||'-'||r2
   end 

   if rangereq=2 & norange=0 then do
     call charout,'Range 2: From (0 to infinity): '
     pull r1
     call charout,'         To ('r1+1' to infinity): '
     pull r2
     r1=strip(r1) ;r2=strip(r2)

     select
         when datatype(r1)<>'NUM' | datatype(r2)<>'NUM' then norange=1
         when r1>=r2 then norange=1
         when r1<0 then norange=1
         otherwise norange=0
     end
     if norange=1 then do
          say "Bad values for range 2. Range request will NOT be made "
     end 
     else do
         arr=arr||', '||r1||'-'||r2
     end
   end 
   if norange=0 then opts=opts||arr||crlf
end /* do */


say " Enter a (space seperated) USERNAME PASSWORD (ENTER=None, or user pwd DIGEST):"
   call charout,"    "cy_ye":"normal" "

  parse pull upwd
  parse var upwd uu pp isdigest
 
  if save_doget_request=1 then do
   isave=saves.0+1
   saves.isave='USERNAME: 'uu
   isave=isave+1
   saves.isave='PASSWORD: 'pp
   saves.0=isave
  end
  if upwd<>' ' then do
    upwd=space(strip(upwd))
    upwd=mk_base64(translate(upwd,':',' '))
    upwd='Basic 'upwd  
  end

  say
  say " Enter optional request headers (?=examples, ENTER=no more)"
  aopt=0
  do until aopt=""
      call charout,"    "cy_ye":"normal" "

      parse pull aopt
      aopt=strip(aopt)
      if aopt="" then leave
      if aopt="?" then do
              say " "bold"Examples:"normal
              say "    Connection:keep-alive"
              say "    Range:bytes=0-50,200-400"
              say " "
              say " "bold"or"normal", to load in a file containing request headers: "
              say "     FILE=filename.ext "
              say
              iterate
      end  /* Do */
      if abbrev(translate(aopt),'FILE=')=1 then do
           parse var aopt . '=' afil
           goo=charin(afil,1,chars(afil)); foo=stream(afil,'c','close')
           opts=opts||goo
      end 
      else do
        opts=opts||aopt||crlf
        if save_doget_request=1 then do
          isave=saves.0+1
          saves.isave='HEADER: 'aopt
          saves.0=isave
        end
      end
  end 

if getmore<>2 then return 1

  say
  call charout, "  Enter alternative Host: header (.=suppress) "
  call charout,cy_ye":"normal" "
  parse pull sshost

  sendclose=yesno(' Send a "Connection: Close" header ',,'Y')

  say "Output file (ENTER="reverse||outfile||normal"):"
  call charout,"    "cy_ye":"normal" "

  parse pull outfile1
  if outfile1<>"" then outfile=outfile1


  output_mode=yesno('Write to output file','Response Hdr&Response Everything','R')
  select 
     when output_mode=1 then output_mode=2
     when output_mode=2 then output_mode=3
     otherwise nop
 end

  if output_mode=0 then do
     do_gzip=yesno('unGZIP, when GZIP is a Transfer or Content Encoding',,'Y') 
   end


  if delta_dir<>'' then do
    disable_delta=yesno(normal||"  "||bold||"Disable delta-encoding "normal,,'N')
    if disable_delta=1 then delta_dir=''
  end

  if enable_rsync2=1 then do
    enable_rsync=yesno('Include an Rsync-signature header',,'N')
    if enable_rsync=1 then do
       do forever
         say '    Enter name of "old version" file (?DIR =display directory, .=Quit):'
         call charout,bold '     ? 'normal ; pull oldverfile
         if oldverfile='.' then do
                enable_rsync=0; leave
         end /* do */
         if oldverfile='?DIR' then do
             call get_dir
             iterate
         end
         if pos('\',oldverfile)=0 then do
             oldverfile=deltas_dir'\'||strip(oldverfile)
         end /* do */
         
         if  stream(oldverfile,'c','query exists')='' then iterate
         leave
       end
    end
  end  

return 1


/***********/
/* stuff to PUT or POST */
get_upstuff:

say
say "For "bold||use_verb||normal" method requests, a request body is needed..."
say
afile=yesno('  Read contents from a file (NO=enter from keyboard)',,'N')
if afile=1 then do 
   do forever
        call charout, "  File containing contents to "use_verb": "
        parse pull sfile
        ssize=stream(sfile,'c','query size')
        if ssize='' | ssize=0 then do
           say "  Error could not read file "sfile
           iterate
        end
        leave
    end
    upstuff=charin(sfile,1,ssize)
    foo=stream(sfile,'c','close')
    say "  Total of "ssize" bytes in "sfile
    uploadfile=sfile
    return 
end             /* afile=1 */

say "  Enter contents to send to the server. End with a blank line. "
upstuff=' '             /* 1 space is default */
do forever
 call charout, reverse||"   ? "||normal
 parse pull upstuff1
 if upstuff1='' then do
   ssize=length(upstuff)
   return
 end
 if upstuff=' ' then
     upstuff=upstuff1
 else
     upstuff=upstuff||'0d0a'x||upstuff1
end


/************/
get_dir:
       parse var infile . thisdir

      if thisdir="" then do
           if deltas_dir='' & deltas_dir<>0 then do
               thisdir=strip(directory(),'t','\')||'\*.*'
           end
           else do
               thisdir=deltas_dir||'\*.*'
           end /* do */
       end
       say
       say reverse ' List of files in: ' normal bold thisdir normal
       do while queued()>0
            pull .
       end /* do */
       toget=thisdir

       '@DIR /b  '||toget||' | rxqueue'
       foo=show_dir_queue('*')
       say
       infile=''
return 1

/************/
/* make an authorization header */
make_auth:

ifoo=0
parse arg r2,USERNAME0,PASSWORD0
/* basic or digest? */
do until r2=''
   parse var r2 a1 '0d0a'x r2 ; a1=strip(a1)
   parse var a1 atype ':' aheader ;atype=strip(atype)
   if translate(atype)<>'WWW-AUTHENTICATE' then iterate
   ifoo=1
   leave
end

if ifoo=0 then return 0

/*else-- parse r2 and create digest style request header */
    call charout,'  'bold'Username'normal' (enter='username0'):'
    parse pull username
    if username='' then username=username0
    
    call charout,' 'bold'Password'normal' (enter='password0'):'
    parse pull passwd
    if passwd='' then passwd=password0

    parse var aheader atype aheader
    atype=strip(translate(atype))
    if atype='BASIC' then do
       upwd=mk_base64(strip(username)':'strip(passwd))
       upwd='Basic 'upwd
       return upwd
    end /* do */

    call charout," Qop response (1=yes): "
     parse pull iqop
    upwd=digest_mkupwd(request,username,passwd,aheader,iqop)
/* say " Upwd after dig " upwd */
    if upwd=0 then return 0
    return upwd   


/************/
/* create a base64 packing of a message */
mk_base64:procedure

do mm=0 to 25           /* set base 64 encoding keys */
   a.mm=d2c(65+mm)
end /* do */
do mm=26 to 51
   a.mm=d2c(97+mm-26)
end /* do */
do mm=52 to 61
   a.mm=d2c(48+mm-52)
end /* do */
a.62='+'
a.63='/'

parse arg mess
s2=x2b(c2x(mess))
ith=0
do forever
   ith=ith+1
   a1=substr(s2,1,6,0)
   ms.ith=x2d(b2x(a1))
   if length(s2)<7 then leave
   s2=substr(s2,7)
end /* do */
pint=""
do kk=1 to ith
    oi=ms.kk ; pint=pint||a.oi
end /* do */
j1=length(pint)//4
if j1<>0 then pint=pint||copies('=',4-j1)
return pint



/********************************************/
/*Given client digest auth, form local copy of "response";
 and compare to her "response" */

digest_mkupwd:procedure
parse arg auri,username,passwd,aheader,iqop


realm='' ; nonce=''; ;qop='';opaque=''
do until aheader=''
   parse var aheader a1 ',' aheader
   parse var a1 a1a '=' a1b 
   a1bb=strip(strip(a1b),,'"') ; a1a=strip(upper(a1a))
   select 
      when  a1a='REALM' then realm=a1bb
      when a1a='NONCE' then nonce=a1bb
      when a1a='QOP' & iqop=1 then qop=a1bb
      when a1a='OPAQUE' then opaque=a1bb
      otherwise nop
   end
end /* do */

/* if username, response, uri, nonce, realm ='', then failure */
if username='' | nonce='' | realm='' then do
    say 'Insufficient information; can not create digest style Autorization request '
    return 0
end /* do */

if abbrev(translate(auri),'HTTP://')=0 then auri='/'strip(auri,'l','/')

username=strip(username); passwd=strip(passwd)

qop=strip(qop)
if pos('AUTH',translate(qop))>0 then do
  cnonce='testhere'
  nc=1
  qop='auth'
end /* do */
else do
  cnonce=''; nc='';qop=''
end

VERB='GET'

/* 1) form h(a1) */
  a1=username':'realm':'passwd
  ha1=lower(sref_md5x(a1))

/* form h(a2) */
  a2='GET:'auri
  ha2=lower(sref_md5x(a2))

/* if no qop */
if translate(qop)<>'AUTH' then do 
    resp1=ha1':'nonce':'ha2
    hresp=sref_md5x(resp1)
end /* do */
else do         /* AUTH */
    resp1=ha1':'nonce':'nc':'cnonce':'qop':'ha2
    hresp=sref_md5x(resp1)
end /* do */

rar='Digest username="'username'", realm="'realm'"'
rar=rar', uri="'auri'", nonce="'nonce'"'
if translate(qop)='AUTH' then do
   rar=rar', qop='qop', cnonce="'cnonce'", nc='nc
end /* do */
rar=rar', response="'hresp'"'

if opaque<>'' then rar=rar', opaque="'opaque'"'


return rar

/*
Authorization: Digest username="Mufasa", realm="testrealm@hopf.math.nwu.edu", ur
i="/testpage/digest/index.html", nonce="86a88f9b4d927b79d9a21c53f0757a3abd", res
ponse="d35edc9327c6149f0c3a6c5a46e84ed8"
Connection: close
*/



/***********/
/* A fully rexx md5 digest computation procedure.
  This is NOT FAST  --  for small strings it is
  toleable (0.15 seconds on a p166 for 50 character strings),
  but for larger strings (or files) it can take many seconds --
  you should instead use a DLL product (such as MD5_OS2) */


/*  ------------------------------ */
sref_md5x:procedure
parse arg stuff

numeric digits 11
lenstuff=length(stuff)

c0=d2c(0)
c1=d2c(128)
c1a=d2c(255)
c1111=c1a||c1a||c1a||c1a
slen=length(stuff)*8
slen512=slen//512

/* pad message to multiple of 512 bits.  Last 2 words are 64 bit # bits in message*/
if slen512=448 then  addme=512
if slen512<448 then addme=448-slen512
if slen512>448 then addme=960-slen512
addwords=addme/8

apad=c1||copies(c0,addwords-1)

xlen=reverse(right(d2c(lenstuff*8),4,c0))||c0||c0||c0||c0  /* 2**32 max bytes in message */

/* NEWSTUFF is the message to be md5'ed */
newstuff=stuff||apad||xlen

/* starting values of registers */
 a ='67452301'x;
 b ='efcdab89'x;
 c ='98badcfe'x;
 d ='10325476'x;

lennews=length(newstuff)/4

/* loop through entire message */
do i1 = 0 to ((lennews/16)-1)
  i16=i1*64
  do j=1 to 16
     j4=((j-1)*4)+1
     jj=i16+j4
     m.j=reverse(substr(newstuff,jj,4))
  end /* do */

/* transform this block of 16 chars to 4 values. Save prior values first */
 aa=a;bb=b;cc=c;dd=d

/* do 4 rounds, 16 operations per round (rounds differ in bit'ing functions */
S11=7
S12=12
S13=17
S14=22
  a=round1( a, b, c, d,   0 , S11, 3614090360); /* 1 */
  d=round1( d, a, b, c,   1 , S12, 3905402710); /* 2 */
  c=round1( c, d, a, b,   2 , S13,  606105819); /* 3 */
  b=round1( b, c, d, a,   3 , S14, 3250441966); /* 4 */
  a=round1( a, b, c, d,   4 , S11, 4118548399); /* 5 */
  d=round1( d, a, b, c,   5 , S12, 1200080426); /* 6 */
  c=round1( c, d, a, b,   6 , S13, 2821735955); /* 7 */
  b=round1( b, c, d, a,   7 , S14, 4249261313); /* 8 */
  a=round1( a, b, c, d,   8 , S11, 1770035416); /* 9 */
  d=round1( d, a, b, c,   9 , S12, 2336552879); /* 10 */
  c=round1( c, d, a, b,  10 , S13, 4294925233); /* 11 */
  b=round1( b, c, d, a,  11 , S14, 2304563134); /* 12 */
  a=round1( a, b, c, d,  12 , S11, 1804603682); /* 13 */
  d=round1( d, a, b, c,  13 , S12, 4254626195); /* 14 */
  c=round1( c, d, a, b,  14 , S13, 2792965006); /* 15 */
  b=round1( b, c, d, a,  15 , S14, 1236535329); /* 16 */

  /* Round 2 */
S21=5
S22=9
S23=14
S24=20
a= round2( a, b, c, d,   1 , S21, 4129170786); /* 17 */
d= round2( d, a, b, c,   6 , S22, 3225465664); /* 18 */
c=  round2( c, d, a, b,  11 , S23,  643717713); /* 19 */
b=  round2( b, c, d, a,   0 , S24, 3921069994); /* 20 */
a=  round2( a, b, c, d,   5 , S21, 3593408605); /* 21 */
d=  round2( d, a, b, c,  10 , S22,   38016083); /* 22 */
c=  round2( c, d, a, b,  15 , S23, 3634488961); /* 23 */
b= round2( b, c, d, a,   4 , S24, 3889429448); /* 24 */
a= round2( a, b, c, d,   9 , S21,  568446438); /* 25 */
d= round2( d, a, b, c,  14 , S22, 3275163606); /* 26 */
c=  round2( c, d, a, b,   3 , S23, 4107603335); /* 27 */
b=  round2( b, c, d, a,   8 , S24, 1163531501); /* 28 */
a=  round2( a, b, c, d,  13 , S21, 2850285829); /* 29 */
d=  round2( d, a, b, c,   2 , S22, 4243563512); /* 30 */
c=  round2( c, d, a, b,   7 , S23, 1735328473); /* 31 */
b= round2( b, c, d, a,  12 , S24, 2368359562); /* 32 */

  /* Round 3 */
S31= 4
S32= 11
S33= 16
S34= 23
a= round3( a, b, c, d,   5 , S31, 4294588738); /* 33 */
d=  round3( d, a, b, c,   8 , S32, 2272392833); /* 34 */
c=  round3( c, d, a, b,  11 , S33, 1839030562); /* 35 */
b=  round3( b, c, d, a,  14 , S34, 4259657740); /* 36 */
a=  round3( a, b, c, d,   1 , S31, 2763975236); /* 37 */
d=  round3( d, a, b, c,   4 , S32, 1272893353); /* 38 */
c=  round3( c, d, a, b,   7 , S33, 4139469664); /* 39 */
b=  round3( b, c, d, a,  10 , S34, 3200236656); /* 40 */
a=  round3( a, b, c, d,  13 , S31,  681279174); /* 41 */
d=  round3( d, a, b, c,   0 , S32, 3936430074); /* 42 */
c=  round3( c, d, a, b,   3 , S33, 3572445317); /* 43 */
b=  round3( b, c, d, a,   6 , S34,   76029189); /* 44 */
a=  round3( a, b, c, d,   9 , S31, 3654602809); /* 45 */
d=  round3( d, a, b, c,  12 , S32, 3873151461); /* 46 */
c=  round3( c, d, a, b,  15 , S33,  530742520); /* 47 */
b=  round3( b, c, d, a,   2 , S34, 3299628645); /* 48 */

  /* Round 4 */
S41=6
S42=10
S43=15
s44=21
a=round4( a, b, c, d,   0 , S41, 4096336452); /* 49 */
d=round4( d, a, b, c,   7 , S42, 1126891415); /* 50 */
c=round4( c, d, a, b,  14 , S43, 2878612391); /* 51 */
b=round4( b, c, d, a,   5 , s44, 4237533241); /* 52 */
a=round4( a, b, c, d,  12 , S41, 1700485571); /* 53 */
d=round4( d, a, b, c,   3 , S42, 2399980690); /* 54 */
c=round4( c, d, a, b,  10 , S43, 4293915773); /* 55 */
b=round4( b, c, d, a,   1 , s44,  2240044497); /* 56 */
a=round4( a, b, c, d,   8 , S41, 1873313359); /* 57 */
d=round4( d, a, b, c,  15 , S42, 4264355552); /* 58 */
c=round4( c, d, a, b,   6 , S43, 2734768916); /* 59 */
b=round4( b, c, d, a,  13 , s44, 1309151649); /* 60 */
a=round4( a, b, c, d,   4 , S41, 4149444226); /* 61 */
d=round4( d, a, b, c,  11 , S42, 3174756917); /* 62 */
c=round4( c, d, a, b,   2 , S43,  718787259); /* 63 */
b=round4( b, c, d, a,   9 , s44, 3951481745); /* 64 */


a=m32add(aa,a) ; b=m32add(bb,b) ; c=m32add(cc,c) ; d=m32add(dd,d)

end

aa=c2x(reverse(a))||c2x(reverse(b))||c2x(reverse(C))||c2x(reverse(D))

return lower(aa)


/* round 1 to 4 functins */

round1:procedure expose m. c1111 c0 c1
parse arg a1,b1,c1,d1,kth,shift,sini
kth=kth+1
t1=c2d(a1)+c2d(f(b1,c1,d1))+ c2d(m.kth) + sini
t1a=right(d2c(t1),4,c0)
t2=rotleft(t1a,shift)
t3=m32add(t2,b1)
return t3

round2:procedure expose m. c1111 c0 c1
parse arg a1,b1,c1,d1,kth,shift,sini
kth=kth+1
t1=c2d(a1)+c2d(g(b1,c1,d1))+ c2d(m.kth) + sini
t1a=right(d2c(t1),4,c0)
t2=rotleft(t1a,shift)
t3=m32add(t2,b1)
return t3

round3:procedure expose m. c1111 c0 c1
parse arg a1,b1,c1,d1,kth,shift,sini
kth=kth+1
t1=c2d(a1)+c2d(h(b1,c1,d1))+ c2d(m.kth) + sini
t1a=right(d2c(t1),4,c0)
t2=rotleft(t1a,shift)
t3=m32add(t2,b1)
return t3

round4:procedure expose m. c1111 c0 c1
parse arg a1,b1,c1,d1,kth,shift,sini
kth=kth+1
t1=c2d(a1)+c2d(i(b1,c1,d1))+ c2d(m.kth) + sini
t1a=right(d2c(t1),4,c0)
t2=rotleft(t1a,shift)
t3=m32add(t2,b1)
return t3

/* add to "char" numbers, modulo 2**32, return as char */
m32add:procedure expose c0 c1 c1111
parse arg v1,v2
t1=c2d(v1)+c2d(v2)
t2=d2c(t1)
t3=right(t2,4,c0)
return t3

/*********** Basic functions */
/* F(x, y, z) == (((x) & (y)) | ((~x) & (z))) */
f:procedure expose c0 c1 c1111 
parse arg x,y,z
t1=bitand(x,y)
notx=bitxor(x,c1111)
t2=bitand(notx,z)
return bitor(t1,t2)


/* G(x, y, z) == (((x) & (z)) | ((y) & (~z)))*/
g:procedure expose c0 c1 c1111
parse arg x,y,z
t1=bitand(x,z)
notz=bitxor(z,c1111)
t2=bitand(y,notz)
return bitor(t1,t2)

/* H(x, y, z) == ((x) ^ (y) ^ (z)) */
h:procedure expose c0 c1 c1111
parse arg x,y,z
t1=bitxor(x,y)
return bitxor(t1,z)

/* I(x, y, z) == ((y) ^ ((x) | (~z))) */
i:procedure expose c0 c1 c1111
parse arg x,y,z
notz=bitxor(z,c1111)
t2=bitor(x,notz)
return bitxor(y,t2)

/* bit rotate to the left by s positions */
rotleft:procedure 
parse arg achar,s
if s=0 then return achar

bits=x2b(c2x(achar))
lb=length(bits)
t1=left(bits,s)
t2=bits||t1
yib=right(t2,lb)
return x2c(b2x(yib))

 /* function: Check if ANSI is activated                               */
 /*                                                                    */
 /* returns:  1 - ANSI support detected                                */
 /*           0 - no ANSI support available                            */
 /*          -1 - error detecting ansi                                 */
 CheckAnsi: 
   thisRC = -1

   trace off
                         /* install a local error handler              */
   SIGNAL ON ERROR Name InitAnsiEnd

   "@ANSI 2>NUL | rxqueue 2>NUL"

   thisRC = 0

   do while queued() <> 0
     queueLine = lineIN( "QUEUE:" )
     if pos( " on.", queueLine ) <> 0 | ,                       /* USA */
        pos( " (ON).", queueLine ) <> 0 then                    /* GER */
       thisRC = 1
   end /* do while queued() <> 0 */

 InitAnsiEnd:
 signal off error

if thisrc=1 then do
  aesc='1B'x
  cy_ye=aesc||'[37;46;m'
  cyanon=cy_ye
  normal=aesc||'[0;m'
  bold=aesc||'[1;m'
  re_wh=aesc||'[31;47;m'
  reverse=aesc||'[7;m'
  clear_screen=aesc||'[2J'
end
else do
  cy_ye="" ; normal="" ; bold="" ;re_wh="" ;clear_screen=''
  reverse=""
end  /* Do */



 RETURN 1




/*********/
/* show stuff in queue as a list */
show_dir_queue:procedure expose qlist. bold cy_ye normal reverse
parse arg lookfor
    ibs=0 ;mxlen=0
    if lookfor<>1 then
       nq=queued()
     else
        nq=qlist.0
    do ii=1 to nq
       if lookfor=1 then do
          aa=qlist.ii
          ii2=lastpos('\',aa) ; anam=substr(aa,ii2+1)
       end /* do */
       else do
          parse pull aa
          if pos(lookfor,aa)=0 & lookfor<>'*' then iterate
          parse var aa anam (lookfor) .
          if strip(anam)='.' | strip(anam)='..' then iterate
       end
       ibs=ibs+1
       blist.ibs=anam
       mxlen=max(length(anam),mxlen)
    end /* do */
arf=""
isaid=0
do il=1 to ibs
   anam=blist.il
   arf=arf||left(anam,mxlen+2)
   if length(arf)+mxlen+2>78  then do
        say arf
        isaid=(1+isaid)//22
        if isaid==0 then do
            say cy_YE " ... hit any key to continue, X to exit " NORMAL
            foo=translate(sysgetkey('noecho'))
            if foo='X' then do
                arf='' ; leave
            end /* do */
        end
        arf=""
   end /* do */
end /* do */
if length(arf)>1 then say arf
say
return 1


/***********************************/
/* ungzip a string */
sref_ungzip:procedure 
parse arg astring

awords=rxgzinflatestring(astring)

return awords


/*******************************************/
rsync_synopsis:procedure 

parse arg afile,nblocks

if nblocks='' then nblocks=45
if datatype(nblocks)<>'NUM' then nblocks=45
if nblocks<10 | nblocks>255 then nblocks=45   /* 255 limit on # of blocks */

if afile='' then return "ERROR no old-version file specified"

/* read "Afile" */
aa=translate(stream(afile,'c','open read'))
if  abbrev(aa,'READY')=0 then return "ERROR could not open "afile
isize=stream(afile,'c','query size')
if isize='' | isize=0 then do
    return 'ERROR 'afile " is unaccessible"
    exit
end
astuff=charin(afile,1,isize)
aa=stream(afile,'c','close')


blocksize=trunc(0.9999 + (isize/nblocks))
if blocksize<200 then do
    blocksize=200
    nblocks=trunc((isize/blocksize)+0.999)
end /* do */
ac1=d2c(blocksize)
ac1=right(ac1,4,x2c('00'))
ac1=ac1||d2c(nblocks)
iat=1
do mm=1 to nblocks
  if mm=nblocks then
     ablock=substr(astuff,iat)
  else
     ablock=substr(astuff,iat,blocksize)
  ac0=left(x2c(rx_rsync32_md4(ablock)),8)
  ac1=ac1||ac0
  iat=iat+blocksize
end
ac1=mkpack64(ac1)

return ac1


/***********************************/
/* undiff: given a cached instance (a base file) and a gdiff-formatted 
          difference file
   (as may be returned in a delta encoded response)output from gdiff) 
   (against this same base file) */

sref_ungdiff:procedure expose delta_dir delta_checknames basename ,
                              range1 range2 diff_on_range celist
parse arg  deltab,blist,adiff

tmpfugz=''

/* determine base file  =delta_dir||'\*.'||areq2||'.'||ahost2 */
if deltab='' then deltab=strip(blist)
if words(deltab)<>1 then do
 say "Error: no delta base: "deltab
 return ''              /* unable to do */
end

parse var delta_checknames a1 '*' a2
basename=a1||strip(deltab)||a2

if stream(basename,'c','query exists')='' then do
   say "Error could not find base-instance file "basename
   return ''
end

foo=sysgetea(basename,'CONTENTCODING','CONTCODE')
/* need to ungzip our instance to match content-coding of current request? */
doit=compare_cc(celist,contcode,'GZIP')

tmpf='DG'||dospid()||'_'||dostid()

/* temporary output file */
tmpfout=delta_dir'\'tmpf||'.DOU'
foo=sysfiledelete(tmpfout)

/* difference must be in a file */
tmpfdif=delta_dir'\'tmpf||'.DIF'
foo=sysfiledelete(tmpfdif)
foo=stream(tmpfdif,'c','open write')
if abbrev(translate(foo),'READY')=0 then do
   say "Unable to create temporary difference file "tmpfdif
   foo=stream(tmpfdif,'c','close')
   foo=sysfiledelete(tmpfdif)
   return ''
end 
foo=charout(tmpfdif,adiff,1)
if foo<>0 then do
   say "Unable to write temporary difference file "tmpfdif
   foo=stream(tmpfdif,'c','close')
   foo=sysfiledelete(tmpfdif)
   return ''
end
foo=stream(tmpfdif,'c','close')


/* if doit=GZIP, then ... */
/*   our instance has gzip, current one does not implying that the server expects */
/*   us to ungzip  before im (in order to have intances with the same content coding */
if doit='GZIP' then do 
   tmpfugz=delta_dir'\'tmpf||'.UGZ'
   foo=sysfiledelete(tmpfugz)
   say "  unGZIP of old instance...."
   astat=rxGzinflatefile(basename,tmpfugz)
   if astat<>0 then do
      say 'Error, 'astat', on unGZIP of current instance= 'basename
      return ' '
   end
   else do
      say " unGZIP of cached instance ... "
   end /* do */
   basename=tmpfugz
end 

nbasename=''
if diff_on_range=1 then do
  nbasename=gdiff_make_range(basename)
  if nbasename=''  then return ' '
  stat=rxgdiff(nbasename,tmpfdif,tmpfout,'-Q','-U')
  foo=sysfiledelete(nbasename)
end
else do         /* no range extraction */
  stat=rxgdiff(basename,tmpfdif,tmpfout,'-Q','-U')
end

if stat<>0 then do
  foo=sysfiledelete(tmpfout)
  foo=sysfiledelete(tmpfdif)
  say "Error unGdiff= "stat '('basename' 'tmpfdif
  if tmpfugz<>'' then foo=sysfiledelete(tmpfugz)
  return ''
end
foo=sysfiledelete(tmpfdif)

/* else, get the output */
iii=stream(tmpfout,'c','query size')
if iii='' | iii=0 then do
  foo=sysfiledelete(tmpfout)
  if tmpfugz<>'' then foo=sysfiledelete(tmpfugz)
  say "Error: unGdiff failed to produce an output file "
 return ''
end 
nustuff=charin(tmpfout,1,iii)
foo=stream(tmpfout,'c','close')
foo=sysfiledelete(tmpfout)

if tmpfugz<>'' then foo=sysfiledelete(tmpfugz)

return nustuff


/**************/
/* make a range for gdiffing */
gdiff_make_range:procedure expose range1 range2  tmpf delta_dir
parse arg basename

/* extract a range from instance file */
foo=stream(basename,'c','open read')
if abbrev(translate(foo),'READY')=0 then do
     say foo" Error could not open base-instance file "basename
    return ''
end
basesize=stream(basename,'c','query size')
if basesize='' | basesize=0 then do
    say "Error could not read base-instance file "basename
    return ''
end   
oldstuff=charin(basename,1,basesize)
foo=stream(basename,'c','close')


rr=fix_ranges(basesize,range1,range2)  /* make sure provided range makes sense */
if rr='' then return ' '
parse var rr range1 range2
kk=1+range2-range1
adiff=substr(oldstuff,range1+1,kk)
say " Extracting range from "range1 " to "range2

/* write to a temporary file */
tmpfrng=delta_dir'\'tmpf||'.RNG'
foo=sysfiledelete(tmpfrng)

foo=stream(tmpfrng,'c','open write')
if abbrev(translate(foo),'READY')=0 then do
   say "Unable to create temporary difference file "tmpfrng
   foo=stream(tmpfrng,'c','close')
   foo=sysfiledelete(tmpfrng)
   return ''
end 
foo=charout(tmpfrng,adiff,1)
if foo<>0 then do
   say "Unable to write temporary difference file "tmpfrng
   foo=stream(tmpfrng,'c','close')
   foo=sysfiledelete(tmpfrng)
   return ''
end
foo=stream(tmpfrng,'c','close')
return tmpfrng

/**********************/
mkPACK64:procedure
parse arg mess

biga=xrange('A','Z')||xrange('a','z')||xrange('0','9')||'+/'

s2=x2b(c2x(mess))

nith=trunc((length(s2)/6)+.9)
cont=copies(' ',nith)
oof=""
do mm=0 to 63
      oof=oof||x2c(b2x(right('00'||x2b(d2x(mm)),6)))
end /* do */
do ith=1 to nith 
  a1=substr(s2,(ith*6)-5,6,0)
  cont=overlay(x2c(b2x(a1)),cont,ith) 
end /* do */
pint=""
pint=translate(cont,biga,oof)
j1=length(pint)//4
if j1<>0 then pint=pint||copies('=',4-j1)
return pint


/* -------------------- */
/* choose between 3 alternatives (by default,a yes or no ),
return 1 if yes (or 0,1,2 for chosen altenative ) */

yesno:procedure expose normal reverse bold cy_ye     mm0a listfile
parse arg amessage , altans,def,arrowok
ony2:
aynn=' '
if def='' then
 defans=''
else
 defans=translate(left(strip(def),1))
if altans='' then altans='No Yes'

w.0=words(altans)
goo=aynn
do iw0=1 to w.0
     w.iw0=strip(word(altans,iw0))
     a.iw0=translate(left(w.iw0,1))
     aa.iw0=substr(w.iw0,2)
     aynn=aynn||bold
     if  a.iw0=defans then aynn=aynn||cy_ye
     aynn=aynn||a.iw0||normal||aa.iw0
     goo=goo||a.iw0||aa.iw0
     if iw0<w.0 then do
       aynn=aynn'  '
       goo=goo||'  '
     end
end
if arrowok=1 then aynn=aynn||' [UP]'

do forever
 foo1=normal||reverse||amessage||'? '||normal||aynn||': 'normal
 goo=amessage'?'||goo':'

 if length(goo)<73 then do
    call charout,foo1
 end
 else do
    foo1=normal||reverse||amessage||'? '||normal
    say foo1
    call charout,'     : 'aynn||': 'normal
 end

 anans=translate(sysgetkey('echo'))

 ianans=c2d(anans)
 if anans='' | ianans=13 | ianans=10 then  anans=defans

 if arrowok=1 & ianans=0  then do
     ians=c2d(sysgetkey('noecho'))
     if ians=72 then  do
           say ;say
           return -1  /* -1 : up key */
     end
 end /* do */

 do ijj=1 to w.0
    if abbrev(anans,a.ijj)=1 then do
        say
        return Ijj-1
    end
 end /* do */
 call charout,'0d'x
end


/***************/
/* return 0 for no, 1 for yes, default otherwise */
is_yes_no:procedure expose bold normal mm0a  reverse cy_ye listfile
parse arg aval,def
tdef=strip(translate(aval))
if wordpos(tdef,'Y YES 1')>0 then return 1
if wordpos(tdef,'N NO 0')>0 then return 0
return def



/* unchunk a chunked entity.
  a : the chunked entity entire body)
 inct: if 1, add trailers at beginning of entity (trailers crlf entity) 
*/

unchunk:procedure
parse arg a,inct

stuff=''
do forever 
  parse var a a1 '0d0a'x a
  parse var a1 a2 ';' .
  da2=x2d(strip(a2))
  if da2=0 then leave
  stuff=stuff||left(a,da2)
  a=substr(a,da2+3)     /* skip crlf */
end

if inct<>1 then return stuff
trailers=''
do forever
   parse var a t1 '0d0a'x a
   if t1='' then leave
   trailers=trailers||t1||'0d0a'x
end /* do */
return trailers||'0d0a'x||stuff


/*************/
/* decode a string that's been url encoded  (i.e.; %7e becomes ~)
This is the equivalent to goserve's PACKUR function*/
sre_packur:procedure
parse arg astring
IF ASTRING=' ' THEN RETURN ASTRING
ipp=pos('%',astring)
if ipp=0 then return astring
if ipp>1 then
  bstring=left(astring,ipp-1)
else
  bstring=''
astring=substr(astring,ipp+1)
do until astring=''
  parse var astring  acode +2  astring
  if verify(acode,'0123456789abcdefABCDEF')>0 then do
     bstring=bstring||'%'||acode
  end
  else do
     bstring=bstring||x2c(acode)
  end
  parse var astring a1 '%' astring
  bstring=bstring||a1
end /* do */
return bstring


/*************/
/* make a crc based stamp of a string, using only UC keyboard characters*/
crc_stamp:procedure
parse arg tt1
 if tt1='' then tt1=' '
 a=sre_pack64_make(stringcrc(tt1))
 a=strip(translate(space(translate(a,'_____','=+/\.'),0)),'t','_')
 return a


/****************************/
/* add delta encoding headers (A-IM and If-none-match) */
/* delta check */
add_delta_headers:
parse arg which_difs

areq=sre_packur(translate(request,' ','+'))

if pos('?',areq)>0 then do
  parse var areq a1 '?' a2
  areq=strip(translate(a1))||'?'||a2
end
else do
   areq=translate(strip(areq))
end 
areq2=crc_stamp(areq)

ahost=strip(translate(server))
ahost2=crc_stamp(ahost)

delta_checknames=delta_dir||'\*.'||areq2||'.'||ahost2

foo=sysfiletree(delta_checknames,'INSTFILES','FT')
if instfiles.0=0 then return 1          /* no headers to add */

say  instfiles.0" instance files match: "delta_checknames

/* choose up to delta_max_etags matches */
if instfiles.0>delta_max_etags then do 
   do iii=1 to instfiles.0
      aa=instfiles.iii
      if left(aa,2)<80  then
         instfiles.iii='20'||aa
     else
         instfiles.iii='19'||aa
   end
   arf=arraysort('instfiles',1,instfiles.0,1,16,'D','C')
   instfiles.0=delta_max_etags
end
ifn='If-None-Match: '
base_tag_list=''
do ii=1 to instfiles.0
   parse var instfiles.ii . . . aname
   aname=filespec('n',aname)
   parse var aname atag '.' .
   ifn=ifn||'"'||translate(strip(atag))||'",'
   base_tag_list=base_tag_list' 'atag
end
ifn=strip(ifn,,',')

message=message||ifn||'0d0a'x||'A-IM: 'which_difs||'0d0a'x

return 1


/******************************************/
/* undifference a file, using a difference file produced
  by gnudiff -e .
This should work for almost all such difference files. However, there
may be cases where more complicated "ed"  commands are used
by some versions of gnudiff -- in which case a '' is returned 

called as:          t2=sref_unGNUdiff(deltabase,base_tag_list,T2)
*/

SREF_UNGNUDIFF:PROCEDURE EXPOSE DELTA_DIR DELTA_CHECKNAMES  BASENAME  ,
                                DIFF_ON_RANGE RANGE1 RANGE2 celist

parse arg deltab,blist,diffstuff

/* determine base file  =delta_dir||'\*.'||areq2||'.'||ahost2 */
if deltab='' then deltab=strip(blist)
if words(deltab)<>1 then do
 say "Error: no delta base "
 return ''              /* unable to do */
end

parse var delta_checknames a1 '*' a2
basename=a1||strip(deltab)||a2
if stream(basename,'c','query exists')='' then do
   say "Error could not find base-instance file "basename
   return ''
end

foo=sysgetea(basename,'CONTENTCODING','CONTCODE')
/* need to ungzip our instance to match content-coding of the
   current request? */

doit=compare_cc(celist,contcode,'GZIP')

foo=stream(basename,'c','open read')
if abbrev(translate(foo),'READY')=0 then do
   say foo" Error could not open base-instance file "basename
  return ''
end
basesize=stream(basename,'c','query size')
if basesize='' | basesize=0 then do
  say "Error could not read base-instance file "basename
  return ''
end   
oldstuff=charin(basename,1,basesize)
foo=stream(basename,'c','close')

/* if doit=GZIP, then ... */
/*   our instance has gzip, current one does not implying that the server expects */
/*   us to ungzip  before im (in order to have intances with the same content coding */
if doit='GZIP' then do 
  say "  unGZIP of old instance...."
  oldstuff=rxgzinflatestring(oldstuff)
end 

if diff_on_range=1 then do
   rr=fix_ranges(basesize,range1,range2)
   if rr='' then return ' '
   parse var rr range1 range2
   kk=1+range2-range1
   oldstuff=substr(oldstuff,range1+1,kk)
   say " Extracting range from "range1 " to "range2
end 

/* ===== Now, do the undifferencing === */

/* parse oldstuff into an array */
iat=1
i0=0
stuff.=''
do forever
   i0=i0+1
   iat1=pos('0d0a'x,oldstuff,iat)
   if iat1=0 then do
     stuff.i0=substr(oldstuff,iat)
     leave
   end
   if iat1=iat then do
      stuff.i0=''
   end
   else do
      stuff.i0=substr(oldstuff,iat,iat1-iat)
   end
   iat=iat1+2
end 
stuff.0=i0

/* in general, dif files are written bottom to top. But not always.
Dif file structure is:
  n1[,n2]x stuff
  moresstuff
  .
where
  n1: line number. Changes occur AFTER this line. n1=0 means "change first line"
  [,n2] : optional "end" line number. For removing multiple lines
  x:  a,c,d, or s.  
        a = add stuff and morestuf
        c =change lines (remove and replace)
        d = delete lines
        s = substitute. Only used for single . on a line
  stuff.. morestuff: multiple lines of substitution
  .     end of this change block
Note that a change block can never conists of a  single . in character 1

*/

lastline=stuff.0+1
do forever
    if diffstuff='' then do
        leave
   end
    parse var diffstuff acmd '0d0a'x diffstuff
    ichar=verify(acmd,'0123456789,.')            /* acd or s */
    if ichar='' | ichar=0 then do
       say "Error: unrecognized diff command: "||acmd 
      return ''
    end
    bcmd=substr(acmd,ichar,1)
    if pos(bcmd,'acds')=0 then do
        say "Error: unrecognized ED option= "bcmd 
        return ''
    end
    ccmd=substr(acmd,ichar+1)
    rnge=left(acmd,ichar-1)
    parse var rnge line1 ',' line2
    if line2='' then line2=line1
    if datatype(line1)<>'NUM' & datatype(line2)<>'NUM' then do
        say "Bad line range: "rnge 
        return ' '
    end
    if line1>line2 then do
        say "Misordered line range: "line1 ' - ' line2 
        return ' '
    end

    if line1> lastline then do         /* darn, have to regenerate "Stuff" */
       foo=regen_stuff(maxlen)           /* since might be changing "changed" lines */
    end 
   
    select
       when bcmd='d' then do
          do jj=line1 to line2
              stuff.jj.!del=1
          end 
       end

       when bcmd='c'  then do
          do jj=line1+1 to line2        /* line1 is changed, with possible embedded crlfs */
              stuff.jj.!del=1           /* others are deleted */
          end 
          ff=''
          do forever                    /* stop when  "." is found */
             if length(diffstuff)=0 then do
                  say "Error no terminating ' . ' " 
                  return ' '
              end
              parse var diffstuff getme '0d0a'x diffstuff
              if getme='.' then leave    /* got the replacement */
              if length(ff)<>0 then ff=ff||'0d0a'x
              ff=ff||getme   
          end 
          stuff.line1.!del=0 
          stuff.line1=ff
       end

       when bcmd='a'  then do
          line1a=line1+1
          ff='' ; igot=0
          do forever                    /* stop when  "." is found */
             if length(diffstuff)=0 then do
                  say "Error no terminating ' . ' " 
                  return ' '
              end
              parse var diffstuff getme '0d0a'x diffstuff
              if getme='.' then leave    /* got the replacement */
              if igot=1 then ff=ff||'0d0a'x
              igot=1
              ff=ff||getme   
          end 
          if stuff.line1a.!del=1 then do
             stuff.line1a=ff
          end
          else do
             stuff.line1a=ff||'0d0a'x||stuff.line1a
          end
          stuff.line1a.!del=0
          if stuff.0<line1a  then stuff.0=line1a
       end           

       when bcmd='s' then do
         if ccmd<>'/^\.\././' then do
                say "Unrecognized s command: "ccmd 
                return ' '
         end 
         stuff.line1='.'
         stuff.line1.!del=0 
       end 
       otherwise do
          say "Unrecognized command: "acmd 
          return ' '
       end
    end  /* select */
   lastline=line1              /* the smallest line# changed */
end 

nustuff=ArrayJoin(1,stuff.0+1)  /* join into a string */
return nustuff




/************/
/* fix ranges. Return ' ' if bad */
fix_ranges:Procedure
parse arg len_file,range1,range2
range1=strip(range1)
range2=strip(range2)
     if range1<>"" then do
        if datatype(range1)<>'NUM' then do
            say 'Bad byte range: 'range1 '-' range2
            return ' '
        end
     end
     if range2<>"" then do
        if datatype(range2)<>'NUM' then do
            say 'Bad byte range: 'range1 '-' range2
            return ' '
        end
     end
 
     if range1="" & range2="" then do
            say 'Bad byte range: 'range1 '-' range2
            return ' '
     end

     if range2="" then range2=len_file    
     if range1="" then do
        range1=len_file-range2
        range2=len_file
     end
     if range1<0 then range1=0

     if range2>(len_file-1) then range2=len_file-1
     if range2<range1 then do 
         say 'Bad Byte Range : 'range1 '-' range2       /*416 means "bad request" */
         return ' '    
     end 

     return range1' 'range2   /* ok! */

/*************************/
/* join all items in a stem array into a long string */
ArrayJoin: PROCEDURE EXPOSE stuff.
parse arg low,high
   mid = (high+low) % 2
   IF high-low > 2 THEN 
      RETURN ArrayJoin(low,mid)||'0d0a'x||ArrayJoin(mid,ARG(2))
    ELSE IF low \= mid then
      RETURN stuff.low||'0d0a'x||stuff.mid
    ELSE 
      RETURN stuff.low



/*****/
/* regenerate stuff. */
regen_stuff:procedure expose stuff. 

t0=0
do az=1 to stuff.0
   if stuff.az.!del=1 then iterate
   taa=stuff.az
   do forever
      t0=t0+1
      iarf=pos('0d0a'x,taa)
      if iarf=0 then do
         newt.t0=taa
         leave
      end
      if iarf=1 then do
         newt.t0=''
      end 
      newt.t0=left(taa,iarf-1)
      taa=substr(taa,iarf+2)
   end
end
stuff.=''
do mm=1 to t0
   stuff.mm=newt.mm
end 
stuff.0=t0

return 1


/**************/
/* read value of this instance */
/* use etag, delta_dir, t2 , areq2, and ahost2 */

get_instance:procedure expose areq2 ahost2 delta_dir etag 

etag=strip(etag)
basename=delta_dir||'\'||etag||'.'||areq2||'.'||ahost2 
say
say "Retrieving cached instance: " basename
foo=stream(basename,'c','open read')
if abbrev(translate(foo),'READY')=0 then do
   say foo" Could not open old instance file "basename
  return ''
end

ii=stream(basename,'c','query size')
if ii='' | ii=0 then do
  say "Error could not read old instance file "basename
  return ''
end   

oldstuff=charin(basename,1,ii)
foo=stream(basename,'c','close')
return oldstuff


/**************/
/* save this instance to delta_dir */
/* use etag, delta_dir, t2 , areq2, and ahost2 */
/* also, check for retain=0 in ccontrol */
save_instance:

ccontrol=space(translate(ccontrol),0)
if pos('RETAIN',ccontrol)>0 then do     /* might be retain=0 */
    parse var ccontrol . 'RETAIN' goo ',' .
    if goo<>'' then do
       parse var goo . '=' aval
       if aval=0 then return               /* DO not retain this one */
    end
end 

etag=strip(etag)
aname=delta_dir||'\'||etag||'.'||areq2||'.'||ahost2 

foo=sysfiledelete(aname)
foo=stream(aname,'c','open write')
if abbrev(translate(foo),'READY')=0 then do
   say "Unable to create file for this instance: "aname
   return 0
end 

foo=charout(aname,t2,1)
if foo<>0 then do
   say "Unable to write this instance: "aname
   return 0
end 
foo=stream(aname,'c','close')
say
if celist<>'' then
  say ' Current instance file (w/'celist') saved: '||filespec('n',aname)
else 
  say ' Current instance file saved: '||filespec('n',aname)

fpp=sysputea(aname,'CONTENTCODING',celist)

/* check on files */
foo=sysfiletree(delta_dir||'\*','fils','FT')
atot=0
do mm=1 to fils.0
   parse  var fils.mm . ilen .
   atot=atot+strip(ilen)
end 
say

if atot/1000000> delta_dir_warning then do
  say "Note: there are currently "||bold||addcomma(atot)||normal||" bytes in " fils.0 " instance files"
  jj=yesno("  Would you like to remove old entries? ",,'N')
  if jj=0 then return 0
  call clean_deltadir
end 
return 1


/************/
/* clean out oldest entries from delta_dir */
clean_deltadir:
dcomp=(delta_dir_warning*1000000)*.85
do mm=1 to fils.0
    parse var fils.mm . isize . afile ;afile=strip(afile)
    fils2.mm=afile
    sizs.mm=strip(isize)
    las.mm=left(dosfileinfo(afile,'A'),20,' ')||mm
end 
foo=arraysort(las,1,fils.0,1,17,'D')
rtot=0 ;ndel=0 ;bdel=0
do mm=1 to fils.0
    parse var  las.mm . . ith ; ith=strip(ith)
    if rtot>dcomp then  do
        foo=sysfiledelete(fils2.ith)
        ndel=ndel+1 ; bdel=bdel+sizs.ith
        iterate
    end
    rtot=rtot+sizs.ith
end 
say addcomma(bdel)||' bytes deleted from 'ndel' files.'

return 1
/************/
/* ADD COMMAS TO A NUMBER */
addcomma:procedure
parse arg aval,ndec
parse var aval p1 '.' p2

if ndec='' then do
   p2=''
end
else do
   p2='.'||left(p2,ndec,'0')
end /* do */

plen=length(p1)
p1new=''
do i=1 to 10000 while plen>3
   p1new=','right(p1,3)||p1new
   p1=delstr(p1,plen-2)
   plen=plen-3
end /* do */

return p1||p1new||p2

/******/
/* compare content-encodings of "new" and "old", using
   "more_codings"
   Return
        0 = different
        '' = same
        other_codings =  if new + other_codings = old
                         other_codings MUST be in the more_codings argument

  Basically, more_codings are codings that the caller is prepared to undo.

  Hence, other_codings are the instructions on what to undo (of the old)
  to achieve the new (note that uncodings should be done from last to first)

 Notes:
   * The idea is that in in order to create equivalently coded items:
     the caller is willing to do some decoding of the old1
       (but just using the types of codings listed in more_codings)
     but is NOT willing to encode the new1.
                       
  * typically, more_codings='GZIP'

*/

COMPARE_CC:procedure

parse upper arg new1,old1,morecodings

if new1=old1 then return ''      /* a quick test */

old2=space(translate(old1),0) ; old2=translate(old2,' ',',')
new2=space(translate(new1),0) ; new2=translate(new2,' ',',')

if new2= old2 then return '' /* a more robust test */

if words(new2)>words(old2) then return 0   /* old2 is "less" encoded, so give up*/

do mm=1 to words(new2)          /* new2 must be an "abbreviation" of old2 */
  if strip(word(new2,mm))<>strip(word(old2,mm)) then return 0
end   

/* an even more robust test of equality !  */
if words(new2)=words(old2) then return ''

/* not equal, but perhaps an abbreviation? */

more2=space(translate(morecodings),0)
more2=translate(more2,' ',',')

if more2='' then return 0               /* nothing to add, so not a match */

old2b=subword(old2,words(new2)+1)

do mm=1 to words(old2b)
    aw=strip(word(old2b,mm))
    if wordpos(aw,more2)=0 then return 0        /* nope, an encoding of old is not supported */
end 
return old2b



/**********/
/* fix an option for inclusion in request string */
fix_option:procedure
parse arg aval,dospace,moreenc

/* characters that must be url encoded: +, & */
charlist.1='+'
charlist.2='&'
charlist.1.0='%2b'
charlist.2.0='%26'
i2=2


/* if moreenc=1, encode more characters: " ! < > */
if moreenc=1 then do
charlist.3='"'
charlist.4='!'
charlist.5='<'
charlist.6='>'
charlist.7='?'
charlist.8='('
charlist.9=')'
charlist.3.0='%22'
charlist.4.0='%21'
charlist.5.0='%3c'
charlist.6.0='%3e'
charlist.7.0='%3f'
charlist.8.0='%28'
charlist.9.0='%29'
i2=9
end

do mm=1 to i2
  achar=charlist.mm
  makeit=aval
  newval=''
  do forever
    jj=pos(achar,makeit)
    if jj=0 then do
        newval=newval||makeit
        leave
    end
    if jj=1 then do
        newval=newval||charlist.mm.0
    end
    else do
         newval=newval||left(makeit,jj-1)||charlist.mm.0
    end
    makeit=substr(makeit,jj+1)
  end           /* forever */
  aval=newval
end
if dospace=1 then aval=translate(aval,'+',' ')
return aval



/*************/
