/* The DYNPRIV.REX "EXEC" procedure and "INTERPRETable SSI" */ 

/* check for a SERVERNAME argument. If not ' ', this is being
called as an interpret. Otherwise, it's called as an exec */
if symbol('SERVERNAME')='VAR' then do  /* as ssi, there are several exposed vars */
   parse arg  action, family,plist
   parse upper var  action action aopt 
   action=strip(action) ; aopt=strip(aopt)
   parse var request_line . seloriginal . ; seloriginal=strip(seloriginal)
   isexec=0
end 
else do                 /* AS EXEC */
   parse arg stuff,source,request_line,seluse,servername,host_nickname,datadir,privset,id_info
   parse var stuff v1 ',' family ',' plist
   parse upper var v1 action aopt
   action=strip(action) ; aopt=strip(aopt)
   parse var request_line . seloriginal . ; seloriginal=strip(seloriginal)
   isexec=1
end

family=strip(translate(family))
if abbrev(family,'!')=1 then do 
   if isexec=0 then return '<!-- %ERROR: bad family name in DYNPRIV -->'
   rcode=sre_error_response(500,,servername,'bad family name in DYNPRIV ',id_info)
   return rcode
end 
if family='' then family='!DEFAULT'


select

when action="CHECK" then do            /******* CHECK FOR COOKIE *****/

/* any DYNPRIV cookies ?*/
stuff=sreh2_dynamic_privs('READ','!COOKIE',,,id_info)
nogood=0 
if stuff='' then nogood=1    /* no cookies, so no dynprivs, so error */

if nogood=0 then do             /* look in dyn privs cache */
   tlook='||'||family||' '      
   parse var stuff . (tlook) savedprivs '||' .
   if savedprivs='' then nogood=1             /* nothing saved for this selector */
end

if nogood=0 then do     /* got something */
  do mm=1 to words(plist)
     aw=strip(translate(word(plist,mm)))
     if wordpos(aw,translate(savedprivs))>0 then do 
        if isexec=0 then return '<!-- dynamic privileges were checked -->  '    
        return ' '
     end 
  end 
end

/* else, failure */
if aopt='' then do
     rcode=sre_command('STRING Sorry. You do not have access rights to: <tt>'seloriginal'</tt>',,id_info)
end 
else do
     rcode=sre_move_response(302,strip(aopt),servername)
end
return rcode
end



when action="ADD" then do       /**** ADD (or modify exissting) dynamic priv */

stuff=sreh2_dynamic_privs('READ','!COOKIE',,,id_info)

duration=''
if datatype(aopt)='NUM' then duration=max(1,aopt)
if datatype(aopt)<>'NUM' then duration=15

if stuff<>'' then do            /* it exists, check for FAMILY section */
  tlook='||'||family||' '
  parse var stuff part1 (tlook) savedprivs '||' part2
  if savedprivs<>' ' then do     /* append these privileges to this section */
    do mm=1 to words(plist)
       aw=strip(translate(word(plist,mm)))
       if wordpos(aw,translate(savedprivs))=0 then savedprivs=savedprivs||' '||aw
    end 
  end        
  else do          /* else, no such (or empty) set for FAMILY */
      savedprivs=plist
  end 
  info=''
  if part1<>'' then do
      info=strip(part1)
      if part2<>'' then info=info||' ||'||strip(part2)
  end
  else do
      if part2<>'' then info=strip(part2)
  end 
  if info='' then
      info=strip(tlook)||' '||strip(savedprivs)     
  else
      info=info||' '||strip(tlook)||' '||strip(savedprivs)     

  info=strip(info)
  if abbrev(info,'||')<>1 then info='||'info

/* might do this later ...
  anamex=''
     anamex=strip(sre_extract('STARTTIME_REQ'),'t','0')
     anamex=translate(anamex,'___',' .:')
    foo=sreh2_dynamic_privs('WRITE','!COOKIE:'||anamex,info,duration,id_info)
    foo=sreh2_set_cookie('DYNPRIV',aname)   /* maybe later add ,duration */
*/

  foo=sreh2_dynamic_privs('WRITE','!COOKIE',info,duration,id_info)

  if isexec=1 then return ' '
  return '<!-- dynamic privileges were modified -->'
end

/* otherwise, create a new cookie  -- or check to see if one
   was created from an interpret in this same document */

aname=''
if isexec=0 then do
   if symbol(globals.!!DYNPRIV_CNAME)='VAR' then do /* a small shortcut */
      aname=globals.!!DYNPRIV_CNAME
   end 
end
if aname='' then do

     aname=strip(sre_extract('STARTTIME_REQ'),'t','0')
     aname=translate(aname,'___',' .:')
     if isexec=0 then globals.!!DYNPRIV_CNAME=aname
end
info='||'||family||' '||strip(plist)


foo=sreh2_dynamic_privs('WRITE','!COOKIE:'||aname,info,duration,id_info)

foo=sreh2_set_cookie('DYNPRIV',aname)   /* maybe later add ,duration */

if isexec=1 then return ' '
return '<!-- dynamic privileges were stored -->'


end 

otherwise do  /* unknown action */
  if isexec=1 then return ' '
  return '<!-- %error: unknown dynpriv action:' action ' -->'
end

end


