/* The SREhttp/2 Encryption Pre-Response Procedure 

   The currently known encryption methods are:
       SRE_A  SRE_B SRE_BF and SRE_BFC
   if  astring contains something else, then we assume that 
   a custom encryption method is available, and has been loaded into
  SREH2_CUSTOM_ENCRYPT.  SREH2_CUSTOM_ENCRYPT will
   be called with the same arguments as sent here, and should follow
   the regular SREhttp/2 pre-response rules in terms of what is returned.
*/

parse arg stuff,fileflag,mimetype,astring,req_string,seluse2,privset,host_nickname,id_info


/*****    -----  BEGIN USER CHANGEABLE PARAMETERS          -----------        ****/

/* name of the blowfish executable (fully qualified name if blowfish executable 
   not in your PATH */
bfexe='BF'

/*****    -----  END USER CHANGEABLE PARAMETERS          -----------        ****/

signal on error name err1
signal on syntax name err1

crlf='0d0a'x
known_methods='SRE_A SRE_B SRE_BF SRE_BFC'

parse upper var astring enctype resp_file
enctype=strip(translate(enctype))
if resp_file='' then resp_file='ENC_SREB.RSP'

/* CUSTOM procedure? */
if wordpos(enctype,known_methods)=0 then do  /* might be custom? */
    if macroquery('SREH2_CUSTOM_ENCRYPT')='' then do
              rcode=sre_error_response(500,,,'No such custom encryption method: 'astring,id_info)
               return '0 'rcode
     end
    rcode=sreh2_custom_encrypt(contents,fileflag,mimetype,astring,req_string,seluse2,privset,host_nickname,id_info)
    return rcode
end


/* get shared-secret */
parse var privset . ',' sprivs
tsprivs=' '||translate(sprivs)
ia=pos(' ENCRYPT:',tsprivs)
epwd=''
if ia>0 then do
   goo=substr(sprivs,ia)
   parse upper var goo . ':' epwd .
end

if epwd='' then do     /* if here,  no encrypt shared secret */
   servername=sre_servername()
   rcode=sre_auth_response('Get Secret Privilege',servername,, ,
                 'You need to provide a Usename with an appropriate secret privilege for this resource', ,
                  id_info)
   return '0 '||rcode
end

if enctype=0 then return ''             /* 0 method means "don't encrypt" */

/* blowfish method? If so, use external executable  */
if enctype="SRE_BF" | enctype="SRE_BFC" then do
  tempdir=sre_value('H2_TEMP_DIR',,'SRE')
  tout=sre_tempfile(,,tempdir,0) 

  if fileflag=0 then do           /* SRE_BF and SRE_BFC work with files only */
     fooa=stream(tout,'c','open write')
     foo=charout(tout,stuff,1)
     if foo<>0 then do
           foo=stream(tout,'c','close')
           rcode=sre_error_response(500,,,'ENCRYPT is unable to create temporary file',id_info)
           return '0 '||rcode
     end
     foo=stream(tout,'c','close')
  end

  a1=bfexe||' -q '
  if enctype="SRE_BFC" then a1=a1' -c '
  if isfile=0 then   /* temp file -- decrypt to same file */
      a1=a1' 'tout
  else                  /* permanent file -- decrypt to temp file */
     a1=a1' 'stuff' 'tout
  epwd=translate(space(epwd,0))
  a1='@DETACH '||a1' "'epwd'" 2>nul'
  address cmd a1
  stuff2=sre_read_file(tout,4,3,0) 

  if stuff='' then do
         goo=sysfiledelete(tout)
         rcode=sre_error_response(500,,,'ENCRYPT BF method failed to create output file: 'tout,id_info)
        return '0 '||rcode
  end

/* success! */
  goo=sysfiledelete(tout)  /* zap temporary file */

  arf=sre_command('HEADER REPLACE Content-Encoding: Encrypt_SRE_BF',,id_info)
  return '1  type application/x-encrypt_SRE_BF  '||'0d0a'x||stuff2

end
    

/* sre_b or sre_a */

/* read the file */
if fileflag=1 then do
  stuff2=sre_read_file(stuff,2,2,0) 
  if stuff2='' then do
        rcode=sre_error_response(500,,,'ENCRYPT SRE_A method could not read file: 'stuff,id_info)
        return '0 '||rcode
  end
end

/* create encryption parameters */
sname=sre_servername()
atime=date('b')'.'time('s')

nonce=translate(space(atime'_'sname'_',0))
epwd=translate(space(epwd,0))
todo=nonce||epwd

md5=sre_md5(todo)
md5=strip(translate(md5))
md5_16=translate(left(md5,16))


parse var seluse2 baa '?' .
ixx=lastpos('/',baa)
nnm=substr(baa,ixx+1)

numeric digits 13                       /* set seed for random number generator */
ix=x2d(substr(md5,30,3))
iy=x2d(substr(md5,27,3))
iz=x2d(substr(md5,25,2))

/* debug stuff -- 
aa=aa||crlf||'X-MD5: 'md5
aa=aa||crlf||'X-todo: 'todo 
aa=aa||crlf||'X-seed: 'ix' 'iy' 'iz
aa=aa||crlf||'X-epwd: 'epwd
*/

numeric digits 12
if enctype="SRE_A" then do
   j4=4
   mx32=4294967295
end
else do
   j4=1
   mx32=255
end

/* pack to multiple of j4 length */
i4s=trunc(length(stuff2)/j4)
i4sb=length(stuff2)//j4
if i4sb>0 then do
 i4s=i4s+1
 stuff2=stuff2||copies(' ',i4sb)
end

amask=''
do mm=1 to length(stuff2)/j4
  arand=random3(mx32)
  darand=right(d2c(arand),j4,0)
  amask=amask||darand
end

aanew=bitxor(stuff2,amask)               /* THIS IS THE ENCRYPTED RESULT !!!  */

if enctype='SRE_A' then do              /* if SRE_A, return this encrypted result */
   a0='1 type  application/x-encrypt_SRE_A'

   haa='HEADER REPLACE X-Hash16: 'md5_16
   haa=haa||crlf||'HEADER REPLACE X-nonce: 'nonce
   haa=haa||crlf||'HEADER REPLACE X-encrypt-method: SRE_A '
   haa=haa||crlf||'Content-disposition: attachment; filename='nnm

   arf=sre_command(haa,,id_info)

/* and also in the body of the response */
   haa='X-Hash16: 'md5_16
   haa=haa||crlf||'X-nonce: 'nonce
   haa=haa||crlf||'Content-Type: 'mimetype
   haa=haa||crlf||'Content-Length: '||length(aanew)
   haa=haa||crlf||'X-encrypt-method: SRE_A '
   haa=haa||crlf||'Content-disposition: attachment; filename='nnm
   haa=haa||crlf||'Server: '||sname
   haa=haa||crlf||'X-Request-String: 'req_string
   haa=haa||crlf||crlf                          /* empty line signal send */
  return a0||crlf||haa||aanew
end

/* else, SRE_B will return in an html file with embedded javascript */

resp_file=strip(resp_file)
if pos(':',resp_file)>0 then
  nname=resp_file
else
  nname=sreh2_fig_file_name(host_nickname,,resp_file,,,'HTML',2)

stuff3=sre_read_file(nname,2,2,0) 

if stuff3='' then do
     rcode=sre_error_response(500,,,'ENCRYPT SRE_B method  could not find response file: 'nname,id_info)
     return '0 '||rcode
end

/* set some variables */
stuff3=sre_replacestrg(stuff3,'##NONCE',nonce,'ALL')
stuff3=sre_replacestrg(stuff3,'##HASH_16',md5_16,'ALL')
stuff3=sre_replacestrg(stuff3,'##SELECTOR',baa,'ALL')
stuff3=sre_replacestrg(stuff3,'##SERVERNAME',sname,'ALL')
stuff3=sre_replacestrg(stuff3,'##MIMETYPE',mimetype,'ALL')

aanew2=c2x(aanew)

iaanew2=length(aanew2)

ikunk=trunc( (iaanew2/50)+0.99)

parse var stuff3 a1 '##ARRAY' a2 (crlf) a3 

stuff3=a1||crlf||'kontents = new Array('||strip(ikunk)') '||a2||crlf

iis=0
do  igoo=1 to length(aanew2) by 50
   i1=igoo
   i2=min(50,1+length(aanew2)-i1)
   stuff3=stuff3||' kontents['iis'] = "'||substr(aanew2,i1,i2)||'"'||crlf
   iis=iis+1
end

haa='HEADER REPLACE X-Hash16: 'md5_16
haa=haa||crlf||'HEADER REPLACE X-nonce: 'nonce
haa=haa||crlf||'HEADER REPLACE X-encrypt-method: SRE_A '
haa=haa||crlf||'Content-disposition: attachment; filename='nnm

arf=sre_command(haa,,id_info)

stuff3=stuff3||crlf||a3

return '1 type text/html '||crlf||stuff3


/* *********************** */
/* UNIFORM DISTRIBUTION RANDOM # GENERATOR.  
  FROM APPL STATIS 1982, VOL31 Pg183 */

random3:procedure expose ix iy iz 
parse arg mx32
IX=(171*IX)//30269
IY=(172*IY)//30307
IZ=(170*IZ)//30323
RANDOM=(IX/30269.) + (IY/30307.)  + (IZ/30323)
random=trunc((random // 1.0)*mx32)

RETURN random




err1:
ff=sre_pmprintf('Error in ENCRYPT.RXX at line 'sigl)
return ' '





