/* convert output from swish-e to a simple html table 
   Created by Daniel Hellerstein (danielh@crosslink.net), 4/16/01

 Usage:
      x:>swi_html text_to_search 
   where:
     text_to_search is the text string that swish will look for (text_to_search
     may contain spaces).

  Note: SWISH-E must be in your PATH!

**************************************************/

/* ----------  USER CHANGEABLE PARAMETERS  ------ */


/* row background color for "directory identifier" rows */
color_dir='#cccccc'

/* row background color for even #  rows */
color_even='#cbebfa'

/* row background color for even #  rows */
color_odd='#cbf1ab'


/* where to write output to */
outfile='vuswish.htm'

/* set show_dirs=1 to write directory info to output file */
show_dirs=1

/* swish index file to search */
swish_index='index.swi'



/* program (possibly with flags) to use to view results 
   To NOT view results, leave this blank */
viewer='NETSCAPE -l en ' 


/* ----------  End of USER CHANGEABLE PARAMETERS  ------ */

bgs.0=color_even
bgs.1=color_odd

foo=rxfuncquery('sysloadfuncs')     /* load rexxutil library */
if foo=1 then do
  call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
  call SysLoadFuncs
end

aesc='1B'x
cy_ye=aesc||'[37;46;m'
cyanon=cy_ye
normal=aesc||'[0;m'
bold=aesc||'[1;m'
re_wh=aesc||'[31;47;m'
reverse=aesc||'[7;m'

parse arg text
if text='-?' | text='?' | text='' then do
 say bold"SWI_HTML"normal"  will search a SWISH index, and display the  results"
 say "in HTML format. You can view these results with your favorite browser "
 say "(and click on links to the underlying files)"
 say ""
 say bold"Usage:"normal
 say "  x:>SWI_HTML  [-i swish_index] [-o output_file] search_string "
 say "where: "
 say '   -i swish_index: (optional) specify a swish ''index'' file to search in'
 say '   -o output_file: (optional) file to write results to '
 say '   search_string: a search string (which may contain AND, OR, etc. modifiers)'
 say
 say reverse"Current defaults: "normal
 say  "     Index to search: "swish_index
 say  "   Resuts written to: "outfile
 if viewer<>'' then
  say " Results viewed with: " viewer
 exit
end

if pos('-',text)<>'' then do
   do forever
    if pos('-',text)=0 then leave
    parse var text t1 '-' itype text
    select
      when translate(itype)='I' then do
        parse var text swish_Index text
      end
      when translate(itype)='O' then do
        parse var text outfile text
      end
      otherwise do
        say "Unknown option: "itype
        exit
      end
    end
end /* do */

if stream(swish_index,'c','query exists')='' then do
    say bold"ERROR:"normal", no such swish index: "reverse||swish_index||normal
    exit
end 


say 'Searching 'reverse|| swish_index||normal ' for: ' bold||text||normal
address cmd 'SWISH-E.EXE -w 'text' -f 'swish_index' |rxqueue  '
if queued()=0 then do
 say "SWISH produced no output "
 exit
end
info.=''
ii=0
do until queued()=0
 parse pull gooba
 if gooba='.' then iterate
 if abbrev(gooba,'#')=1 then do
    parse var gooba . '#' hdr ':' value
    hdr=translate(space(hdr,0))
    if value='' then iterate
    aa='!'||hdr
    info.aa=value
    iterate
 end
 ii=ii+1
 lins.ii=gooba
end

say " # of matches: " ii

say "Creating "outfile
if stream(outfile,'c','query exists')<>'' then do
  say '   ' outfile 'exists!'
  aa=yesno(" Overwrite it ?",,'Y')
  if aa=1  then do
        foo=sysfiledelete(outfile)
        if foo<>0 then do
          say "Unable to delete (error # "foo
          exit
        end
  end
  else do
     say "bye.. "
     exit
  end
end


call lineout outfile,'<html><head><title>Swish Index View </title></head>'
call lineout outfile,'<body><h3>Viewing Results from Swish Index Search</h3>'
call lineout outfile,' '
call lineout outfile,'<ul>'
call lineout outfile,'<li>Searching for:<b>'info.!SEARCHWORDS'</b>'
call lineout outfile,'<li>Index searched:<b>' info.!SAVEDAS '</b>'
call lineout outfile,'<br>&nbsp;&nbsp;...Created:<tt> 'info.!INDEXEDON'</tt>'
call lineout outfile,'<br>&nbsp;&nbsp;...Description:<tt> 'info.!DESCRIPTION'</tt>'
call lineout outfile,'<br>&nbsp;&nbsp;...Counts:<tt> 'info.!COUNTS'</tt>'

call lineout outfile,' '
call lineout outfile,'<li>Number of hits= <b>'info.!NUMBEROFHITS'</b>'
call lineout outfile,'</ul>'
call lineout outfile,' '

call lineout outfile,'<table cellpadding=0 cellspacing=0>'
if show_dirs=1 then do
  call lineout outfile,'<tr bgcolor="'||color_dir||'"><td colspan=3><tt>Directory</tt></td>'
  call lineout outfile,'<tr bgcolor="'||color_even||'">'
  call lineout outfile,'<th colspan=2 align="right">&nbsp;&nbsp;Score</th><th>File</th><th>Description</th><th>File size</th>'
end
else do
  call lineout outfile,'<tr bgcolor="'||color_even||'">'
  call lineout outfile,'<th>Score</th><th>File</th><th>Description</th><th>File size</th>'
end
call lineout outfile,'<tr><td colspan=5><hr> '

/* sample:
1000 M:\SM2\docs/smpind02.txt "smpind02.txt" 1079
936 M:\SM2\docs/smpind00.txt "smpind00.txt" 1277
*/

fdir0=''
iseven=0
do nn=1 to ii
  parse var lins.nn score filename '"' adesc '"' bytes

  fdir=translate(filespec('d',filename)||filespec('p',filename),'\','/')
  if fdir<>fdir0 & show_dirs=1 then do
   call lineout outfile,'<tr bgcolor="'||color_dir||'"><td colspan=3><tt>'fdir'</tt></td>'
   fdir0=fdir
  end
  if bytes>10000 then  bytes=format(bytes/1000,,1)||'k'
  iseven=1-iseven
  call lineout outfile,'<tr bgcolor="'||bgs.iseven||'">'
  if show_dirs=1 then
     call lineout outfile,'<td colspan=2 align="right"><em>'score'&nbsp;</em>'
  else
     call lineout outfile,'<td><em>'score'&nbsp;</em>'

  fname=filespec('n',filename)
  aff=translate(filename,'/','\')
  aff=translate(aff,'|',':')
  adesc=strip(adesc,,'"')
  call lineout outfile,'<td><a href="file:///'||aff||'">'||fname||'</a></td>' 
  call lineout outfile,'<td>'adesc'</td>'
  call lineout outfile,'<td>'bytes'</td>'
end
call lineout outfile,'</table>'
call lineout outfile,'</body></html>'
call lineout outfile

dd=directory()
ar1=dd||'/'||translate(outfile,':','|')
ar1=translate(ar1,'/','\')
foo=viewer' file:///'||ar1
'@start /f 'foo
say " >>> starting "foo
say ' .... (it might take a few seconds to load)'

say "Done! "

exit

/* -------------------- */
/* choose between 3 alternatives (by default,a yes or no ),
return 1 if yes (or 0,1,2 for chosen altenative ) */

yesno:procedure
parse arg amessage , altans,def,arrowok
ahdr=''
if pos('|',amessage)>0 then parse var amessage ahdr '|' amessage
aesc='1B'x
cy_ye=aesc||'[37;46;m'
cyanon=cy_ye
normal=aesc||'[0;m'
bold=aesc||'[1;m'
re_wh=aesc||'[31;47;m'
reverse=aesc||'[7;m'

aynn=' '
if def='' then
 defans=''
else
 defans=translate(left(strip(def),1))
if altans='' then altans='No Yes'

w.0=words(altans)
do iw0=1 to w.0
     w.iw0=strip(word(altans,iw0))
     a.iw0=translate(left(w.iw0,1))
     aa.iw0=substr(w.iw0,2)
     aynn=aynn||bold
     if  a.iw0=defans then aynn=aynn||cy_ye
     aynn=aynn||a.iw0||normal||aa.iw0
     if iw0<w.0 then aynn=aynn'|'
end
if arrowok=1 then aynn=aynn||' [UP]'
do forever
 foo1=normal||ahdr||reverse||amessage||normal||aynn||' 'normal
 if length(amessage)+length(altans)<70 then
    foo1=normal||ahdr||reverse||amessage||normal||aynn||' 'normal
 else
    foo1=normal||ahdr||reverse||amessage||normal||'0d0a'x||'    '||aynn||' 'normal
 call charout, foo1
 anans=translate(sysgetkey('echo'))
 ianans=c2d(anans)
 if ianans=27 then return defans
 if anans='' | ianans=13 | ianans=10 then  anans=defans

 if arrowok=1 & ianans=0 then do
     ians=c2d(sysgetkey('noecho'))
     if ians=72 then  do
           say ;say
           return -1  /* -1 : up key */
     end
 end /* do */

 do ijj=1 to w.0
    if abbrev(anans,a.ijj)=1 then do
        say
        return Ijj-1
    end
 end /* do */
 call charout,'0d'x
end

