"""
    Visual ODBC Client
    ====== ==== ======
"""
# $Id: ZVisualODBCClient.py,v 1.2 2002/08/18 15:24:43 adrian Exp $
#
# $Log: ZVisualODBCClient.py,v $
# Revision 1.2  2002/08/18 15:24:43  adrian
# Fixed bug in ZVOC which caused ambiguous name warnings in the log
#
# Revision 1.1.1.1  2002/02/03 17:07:16  root
#
#
# Revision 1.2  2002/01/30 17:37:41  adrian
# Fixed some ODBC Query Bugs
#
# Revision 1.1  2002/01/21 00:58:09  adrian
# Rebased all queries and datacombiner on the Aqueduct DA
# Added argument support
# Added Drill-Down support to ZReportTool
#
#
__version__ = '$Revision: 1.2 $'[11:-2]

import Globals
import ZODBCClient
import OSSClient
import VisualQueryMixin
import socket
import urllib
import OFS.PropertyManager

manage_addZVisualODBCClientForm = Globals.HTMLFile('www/addZVisualODBCClient', globals())
def manage_addZVisualODBCClient(self, id, server='', port=0, dsn='', submit='', REQUEST=None):
    """ """
    obj = ZVisualODBCClient(str(id), server=str(server), port=int(port), dsn=str(dsn))
    self._setObject(obj.getId(), obj)
    if REQUEST is not None:
        try: u = self.DestinationURL()
        except: u = REQUEST['URL1']
        if submit==" Add and Edit ": u="%s/%s" % (u, urllib.quote(id))
        REQUEST.RESPONSE.redirect(u+'/manage_main')
    return ''

class ZVisualODBCClient(
        VisualQueryMixin._VisualQueryMixin,
        ZODBCClient.ZODBCClient,
    ):
    """ A Visual ZSQL Query Creator/Editor """
    manage_Tables = Globals.HTMLFile('www/XMLqueryTables', globals())
    manage_main = OFS.PropertyManager.PropertyManager.manage_propertiesForm
    id = 'ZVisualODBCClient'
    title = "Z Visual ODBC Client"
    meta_type = 'Z Visual ODBC Client'

    manage_options = (
        ZODBCClient.ZODBCClient.manage_options[0:1] +
        VisualQueryMixin._VisualQueryMixin.manage_options +
        ZODBCClient.ZODBCClient.manage_options[2:]
    )

    def __init__(self, id, server="", port=0, dsn=''):
        """ """
        ZODBCClient.ZODBCClient.__init__(self, id, server, port, dsn)
        self.manage_resetQuery()
        np = []
        for item in self._properties:
            if item['id'] != 'query':
                np.append(item)
        self._properties = tuple(np)
        return "Wibble"

    def title(self, REQUEST=None):
        """ """
        try:
            return "ZVOC on %s:%d %s" % (self.server, self.port, self.dsn, )
        except:
            return "ZVOC"

    def listTables(self):
        """ Can't list tables via XML ODBC """
        return None

    def listColumns(self, table):
        """ Return a list of the columns in a table """
        qry = OSSClient.OSSClient(self.server, self.port, self.dsn, "select top 1 * from %s" % table)
        if qry.state!=1:
            raise "Database Query Error", str(qry.error)
        return tuple(qry.datadictionary)

Globals.InitializeClass(ZVisualODBCClient)
