/* Yes FOLKS!  This is ReXX ! */

/* This script cuts down T-MAIL log to last XX days         */
/*                                                          */
/* Author:                                                  */
/* Radim Kolar             Fidonet: 2:423/66.111            */
/*                         Dark side of Avalon              */
/*                                                          */
/* Errorlevels:                                             */
/*       0 no work required                                 */
/*       1 log file succesfully processed                   */
/*       2 error when processing logfile, no work done      */
/*       3 removing temp file failed, but work is done      */
/*       9 log-file doesn't exits                           */
/*      10 bad arguments count 				    */
/*                                                          */
/* Version 0.14                                             */
/*                                                          */
/* Rev. history:                                            */
/*                                                          */
/* 22/04.96        0.14 added new working mode=generic      */
/*                 works like other mode but, instead age of*/
/*                 days, all numbers are size in KB         */
/*                 cut any text logfile to spec. size(in KB)*/
/* 27/10/95        0.13 GA version                          */
/*                 Fixed bug, when logfile is not in the    */
/*                 same directory as lcut.cmd.              */
/*                 better error handling in rename phase    */
/* 09/10/95        0.12 GA version. Fixed some typos        */
/*                                  improved help           */
/* 09/10/95        0.11 added Binkley - Term working mode   */
/*                      added log minsize in KB             */
/* 05/10/95        0.10 GA version, added HELP, some bugs   */
/*                 fixed                                    */
/* 05/10/95        0.03.001 - first working version         */
/* 05/10/95        development started                      */
          
Version='Version 0.14.000'
Progname='T-MAIL log file cutter'
Copyright='Copyright (C) Radim Kolar 1995. (Fidonet 2:423/66.111)'
Copyright2='This program is free to use without any modifications only.'

START:
select
  when 0=RXFuncQuery('SysDropFuncs') then udrop=0
  when 0=RxFuncAdd("SysLoadFuncs", "RexxUtil", "SysLoadFuncs") then udrop=1
  otherwise
  /* something may be wrong, reload all Package */
  say 'Reloading REXXUtil Package.'
  RXFuncDrop("SysLoadFuncs")
  RxFuncAdd("SysLoadFuncs", "RexxUtil", "SysLoadFuncs")
  call SysLoadFuncs;
  udrop=0
end

if udrop=1 then call SysLoadFuncs

say Progname
say Version
say Copyright
say Copyright2
say

/* parse */
wmode=1; /* 1 Tmail style log, 2 Binkley Term LOG, 3 Generic. */

parse arg logname days archname mdays msize
if logname='' then call helptext;
if days='' then days=90
if left(logname,1)='+' then do
                              wmode=2
                              logname=right(logname,length(logname)-1)
                            end  

if left(logname,1)='@' then do
                              wmode=3
                              logname=right(logname,length(logname)-1)
                            end  
                                                        
if ''=stream(logname,'c','QUERY EXISTS') then do
  say logname 'doesn''t exists!'
  call cleanup 9
  end
if archname='' then archname='NUL'
               else if POS('?',archname)>0 then 
                        archname=SysTempFileName(archname);
if mdays='' then mdays=0;               
if msize='' then msize=0;
  
/* begin */
tmpname=SysTempFileName('LC??.???');

lastday=''
lastpos=0
lastpos2=0
daycount=0

say 'Options:'
say 'Working mode (1-TMAIL, 2-BT, 3-Generic):' wmode
say 'Work only if' logname 'is older than' mdays 'days.'
say 'Work only if' logname 'is greater than' msize 'KB.'
say 'Actions:'
say 'Cut' logname 'to' days 'days.'
say 'Archive cutted lines to' archname
say
say 'Scanning log file: 'logname
say
xx=stream(logname,'C','QUERY SIZE')/1000

if (xx<msize)|( (wmode=3)& ( (xx<mdays)|(xx<days))) then
  do
    say 'Log file is too small.'
    call cleanup 0
  end  
if wmode\=3 then  
do while \(tmlparse(logname)=2)
 nop
end
            else
              daycount=format(xx,,0);

say daycount 'days found in logfile.'

if (daycount<=days) | (mdays>=daycount) then do
   say 'No work required'
   call cleanup 0
   end

stopon=daycount-days+1
lastday=''
lastpos=0
lastpos2=0
daycount=0
call stream logname,'C','CLOSE'
say 'Searching cut position ...'
if wmode\=3 then
do while \(tmlparse(logname)=2)
 if stopon=daycount then leave;
end
else
 do
   call stream logname,'C','OPEN READ' 
   say 'stopon' stopon
   call stream logname,'C','SEEK 'stopon*1000
   call linein logname
   lastpos2=stream(logname,'C','SEEK');
   say 'LP2' lastpos2
 end
call stream logname,'C','CLOSE'
say 'Cutting ...'
/* rozdelujeme soubor */
daycount=splitfile(logname,lastpos2,archname,tmpname);
call stream logname,'C','CLOSE'
/* osetreni chyb pri rozdelavani */
if daycount=1 then 
  do
    SysFileDelete(archname);
    SysFileDelete(tmpname);
    call cleanup 2
  end
say 'Renaming temporary file' tmpname 'to' logname'...'
/* a sachy s cleanupem zacinaji */
"@copy "tmpname logname ">NUL"   
/* say 'DEBUG: copy returns rc='rc */
if rc\=0 then 
  do
    SysFileDelete(archname);
    SysFileDelete(tmpname);
    call cleanup 2
  end
daycount=SysFileDelete(tmpname);
if daycount>0 then
  do
    say 'WARNING: Temporary file' tmpname 'is NOT removed, remove it manualy.'
    call cleanup 3
  end

say 'Work Succesfully ended.'    
call cleanup 1
/* Procedures BEGINS */

cleanup: procedure expose udrop
   arg n
   if udrop=1 then call SysDropFuncs
   exit n
return

helptext: procedure
    say 'lcut.cmd <logname> [days2keep] [archive to] [minage] [minsize]'
    say
    say '<logname> name of T-MAIL''s style log-file. *REQUIRED*'
    say '   when logname begins with +, than lcut.cmd is switched to Binkley Term'
    say '   log-file mode.'
    say '   when logname begins with @, than lcut.cmd is switched to generic log mode.'
    say '   in generic logfile mode days2keep parameter is size2keep (in KB)'
    say '[days2keep] max days to keep in logfile - default is 90'
    say '   note: days2keep means number of different days in your logfile, not time'
    say '         difference between now and log-file entry.'
    say '[archive to] filename where will be cutted entries stored, default is NUL'
    say '   note: You may use ? in filename to get unique name, but never use'
    say '         more then five ? in filename!'
    say '[minage] Minimum age of logfile, required for any lcut''s action. default 0 days'
    say '[minsize] Minimum log-file size in KB required for any lcut''s action. default 0'
    say '   note: 1K = 1000 bytes'
    say
    say 'Examples:'
    say '========='
    say
    say 'lcut t-mail.log 40 '
    say '      Cut Tmails log to 40 days'
    say' lcut t-mail.log 40 NUL 0 100'
    say  '     If Tmail.log is greater than 100K, then cut it to last 40 days.'
    say 'lcut t-mail.log 40 TM????.LOG'
    say '      The same, but store cutted entries in TMXXXX.LOG'
    say 'lcut t-mail.log 7 TM????.LOG 100'
    say '      If log is older than 100 days, then will be cutted into 7 days and cutted'
    say '      entries will be stored in TM????.LOG file.'
    say 'lcut +squish.log'
    say '      Cut Binkley-Style squish.log to 90 days'
    
    say
    say 'Please send bugs, typos, suggestions to Radim Kolar 2:423/66.111@Fidonet.Org'
    
    call cleanup 10
return

/* vraci 2 konec souboru, 1 novy den, 0 OK */
tmlparse: procedure expose lastday lastpos daycount lastpos2 wmode
    arg logname
    ln=linein(logname);
    np=stream(logname,'C','SEEK');
    if np=lastpos then return 2
    lastpos2=lastpos;
    lastpos=np;
    if length(ln)=0 then return 0 /* 0 */
    if wmode=1 then do
      ld=left(ln,5);
      if \(substr(ln,3,1)='/') then return 0 /* nejaka zla radka */
      end
      else
      do
      ld=left(ln,9)
      if \(substr(ln,2,1)=' ') then return 0 /* nejaka zla radka */
      if \(substr(ln,5,1)=' ') then return 0 /* nejaka zla radka */
      if \(substr(ln,9,1)=' ') then return 0 /* nejaka zla radka */
      /* konec simple BT- testu */
      ld=right(ld,7);
      end
    if ld=lastday then return 0
    /* novy den detected */
    lastday=ld;
    daycount=daycount+1;
return 1

/* rozreza logname na dva soubory A a B, kde A je soubor pred bodem zlomu */
/* t.j. ten co se ma vyhodit a B je po bodu zlomu t.j. ten co by se mel nechat */
/* vraci 0 OK ci 1 pri chybe */
splitfile: procedure
    arg logname,splitpos, a, b 
    /* test souboru */
    wfile=a; /* nejdrive do acka ! */
    call SysFileDelete(a);
    if\('READY:'=stream(a,'C','OPEN WRITE')) then return 1;
    call SysFileDelete(b);
    if\('READY:'=stream(b,'C','OPEN WRITE')) then return 1;
    lastpos=0
    do forever
      ln=linein(logname);
      np=stream(logname,'C','SEEK');
      if np=lastpos then leave /* kaneec! */
      lastpos=np;
      junk=lineout(wfile,ln)
      if junk=1 then return 1;
      if np=splitpos then wfile=b;
    end
    call stream a,'C','CLOSE'  
    call stream b,'C','CLOSE'
return 0
