/*

    GUS-REXX, CopyRight 1993 by Ralph Theren, 2:240/5505 + 5599
    Version vom 21.02.1993

    Dieses Tool entstand weil ich
    1.    das LinuxNet gepackt als *.ZIC (PkZip alt)
    2.a)  das FernWood gepackt als *.ZIC (PkZip neu)
      b)                       als *.LIC (LHarc)
    gepackt erhalte. Das haette unter meinem Mailer ein bisschen viel
    Aufwand bedeutet, oder ich haette von TICK auf FileMgr umsteigen
    muessen.

    Oder ich benoetigte halt eine (G)eneral (U)npacking (S)hell unter
    OS/2.

    Letzteres schien mir die intelligenteste Loesung, da der Einsatz auch
    in anderen Bereichen hilfreich sein kann.

    Aufrufe als Beispiel:

    Call GUS-Rexx *.ZIC
    Call GUS-Rexx *.ZIC \TEMP
    GUS-REXX demo.zip
    GUS-Rexx *.*

    Parameter 1: Wildcard-Muster der zu entpackenden Files
    Parameter 2: optionaler Parameter:
                 ein Directory zum Sichern fehlerhaft entpackter Archive

    Zur weiteren Beschreibung siehe unten!

    Notwendige Modifikationen zu den Entpackern koennen individuell von
    jedermann durchgefuehrt werden.

    Ansonsten wuerde ich mich ueber Anregungen zur Verbesserung freuen.
*/

SAY "GUS-REXX, (c) 1993 by Ralph Theren, 2:240/5505"

PARSE ARG FileString TempDir

IF (LENGTH(FileString)=0) THEN
   RETURN 240                                /* 240 = Kein Filename */

CALL RxFuncAdd 'SysFileTree','RexxUtil','SysFileTree'
CALL SysFileTree FileString,'file','F'

/* Prfen ob Files des Argumentes 1 gefunden wurden */
IF file.0 = 0 Then
   RETURN 241                                /* 241 = No Files found */

/*
   Das 2.te Argument kann ein Pfad sein, in den ein fehlerhaftes Archiv
   kopiert wird (Erkennung durch Errorcode des Entpackers). Nach dem
   kopieren wird das Original geloescht. Ist interessant beim Einsatz
   unter einem Mailer, falls File-Archive aus einem FileNetz fehlerhaft
   ankommen. Z.B. Archive des FileManagers mit *.ZIC, *.LIC etc....
   So wird eine Sicherheitskopie angelegt zur spaeteren Bearbeitung.
*/
ErrCopy = False
IF (LENGTH(TempDir) > 0) THEN
   ErrCopy = True

/*
    Hier muessen die notwendigen Parameter fuer die diversen Packer
    definiert werden:

    MaxPack = Anzahl der definierten Packer

    IdArc.n  = Ident-String des Packers
    Offset.n = Position des Ident-String im Archiv
    UnArc.n  = Syntax des Entpack-Befehls

    Die Reihenfolge der Packerdefinitionen kann _ENTSCHEIDEND_ sein.
    Hier wird zuerst auf den neuen PkZip (1.93, 2.04 und hher) geprueft,
    erst danach auf den alten PkZip. Diese Reihenfolge ist zu beachten, da
    beide die ersten 4 Bytes identisch haben.

    Klaro, der 2.04 entpackt bisher ALLE PkZip 1.alt auch korrekt, also
    wuerde es reichen, immer nur auf PkZip zu testen. Interessant ist
    aber, fuer alte PkZip mit dem Info-Zip UNZIP zu arbeiten, aus
    Kompabilitaetsproblemen aber bei PkZip204-Archiven dann den DOS-PkZip
    2.04 einzusetzen, also nur im "Notfall" wirklich das DOS-Programm
    einzusetzen :-)
*/
MaxPack = 6

IdArc.1  = "PK"||D2C(3)||D2C(4)||D2C(20)      /* PK^c^d^t  = PkZip 2.x neu */
Offset.1 = 0
UnArc.1  = "UnZip -o -j"
/* UnArc.1  = "c:\my\dtools\PkUnzip -e"          Falls PkUnzip 2.04c/e benutzt werden soll */

IdArc.2  = "PK"||D2C(3)||D2C(4)               /* PK^c^d    = PkZip 1.x alt */
Offset.2 = 0
UnArc.2  = "UnZip -o -j"

IdArc.3  = X2C(60)||X2C(ea)                   /* ARJ <= 1.30 */
Offset.3 = 0
UnArc.3  = "UnArj e"

IdArc.4  = "-lh"                               /* LH  <= 2.14 */
Offset.4 = 2
UnArc.4  = "LH x"

IdArc.5  = "ZOO"                               /* ZOO         */
Offset.5 = 0
UnArc.5  = "ZOO e:O"

IdArc.6  = X2C(1a)                             /* ARC         */
Offset.6 = 0
UnArc.6  = "ARC2 -eo"


/*
    Okay, und nun geht es an das Entpacken der gefunden Files
*/

DO i=1 TO file.0
   filename = SUBWORD(file.i,5,1)

   IdentStr = CHARIN(filename, 1, 10)

   ErrString = STREAM(filename,'c','close')

   IF (SUBSTR(ErrString,1,5) \== 'READY') THEN
      RETURN 242                       /* Fehler beim Schliessen des Files */

   IF LENGTH(IdentStr) < 10 THEN
      RETURN 243                       /* Archiv mit weniger als 10 Bytes ? */

   UnPackShell = ""
   gefunden = False
   j = 1

   DO WHILE (j <= MaxPack) & (gefunden = False)
      IF (SUBSTR(IdentStr, Offset.j+1, LENGTH(IdArc.j)) = IdArc.j) THEN
         DO
            gefunden = True
            '@'||UnArc.j||' '||filename
            IF (rc <> 0) & (ErrCopy = True) Then
               DO
                  '@Copy' filename TempDir
                  '@Del' filename
               END
         END
      ELSE
         j = j + 1
   END

   IF (gefunden = False) THEN
       RETURN 244                       /* kein Packformat erkannt ! */

END i

EXIT
