/* Install.Cmd -- REXX */
/*
           ***************************************************************************************
           ***************************************************************************************
           ***                          Install WPSbkup 4.0                                    ***
           ***       For syntax, see the SelfDocExit procedure at the end of this file.        ***
           ***                                                                                 ***
           ***************************************************************************************
           ***************************************************************************************
*/
  
 parse ARG Arg1
 if ("" == Arg1) | (WordPos( Arg1, "/H /h /? -H -h -?") > 0) then 
     call SelfDocExit 
 
 call RxFuncAdd SysLoadFuncs, RexxUtil, SysLoadFuncs 
 call SysLoadFuncs 
 
 TgtPath = Arg1 
 '@IF NOT EXIST 'TgtPath'\*  @MD 'TgtPath
 call SysFileTree  TgtPath, FileTree, 'DT'
 if FileTree.0 <> 1 then 
 do 
     say "Can't find or create directory "TgtPath || D2C( 7)
     call SelfDocExit 
 end
 SAY "  Copying runtime files..." 
 '@COPY README.1ST  'TgtPath' >NUL'
 '@COPY WPSADMN.EXE 'TgtPath' >NUL'
 '@COPY WPSBKUP.EXE 'TgtPath' >NUL'
 '@COPY WPSBWRP.DLL 'TgtPath' >NUL'
 '@COPY WPSADMN.HLP 'TgtPath' >NUL'
 '@COPY WPSREST.EXE 'TgtPath' >NUL'
 '@COPY QLOG.EXE    'TgtPath' >NUL'
 '@COPY QLOG.HLP    'TgtPath' >NUL'
 SAY "  Setting extended attributes..." 
 '@EAUTIL 'TgtPath' HD.EA /J /P /O >NUL'
 '@EAUTIL 'TgtPath'\README.1ST  README.EA   /J /P /O >NUL'
 '@EAUTIL 'TgtPath'\WPSADMN.EXE WPSADMN.EA  /J /P /O >NUL'
 '@EAUTIL 'TgtPath'\WPSBKUP.EXE WPSBKUP.EA  /J /P /O >NUL'
 '@EAUTIL 'TgtPath'\WPSBWRP.DLL WPSBKUPD.EA /J /P /O >NUL'
 '@EAUTIL 'TgtPath'\WPSADMN.HLP WPSADMNH.EA /J /P /O >NUL'
 '@EAUTIL 'TgtPath'\WPSREST.EXE WPSREST.EA  /J /P /O >NUL'
 '@EAUTIL 'TgtPath'\QLOG.EXE    QLOG.EA     /J /P /O >NUL'
 '@EAUTIL 'TgtPath'\QLOG.HLP    QLOGH.EA    /J /P /O >NUL'
 
 SAY "  Creating desktop shadow folder..." 
 /* Create object on Desktop */
 Setup = 'SHADOWID='TgtPath';'
 rc = SysCreateObject( "WPSHADOW", "X", "<WP_DESKTOP>", Setup, "replace" ) 

 SAY ""
 SAY ""
 SAY ""
 SAY "   WPSbkup software installation is complete."
 SAY "   Double click the WPSbkup folder icon that is on your desktop."
 SAY "   Thank you for trying WPSbkup."
 SAY ""
 SAY ""
 SAY ""
 
 EXIT  rc
 
 /* ------------------------------------------------------------------------- */
 
 SelfDocExit:        procedure           expose SrcPath BootSetMax 
 
 SAY "Install.Cmd"
 SAY "This little REXX command will copy the WPSbkup 4.0 shareware distribution"  
 SAY "files to a target directory that you need to specify.  (see syntax below)"
 SAY "For best results, please specify an empty directory."
 SAY ""
 SAY "An icon will be placed on your desktop for WPSbkup.  You may move this icon"
 SAY "to another folder if you wish."
 SAY ""
 SAY "NOTE:       You need at least 405k bytes available on the target drive."
 SAY ""
 SAY "USAGE:      INSTALL  target_dir_fullpathname"
 SAY "EXAMPLE:    Install  D:\WPSBKUP"
 
 EXIT  1
 
 /* ------------------------------------------------------------------------- */
 /* end file Install.Cmd */
 


