/**
 * $Id$
 * 
 * Copyright 1993-2006, John J. Allen.
 * Released under the GNU GPL v2 or later.
 * The header defines MACROS for conditional checking.
 * MFail()            Logs the message to the trace.log and causes the
 *                   application to stop.
 * 
 * MFailIf()          If condition is TRUE logs the message to the trace.log
 *                   and causes the application to stop.
 * 
 * MFailIfNull()      If value is NULL logs the message to the trace.log and
 *     		     causes the application to stop
 * 
 * MEnsure()          Fails if the expression is FALSE logs the message to the
 *                   trace.log and causes the application to stop.
 * 
 * MStackCall()       Add the file & line number to a linked list which
 * 	     is dumped to a file on failure.
 *                   File = "Stack Call" for NT
 *                   File = "Stack Call" for OS/2
 *                   File = "StckCall" for DOS
 * 
 * MBreakPoint()      Causes the app to jump to the debugger app will
 *                   terminate under OS/2 unless running under debugger.
 * 
 * MUnimplemented()   Logs the message to the trace.log and causes the
 *                   application to stop.
 * 
 */

#if !defined(CONDITIO_HPP)
#define CONDITIO_HPP

#include <types.hpp>
#include <tracer.hpp>
#include <dos.h>

#if defined(disable)
#undef disable
#endif

	#if defined(DEBUG)

	#if defined(__BORLANDC__)
		#define MBreakPoint()		geninterrupt(3)
	#else
		#define MBreakPoint()
	#endif

		void EXP_FUNC _MemCheck();

		void EXP_FUNC _FailIf
			(
			BOOL  Condition,
			PCHAR ConditionStr,
			PCHAR File,
			long 	line
			);

		void EXP_FUNC _Fail
			(
			PCHAR MsgStr,
			PCHAR File,
			long 	line
			);

		int EXP_FUNC _Ensure
			(
			BOOL  Condition,
			PCHAR ConditionStr,
			PCHAR File,
			long 	line
			);

		#define 	MFailIf(Condition) \
			_FailIf((Condition) != 0, \
			#Condition, \
			__FILE__, \
			__LINE__)

		#define 	MFailIfNull(Value) \
			_FailIf((Value) == NULL, \
			#Value " == NULL", \
			__FILE__, \
			__LINE__)

		#define 	MUnimplemented() \
			_Fail(("Unimplemented feature"), \
			__FILE__, \
			__LINE__)

		#define 	MFail(Msg) \
			_Fail((Msg), \
			__FILE__, \
			__LINE__)

		#define 	MEnsure(Condition) \
			while(_Ensure((Condition) != 0, \
			#Condition, \
			__FILE__, \
			__LINE__))

	#else
		#define MFailIf(Condition)
		#define MFailIfNull(Value)
		#define MFail(Msg)
		#define MUnimplemented()
		#define MEnsure(Condition)	Condition
		#define MBreakPoint()
	#endif

	#define MTerminate() callStack::dump(); MBreakPoint(); exit(EXIT_FAILURE)
#endif
