/* 
   drvMIF.cpp : This file is part of pstoedit
   Backend for Framemaker(TM) MIF format

   Copyright (C) 1993,1994,1995,1996 Wolfgang Glunz, Wolfgang.Glunz@zfe.siemens.de

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*/

#include "drvmif.h"
#include <iostream.h>
#include <string.h>
#include <stdio.h>

static const char * colorstring(float r, float g, float b)
{
static char buffer[15];
	sprintf(buffer,"R%.3dG%.3dB%.3d", (int) (r * 255), (int) ( g * 255) ,  (int) (b * 255));
	return buffer;
}

static ColorTable colorTable(0,0,colorstring);

static void writeColorCatEntry(ostream & out, float r, float g, float b)
{
// all ColorCatEntries are written directly to the output file.
// the other stuff is written to the buffer
if (!colorTable.isKnownColor(r,g,b)) {
// color not known so far
	int cyan    = (int) (100 * (1.0 - r)) ;
	int magenta = (int) (100 * (1.0 - g)) ;
	int yellow  = (int) (100 * (1.0 - b)) ;
	//int black   = ((cyan + magenta + yellow) == 300 ) ? 100 : 0; // black 0 if not black
	int black = 0;

	// remember, getColorString registers the new color
	out << " <Color "
	    << "<ColorTag " << colorTable.getColorString(r,g,b) << " > " 
	    << "<ColorCyan " << cyan  << " >"
	    << "<ColorMagenta " << magenta  << " >"
	    << "<ColorYellow " << yellow  << " >"
	    << "<ColorBlack " << black  << " >"
	    << ">" << endl;
} 
}

drvMIF::drvMIF(const char * driveroptions_p,ostream & theoutStream,ostream & theerrStream):
	drvbase(driveroptions_p,theoutStream,theerrStream,0,0,0),
    	buffer(tempFile.asOutput())
{
	outf << "<MIFFile 4.00>\n";
	outf << "<Units Upt >\n";
	outf << "<ColorCatalog\n";
				 // output buffer, needed because
				 // color entries must be written at
				 // top of output file, but are known
				 // only after processing the full input

}

drvMIF::~drvMIF() 
{

	outf << ">\n";// end of ColorCatalog
	ifstream & inbuffer = tempFile.asInput();
	copy_file(inbuffer,outf);
} 

void drvMIF::print_coords()
{
    for (unsigned int n = 0; n < numberOfElementsInPath(); n++) {
	const Point & p = pathElement(n).getPoint(0);
        buffer <<" <Point "  
	     << p.x_ + x_offset << " pt " 
	     << currentDeviceHeight - p.y_ + y_offset << " pt>" 
	     << endl;
    }
}

void drvMIF::close_page()
{
    buffer << "> # end of Frame\n";
    buffer << "> # end of Page\n";
}

static const int Fill   = 0;  // solid fill
static const int noFill = 15; // no fill

void drvMIF::open_page()
{
    buffer << "<Page\n";
    buffer << " <PageType BodyPage >\n";
    buffer << " <PageNum `" << currentPageNumber << "'>\n";
//    buffer << " <PageSize  612.0 pt 792.0 pt>\n";
    //     currentDeviceWidth), RND(currentDeviceHeight
    buffer << " <PageSize  " << currentDeviceWidth << " pt " << currentDeviceHeight  << " pt>\n";
    buffer << " <PageOrientation Portrait >\n";
    buffer << " <PageBackground `Default'>\n";
    buffer << "<Frame\n";
    buffer << "  <Pen 0>\n";
    buffer << "  <Fill " << noFill << ">\n"; 
    buffer << "  <PenWidth  1.0 pt>\n";
    buffer << "  <Separation 0>\n";
//    buffer << "  <BRect  0.0 pt 0.0 pt 612.0 pt 792.0 pt>\n";
    buffer << "  <BRect  0.0 pt 0.0 pt " << currentDeviceWidth << " pt " << currentDeviceHeight  << " pt>\n";
    buffer << "  <FrameType NotAnchored >\n";
}

void drvMIF::show_text(const TextInfo & textinfo)
{
    const char * start_of_text = textinfo.thetext;
    buffer << "  <TextLine \n";
    buffer << "   <TLOrigin  " 
	 << textinfo.x + x_offset << " pt " 
	 << currentDeviceHeight - textinfo.y + y_offset << " pt>\n";
    buffer << "   <TLAlignment Left >\n";
    buffer << "   <Angle " << textinfo.currentFontAngle << " >" << endl;
    buffer << "   <Font \n";
    buffer << "    <FTag `'>\n";
    buffer << "    <FFamily `";
    const char * cp = textinfo.currentFontName.value();
    // print up to first '-' or end of string 
    while (cp && *cp && (*cp != '-') ) {
	buffer << *cp;
	cp++;
    }
    buffer << "'>\n";

    buffer << "# currentFontFamilyName: " <<  textinfo.currentFontFamilyName.value() << endl;
    buffer << "# currentFontFullName: " << textinfo.currentFontFullName.value() << endl;
    buffer << "# currentFontName: " << textinfo.currentFontName.value() << endl;
    buffer << "    <FVar `Regular'>\n";
    buffer << "    <FWeight `" << textinfo.currentFontWeight.value() << "'>"<< endl;
    if (  (strstr(textinfo.currentFontName.value(),"Italic") != NULL)  ||
          (strstr(textinfo.currentFontName.value(),"Oblique") != NULL))  {
    	buffer << "    <FAngle `Italic'>\n";
    } else {
    	buffer << "    <FAngle `Regular'>\n";
    }
    buffer << "    <FSize  " << textinfo.currentFontSize << " pt>\n" ;
    buffer << "    <FUnderline No >\n";
    buffer << "    <FOverline No >\n";
    buffer << "    <FStrike No >\n";
    buffer << "    <FSupScript No >\n";
    buffer << "    <FSubScript No >\n";
    buffer << "    <FChangeBar No >\n";
    buffer << "    <FOutline No >\n";
    buffer << "    <FShadow No >\n";
    buffer << "    <FPairKern Yes >\n";
    buffer << "    <FDoubleUnderline No >\n";
    buffer << "    <FNumericUnderline No >\n";
    buffer << "    <FDX  0.0 pt>\n";
    buffer << "    <FDY  0.0 pt>\n";
    buffer << "    <FDW  0.0 pt>\n";
    buffer << "    <FSeparation 0>\n";
    writeColorCatEntry(outf,textinfo.currentR,textinfo.currentG,textinfo.currentB);
    buffer << "     <FColor `" << colorTable.getColorString(textinfo.currentR,textinfo.currentG,textinfo.currentB) << "'> ";
    buffer << "\n" << endl;
    buffer << "   > # end of Font\n";
    buffer << "   <String `";
    while (*start_of_text) {
	    if ( (*start_of_text == '>') ||
	         (*start_of_text == '\'')
					 ){
		buffer << "\\";
	    }
	    buffer << *start_of_text;
	    start_of_text++;
    }
    buffer << "'>\n";
    buffer << "  > # end of TextLine\n";
}


void drvMIF::show_path()
{

    if (isPolygon()) {
    numberOfElementsInPath()--; // MIF does not need end=start
    buffer << "<Polygon\n <NumPoints " << numberOfElementsInPath() << ">\n";
    if (currentShowType() == drvbase::stroke) {
    	buffer << " <Fill " << noFill << ">\n";
    } else {
    	buffer << " <Fill " << Fill << ">\n";
    }
    buffer << " <Pen  " << Fill << ">\n";
    buffer << " <PenWidth "  << currentLineWidth() << " pt>\n";
    writeColorCatEntry(outf,currentR(),currentG(),currentB()) ;
    buffer << " <ObColor `" << colorTable.getColorString(currentR(),currentG(),currentB()) << "'>";
    buffer << "\n" << endl;
    print_coords();
    buffer << "> # end of Polygon\n";
    numberOfElementsInPath()++; // restore old value for proper cleanup
    } else {
    buffer << "<PolyLine\n <NumPoints " << numberOfElementsInPath() << ">\n";
    if (currentShowType() == drvbase::stroke) {
    	buffer << " <Fill " << noFill << ">\n";
    } else {
    	buffer << " <Fill " << Fill << ">\n";
    }
    buffer << " <Pen " << Fill << ">\n";
    buffer << " <PenWidth " << currentLineWidth() << " pt>\n";
    writeColorCatEntry(outf,currentR(),currentG(),currentB()) ;
    buffer << " <ObColor `" << colorTable.getColorString(currentR(),currentG(),currentB()) << "'>";
    buffer << endl;
    print_coords();
    buffer << "> # end of PolyLine\n";
    }
}

void drvMIF::show_rectangle(const float llx, const float lly, const float urx, const float ury)
{
    buffer << "<Rectangle\n";
    if (currentShowType() == drvbase::stroke) {
    	buffer << " <Fill " << noFill << ">\n";
    } else {
    	buffer << " <Fill " << Fill << ">\n";
    }
    buffer << " <Pen  " << Fill << ">\n";
    buffer << " <PenWidth " << currentLineWidth() << " pt>\n";
    writeColorCatEntry(outf,currentR(),currentG(),currentB()) ;
    buffer << " <ObColor `" << colorTable.getColorString(currentR(),currentG(),currentB()) << "'>";
    buffer << "\n" << endl;
    buffer << " <BRect ";
    buffer <<  llx + x_offset << " pt ";
    buffer <<  currentDeviceHeight - ury + y_offset << " pt ";
    buffer <<  urx - llx << " pt "; /* dx */
    buffer <<  ury - lly << " pt "; /* dy */
    buffer << "> \n> # end of Rectangle\n";
}
