/* Rexx Diskete File Fixer                     */
/*      12/03/1997        v 1.0                */
/* Tries to read all good sectors from file    */
/*  bad sectors are replaced by ???????        */
/* I use it to fix rar archives with data      */
/*  recovery record, becouse rar 2.0 have some */
/*  troubles with repair files on bad disks.   */
/* Public domain donated by                    */
/* Radim Kolar, Team OS/2, Czech Republic      */
/* Progress indicator is borowed from          */
/* Rexx Tips & Ticks,                          */
/* Copyright (c) 1994 - 1996 by Bernd Schemmer.*/
/*                                             */
/* email:                                      */
/*  hsn@cybermail.net                          */

parse arg infile outfile
if infile='' then do
     		    say "fixfile.cmd infile outfile"
                    return 1
                  end
if outfile='' then do
     		    say "fixfile.cmd infile outfile"
                    return 2
                  end
fsize=stream(infile,'C','QUERY SIZE')                    
if fsize='' then do 
                  say "Cannot open input file!"
                  return 3
                 end

blocksize=512                                    
say "File name: "infile
say "Write to : "outfile
say "File size: "trunc(fsize/blocksize)"x"blocksize"+"fsize-trunc(fsize/blocksize)*blocksize
say

remain=fsize-trunc(fsize/blocksize)*blocksize;
if remain=0 then bonus=0 
            else bonus=1;

   p1.0 = "\"
   p1.1 = "-"
   p1.2 = "/"
   p1.3 = "-"
   p2 = 0


"@del 2>nul "outfile

blocks=trunc(fsize/blocksize)
/* soubor zacina na 1 */
 call stream infile,'C','OPEN READ'
do i=1 to blocks+bonus
 if i>blocks then blocksize=remain
 buffer = charin(infile,,blocksize)
 if length(buffer)\=blocksize then do 
                              say 'Error reading block 'i
                              buffer=copies('?',blocksize);
                              call stream infile,'C','CLOSE'
                              call stream infile,'C','OPEN READ'
                              pos1=((i)*blocksize)+1
                              call stream infile,'C','SEEK 'pos1
                             end 
 call charout outfile, buffer
 call charOut , "1B"x || "[sReading block "i"/"blocks+bonus " " || p1.p2 || "1B"x || "[u"
 p2 = (p2+1) // 4
end
call stream infile,'C','CLOSE'
call stream outfile,'C','CLOSE'
say
say 'Done.'
