/* KillIco, belongs to Doublico */

CALL RxFuncAdd 'SysLoadFuncs','RexxUtil','SysLoadFuncs'

CALL SysCls
SAY
SAY

/* Delete an object, using the full path of it's shadow (drag &  */
/* drop), so both the shadow and original object will be deleted */

PARSE ARG filename

IF filename='' | filename='/?' | filename='-?' THEN DO
   SAY 'KillIco is a part of Doublico. Doublico creates a folder with'
   SAY '(shadows of) identical files. Found identical files which you'
   SAY 'want to delete, have to be dropped on KillIco.'
   SAY
   SAY 'This way, KillIco deletes both the shadow and original file,'
   SAY 'instead of just the shadow of the original object. It is the'
   SAY 'same as deleting the original object.'
   SAY
   SAY '   Syntax:'
   SAY
   SAY '      KILLICO <object>'
   SAY
   SAY '   Where <object> is the object to be deleted.'
   SAY
   EXIT
END

PARSE VAR filename '"' filename '"'

rc=SysFileTree(filename,check,'F','*----')

IF rc=2 THEN DO
   SAY 'Error: Not enough memory available to query a list of files.'
   SAY
   SAY 'The file "'||filename||'" is not deleted.'
   SAY
   EXIT
END

IF check.0=0 THEN DO
   SAY 'Error: Specified file not found, or the file is not accessible.'
   SAY
   SAY 'The file "'||filename||'" is not deleted.'
   SAY
   EXIT
END

IF check.0>1 THEN DO
   SAY 'KillIco deletes just one file at a time. Do not use wildcards.'
   SAY
   SAY 'Nevertheless it is possible to drop more than one object on it'
   SAY 'at once. In that case OS/2 starts KillIco multiple times, each'
   SAY 'with just one file as parameter.'
   SAY
   SAY 'KillIco has not deleted any files.'
   SAY
   EXIT
END

CALL SysDestroyObject(filename)

EXIT
