/***************************************************************************/
/* Displays the most recently written files on a given drive, plus the     */
/* date and time of the files.                                             */
/* All the hard work is done by the heapsort algorithm, which I got from   */
/* Dirk Terrell's article in OS/2 E-Zine                                   */
/*        http://www.os2ezine.com/v3n17/rexx.htm                           */ 
/* with a small modification taken from Mark Crocker's REXX Tips & Tricks  */
/*      http://www.markcrocker.com/rexxtipsntricks/rxtt28.2.0472.html      */
/***************************************************************************/
/*              Manfred Agne (manfred.Agne@netsurf.de), 09.08.2001         */
/***************************************************************************/

call RxFuncAdd 'SysLoadFuncs','RexxUtil','SysLoadFuncs'
call SysLoadFuncs

filemask='*'
numberoffiles=20

arg filemask path
if length(filemask) = 0 then
do
  say 'SYNTAX: FINDNEW <filemask> [path], eg. FINDNEW * C:\'
  say ' if [path] is not specified, the current directory'
  say ' and its subdirectories will be searched'
  exit
end
len=length(path)
if path <>'' then if substr(path,len,1)<>'\'then path=path||'\'
call SysFileTree path||filemask,'stem','FST'
filedate.0=stem.0
filename.0=stem.0
do i=1 to filedate.0
  fd=word(stem.i,1)
  if substr(fd,1,2)<40 
    then century='20' 
    else century='19'
  filedate.i=century||substr(fd,1,2)||substr(fd,4,2)||substr(fd,7,2)||substr(fd,10,2)||substr(fd,13,2)
end
do i=1 to filename.0
  fnpos=35
  filename.i=substr(stem.i,fnpos,length(stem.i)-fnpos+1)
end
Arrays="filedate. filename."
et=HeapSort()
z = stem.0 - numberoffiles +1
if z<1 then z=1
say 'latest 'numberoffiles' files are:'
do i=stem.0 to z by -1  
  say substr(filedate.i,7,2)||'.'||substr(filedate.i,5,2)||'.'||substr(filedate.i,1,4)||'  '||substr(filedate.i,9,2)||':'||substr(filedate.i,11,2)||'  '||filename.i
end
Exit

 /* ------------------------------------------------------------------ */
 /* function: heap sort routine that tracks multiple stems             */
 /*                                                                    */
 /* call:     HeapSort                                                 */
 /*                                                                    */
 /* returns:  nothing                                                  */
 /*                                                                    */
 /* notes:    The variable Arrays must be a string containing the names*/
 /*           of the stems that will be sorted. The first stem listed  */
 /*           is the one that is used as the key (i.e., the values that*/
 /*           will be sorted) and the others are the ones whose values */
 /*           follow the items in the key array. For example, suppose  */
 /*           you have a stem called Names., another array Weights.,   */
 /*           and another array Heights. and you want to sort the      */
 /*           arrays by the weights. You would call HeapSort with the  */
 /*           Arrays variable set as Arrays="Weights. Names. Heights." */
 /*           (The order of the secondary stems Names. and Heights. is */
 /*           not important.)                                          */
 /*                                                                    */
 /* reference: Sedgewick, "Algorithms"                                 */
 /*                                                                    */
 /* ------------------------------------------------------------------ */

 Heapsort: PROCEDURE expose (Arrays)
   start=Time("R")
   NArrays=Words(Arrays)
   Interpret "NItems="||Word(Arrays,1)||"0"

/* Copy the original stems to temporary ones */
Do i=0 to NItems
   Interpret "Stem.i="||Word(Arrays,1)||i
   Do j=2 to NArrays
      Interpret "Stem.i.j="||Word(Arrays,j)||i
   end /* do */
end /* do */

   M = stem.0
   N = M
 
   do k=M % 2 to 1 by -1
     call DownHeap k N
   end /* do */
 
   do while N>1
     t = stem.1
     Do i=2 to NArrays
        t.i=Stem.1.i
     end /* do */
     stem.1 = stem.n
     Do i=2 to NArrays
        Stem.1.i=Stem.n.i
     end /* do */
     stem.n = t
     Do i=2 to NArrays
        Stem.n.i=t.i
     end /* do */
     n = n-1
     call DownHeap 1 N
   end /* do */

/* Re-order the original stems */
   Do i=0 to NItems
      Interpret Word(Arrays,1)||i||"="||"Stem.i"
      Do j=2 to NArrays
         Interpret Word(Arrays,j)||i||"="||"Stem.i.j"
      end /* do */
   end /* do */
/* Stop the timer */
   end=time("R")
   elapsed=end-start

 RETURN elapsed
 
 /* subroutine of HeapSort                                             */
 DownHeap: PROCEDURE expose stem. NArrays
   parse Arg k N
 
   v = stem.k
   Do i=2 to NArrays
      v.i=Stem.k.i
   end /* do */
 
   do while k <= N%2
     j = k+k
     if j < n then
     do
       i = j+1
       if stem.j << stem.i then
         j=j+1
     end  /* do */
 
     if v >>= stem.j then
       signal label
 
     stem.k = stem.j
     Do i=2 to NArrays
        Stem.k.i=Stem.j.i
     end /* do */
     k = j
   end /* do */
 
 Label:
   stem.k = v
   Do i=2 to NArrays
      Stem.k.i=v.i
   end /* do */
 RETURN
