program d1d2crk;

(*$D Generator fr .CRK (CRACKER.EXE) und .PAT (OS/2 PATCH /A) Dateien *)

uses
  spra_aus;

(* V.K. 16.04.1997 *)
(*      20.04.1997 *)
(*      11.10.1997 Korrektur .CRK, Englisch *)
(*      11.03.1998 spra_aus neu *)
(*      1998.12.20 2 Durchgnge fr OS/2 .PAT *)

var
  d1,d2:file;
  p1,p2:array[1..512] of byte;
  l1,l2:(*$IFDEF OS2*)longint(*$ELSE*)word(*$ENDIF*);
  crk:text;
  lesen:longint;
  zaehler:longint;
  posi_text:string;
  crk_pat_unbekannt:(ziel_crk,ziel_pat,ziel_unbekannt);
  dateiname_in_patchdatei:string;
  block,datei_laenge:longint;

(*$I D1D2$$$$.001 *)

(*$I D1D2$$$$.002 *)


function hexb(b:byte):string;
  const
    hexziffern:array[0..15] of char='0123456789ABCDEF';
  begin
    hexb:=hexziffern[b div 16]+hexziffern[b mod 16];
  end;

function hexl(l:longint):string;
  begin
    hexl:=hexb((l shr (3*8)) and $ff)
         +hexb((l shr (2*8)) and $ff)
         +hexb((l shr (1*8)) and $ff)
         +hexb((l shr (0*8)) and $ff);
  end;

begin
  setze_sprachzeiger(@sprach_modul,@sprach_start);

  if paramcount<>4 then
    begin
      writeln(textz_benutzung^+paramstr(0)+textz_benutzung_1b^);
      writeln(textz_benutzung_2^);
      writeln(textz_benutzung^+paramstr(0)+textz_benutzung_3b^);
      writeln;
      writeln(textz_benutzung_4^);
      writeln(textz_benutzung_5^);
      writeln;
      writeln(textz_benutzung_6^);
      halt(1);
    end;

  filemode:=$40;
  assign(d1 ,paramstr(1));
  assign(d2 ,paramstr(2));
  assign(crk,paramstr(3));

  crk_pat_unbekannt:=ziel_unbekannt;
  posi_text:=copy(paramstr(3)+'.XYZ',length(paramstr(3))-(1+3)+1,1+3);
  posi_text[2]:=upcase(posi_text[2]);
  posi_text[3]:=upcase(posi_text[3]);
  posi_text[4]:=upcase(posi_text[4]);
  if posi_text='.CRK' then crk_pat_unbekannt:=ziel_crk;
  if posi_text='.PAT' then crk_pat_unbekannt:=ziel_pat;

  if crk_pat_unbekannt=ziel_unbekannt then
    begin
      writeln(textz_Im_Dateinamen^+paramstr(3)+textz_Crk_oder_Pat_erwartet^);
      halt(2);
    end;

  dateiname_in_patchdatei:=paramstr(4);

  (*$I-*)
  reset(d1,1);
  (*$I+*)
  if ioresult<>0 then
    begin
      writeln(textz_kann_Datei_nicht_oeffnen_1^+paramstr(1)+textz_kann_Datei_nicht_oeffnen_2^);
      halt(3);
    end;

  (*$I-*)
  reset(d2,1);
  (*$I+*)
  if ioresult<>0 then
    begin
      writeln(textz_kann_Datei_nicht_oeffnen_1^+paramstr(2)+textz_kann_Datei_nicht_oeffnen_2^);
      halt(4);
    end;

  (*$I-*)
  append(crk);
  (*$I+*)
  if ioresult<>0 then
    begin
      (*$I-*)
      rewrite(crk);
      (*$I+*)
      if ioresult<>0 then
        begin
          writeln(textz_kann_Datei_nicht_erzeugen_1^+paramstr(3)+textz_kann_Datei_nicht_erzeugen_2^);
          halt(5);
        end;

      if crk_pat_unbekannt=ziel_crk then
        writeln(crk,textz_Titeltext^,' [',paramstr(3),']');

    end;


  lesen:=0;
  datei_laenge:=filesize(d1);
  if datei_laenge>filesize(d2) then
    datei_laenge:=filesize(d2);

  if crk_pat_unbekannt=ziel_crk then
    begin
      writeln(crk);
      writeln(crk,textz_Blocktext^);
      writeln(crk,dateiname_in_patchdatei);
    end
  else
    begin
      writeln(crk,'; D1D2CRK/V.K.');
      writeln(crk,'; ',paramstr(1),' -> ',paramstr(2));
      writeln(crk,'FILE ',dateiname_in_patchdatei);
    end;

  repeat
    block:=datei_laenge-lesen;
    if block>512 then
      block:=512;

    if block=0 then break;

    blockread(d1,p1,block,l1);
    blockread(d2,p2,block,l2);

    for zaehler:=1 to l1 do
      if p1[zaehler]<>p2[zaehler] then
        begin
          posi_text:=hexl(lesen+zaehler-1);
          if crk_pat_unbekannt=ziel_crk then
            writeln(crk,posi_text+': '+hexb(p1[zaehler])+' '+hexb(p2[zaehler]))
          else
            writeln(crk,'VER '+posi_text+' '+hexb(p1[zaehler]));
        end;
    inc(lesen,l1);
  until false;

  if crk_pat_unbekannt=ziel_pat then
    begin
      lesen:=0;
      seek(d1,0);
      seek(d2,0);

      repeat
        block:=datei_laenge-lesen;
        if block>512 then
          block:=512;

        if block=0 then break;

        blockread(d1,p1,block,l1);
        blockread(d2,p2,block,l2);

        for zaehler:=1 to l1 do
          if p1[zaehler]<>p2[zaehler] then
            begin
              posi_text:=hexl(lesen+zaehler-1);
              writeln(crk,'CHA '+posi_text+' '+hexb(p2[zaehler]));
            end;
        inc(lesen,l1);
      until false;

    end;


  close(d1);
  close(d2);
  close(crk);
end.
