# README

## About

Program with GUI for work with files: find unique, duplicates, calck and check hashes. Licensed under GPL v2.

## Motivation

No many programs for find duplicates files, and and even fewer programs to find unique files or automatically check hashes from multiple files. I fixed it:).

## Features
-  support many hash functions (MD5, SHA1, SHA256, SHA512, SHA3 256, SHA3 512)
-  work with many folders
-  find duplicates files and remove
-  find unique files in folders
-  calc hashes for files
-  check hashes for files
-  find empty folders and remove
-  Check zip files, show files. It shows files that can not be opened, or hash sum does not correspond to the content.

In Windows 10 start with admin rights, if you want to remove some things.

## Technology
-  Qt 5 with QThreads, signals and slots, QTableWidget, QComboBox Widget, QListWidget.
-  Qt Creator
-  c++ with some features from c++11
-  qt-opensource-windows-x86-mingw530-5.7.0

## Licences:
-  DirWizard under GNU GPL version 2  
-  QuaZIP under GNU Lesser General Public License version 2.1   
-  zlib under zlib License and compatible with GNU GPL

## Class Hierarchy

QMainWindow -> MainWindow
QObject -> DirWalker -> HashDirWalker
                |           |
                |           |->DirComparator
                |           |->DuplicateFinder
                |           |->CalcAndSaveHash
                |           |->LoadAndCheckHash
                |
                |-----> ZipWalkChecker
                |-----> EmptyDirFinder

QAbstractTableModel -> BaseTableModel -> DuplicatesTableModel
                            |
                            |----------> FileListTableModel
                            |----------> EmptyFolderTableModel

QDialog -> FiltersDialog

