SYSLOGD(8)               UNIX System Manager's Manual               SYSLOGD(8)

NAME
     syslogd - log systems messages

SYNOPSIS
     syslogd [-d] [-f config_file] [-i pid_file] [-m mark_interval]
            [-n num_logs] [-p log_socket] [-s size_log]

DESCRIPTION
     Syslogd reads and logs messages to the system console, log files, other
     machines and/or users as specified by its configuration file.  The op-
     tions are as follows:

     -d      Switches on debug output.

     -f      Specify the pathname of an alternate configuration file; the de-
             fault is /etc/syslog.conf.

     -i      Specify the pathname of an alternate pid file; the de-
             fault is /var/run/syslog.pid.

     -m      Select the number of minutes between ``mark'' messages; the de-
             fault is 20 minutes.

     -n      Specify the number of each type of old logfiles
             to keep; the default is 9.

     -p      Specify the pathname of an socket name; the de-
             fault is \socket\syslog.

     -s      Specify the maximum size in bytes of a logfile;
             the default is 100000.

     Syslogd reads its configuration file when it starts up and whenever it
     receives an INTR signal.  For information on the format of the configu-
     ration file, see syslog.conf(5).

     Syslogd reads messages from an UNIX domain socket named \socket\syslog.

     Syslogd creates the file /var/run/syslog.pid, and stores its process id
     there.  This can be used to kill or reconfigure syslogd.

     The message sent to syslogd should consist of a single line.  The message
     can contain a priority code, which should be a preceding decimal number
     in angle braces, for example, `<5.>' This priority code should map into
     the priorities defined in the include file <sys/syslog.h>. Syslogd adds
     a timestamp to received messages before writing them to the log.

FILES
     /etc/syslog.conf    The configuration file.
     /var/run/syslog.pid The process id of current syslogd.

SEE ALSO
     logger(1),  syslog(3), syslog.conf(5)

HISTORY
     The syslogd command appeared in 4.3BSD.

4.2 Berkeley Distribution       March 16, 1991                               1
