#include <dnpap.h>
#include <log.h>
#include <stdlib.h>

#include "event_d.h"
#include "event_c.h"


static CHAR MODULE[] = "EventC";


BOOLEAN EventCInit(RmonEvent* event)
{
	event->Description[0] = '\0';
    event->DescrLen = 0;
	event->Type = EVENT_NONE;
	event->Community[0] = '\0';
    event->CommLen = 0;
	event->LastTimeSent = 0;
	event->Owner[0] = '\0';
	event->OwnerLen = 0;
	event->Status = SNMP_INVALID;
	
	event->NrLogs = 0;
	event->LogPos = 0;
	event->LogIndex = 1;
	event->LogBounced = FALSE;
	event->Logs = NULL;
	
    return TRUE;
}


BOOLEAN EventCStart(RmonEvent* event)
{
    return TRUE;
}


BOOLEAN EventCStop(RmonEvent* event)
{
	DelRmonLog(event->Logs);
	
    return TRUE;
}


RmonEvent* NewRmonEvent(WORD nrevents)
{
    return DnpapMalloc(nrevents*sizeof(RmonEvent));
}


RmonEvent* ReNewRmonEvent(RmonEvent* ptr, WORD nrevents)
{
    return DnpapRealloc(ptr, nrevents*sizeof(RmonEvent));
}


VOID DelRmonEvent(RmonEvent* ptr)
{
    DnpapFree(ptr);
}

