#ifndef _FILTERC_H
#define _FILTERC_H

#include <dnpap.h>
#include <snmp.h>


typedef struct _FILTER
{
    LONG    Channel;
    LONG    PktDataOffset;
    BYTE*   PktData;
    BOOLEAN PktDataBytes;
    BYTE*   PktDataMask;
    BOOLEAN PktDataMaskBytes;
    BYTE*   PktDataNotMask;
    BOOLEAN PktDataNotMaskBytes;
    BOOLEAN PktDataNotMaskAllZero;
    WORD    PktDataLen;
    WORD    PktDataMaskLen;
    WORD    PktDataNotMaskLen;
    LONG    PktStatus;
    LONG    PktStatusMask;
    LONG    PktStatusNotMask;
    BYTE    Owner[SNMP_SIZE_BUFCHR];
    WORD    OwnerLen;
    LONG    Status;

} FILTER;


BOOLEAN FilterCInit(FILTER *filter);
BOOLEAN FilterCStart(FILTER *filter);
BOOLEAN FilterCStop(FILTER *filter);


#endif
