#include <dnpap.h>
#include <mib.h>	   
#include <vipinc.h>
#include <timer.h>

#include "neuro_e.h"


				      
static CHAR MODULE[] =	"NeuroViewer";



static MIB_PROFIL prf = { MODULE, sizeof(MODULE) };
		       
enum { NO_MODE, SINGLE_NET, ALL_NETS };
static WORD NeuroVMode = NO_MODE;

static WORD NeuroVIndex = 0;
static VOID (*NeuroVExit)(unsigned index) = NULL;
		      		       
				
static ULONG NeuroVPrevTime = 0;
static ULONG NeuroVTimeBetween = 0;


static VOID NeuroVStop(VOID);
	       
static TIMER_DESCR *NeuroVTimer = NULL;
static TIMER_CALLBACK NeuroVCallback;
	       


VOID NeuroVStart(VOID (*StopCall)(unsigned Ind), unsigned Ind)
{
	NeuroVExit = StopCall;
	NeuroVIndex = Ind;
	
	switch (NeuroVMode)
	{
	case SINGLE_NET:
		break;
	case ALL_NETS: 
		break;
	}
	
	if (MibGetResp(&prf, &obj[OBJGETSTATUS]) != MIB_NOERROR)
	{
		ERROR(MODULE, NEURO_NOSTATUS);
		NeuroVStop();
		return;
	}      
	
	NeuroVPrevTime = TimerNow();
	VipShow(NeuroVFrame);
	return;
}

 
VOID NeuroVStop(VOID)
{		
	TimerRemove(NeuroVTimer);
	VipDestroy(NeuroVFrame);
	NeuroVExit(NeuroVIndex);
	
	return;
}


VOID NeuroVCallback(TIMER_DESCR *timer, ULONG now, VOID *param)
{			    
	NeuroVTimeBetween = now - NeuroVPrevTime;
	NeuroVPrevTime = now;	
	
	VipUpdate(NeuroVFrame, FALSE);
	return;
}
