/************************************************************************
** MODULE INFORMATION*
**********************
**     FILE     NAME:       dmatrixc.h
**     SYSTEM   NAME:       beholder
**     ORIGINAL AUTHOR(S):  Nitin Ramlal
**     VERSION  NUMBER:     0.99
**     CREATION DATE:       1992/9/29
**
** DESCRIPTION: matrix group of the RMON MIB: include file
**              
*************************************************************************
** CHANGES INFORMATION **
*************************
** REVISION:    $Revision$
** WORKFILE:    $Workfile$
** LOGINFO:     $Log$
*************************************************************************/


#ifndef _DMATRIX_C_H
#define _DMATRIX_C_H


#include <dnpap.h>
#include <snmp.h>

#include "hash.h"


typedef struct _HostInfo
{                     
    BYTE   ConnAddr[HOST_SZEADDR];
    ULONG  TotalPkts;
    ULONG  Octets;
    LWORD  Errors;
    struct _HostInfo *LexNextList;
    struct _HostInfo *LexPrevList;
    struct _HostInfo *TopNextList;
    struct _HostInfo *TopPrevList;

} HostInfo;

typedef struct _SOURCE
{
    BYTE            SourceAddr[HOST_SZEADDR];
    BYTE            NumberConnect;
    HostInfo      *Info;
    HostInfo      *LastDest;
    struct _SOURCE  *NextSource;


} SOURCE;



typedef struct _DEST
{
    BYTE          DestAddr[HOST_SZEADDR];
    BYTE          NumberConnect;
    HostInfo      *Info;
    HostInfo      *LastSource;
    struct _DEST  *NextDest;


} DEST;






typedef struct _SRCDST
{
    BYTE        SrcDst[2*HOST_SZEADDR];
    LWORD       Pkts;
    LWORD       Octets;
    LWORD       Errors;

    struct _SRCDST  *SrcDstPrev;
    struct _SRCDST  *SrcDstNext;
    
    struct _SRCDST  *DstSrcPrev;
    struct _SRCDST  *DstSrcNext;

    struct _SRCDST  *LRUPrev;
    struct _SRCDST  *LRUNext;
    
} SRCDST;


typedef struct _MATRIX_CONTROL
{
    LONG            Source[SNMP_SIZE_BUFINT];
    WORD            SourceLen;
    LONG            TableSize;
    ULONG           LastDeleteTime;
    BYTE            Owner[SNMP_SIZE_BUFCHR];
    WORD            OwnerLen;
    LONG            Status;
    
    MAC_COLL        Coll;
    MAC_IFACE       *Iface;
    
	HashTable		*Table;
	
	SRCDST			*SrcDstList;
	SRCDST			*DstSrcList;

    SRCDST          *LRUList;
    SRCDST          *LRULast;

    SOURCE          *SourceList;
    DEST            *DestList;
    
} MATRIX_CONTROL;





BOOLEAN MatrixConfigInit(VOID);

BOOLEAN MatrixCInit(MATRIX_CONTROL *matrixcontrol);
BOOLEAN MatrixCStart(MATRIX_CONTROL *matrixcontrol);
BOOLEAN MatrixCStop(MATRIX_CONTROL *matrixcontrol);

SRCDST* MatrixHashSearch(MATRIX_CONTROL *matrixcontrol, BYTE *srcdst, WORD len, BOOLEAN SDorder);
SRCDST* MatrixHashSearch2(MATRIX_CONTROL *matrixcontrol, SNMP_OBJECT *obj, WORD idlen, BOOLEAN SDorder);


HostInfo* SourceDestHashSearch(MATRIX_CONTROL *matrixcontrol,SNMP_OBJECT *obj, WORD len, BOOLEAN SDorder);
HostInfo* DestSourceHashSearch(MATRIX_CONTROL *matrixcontrol,SNMP_OBJECT *obj, WORD len, BOOLEAN SDorder);
HostInfo* SourceDestHashSearch2(MATRIX_CONTROL *matrixcontrol, SNMP_OBJECT *obj, WORD idlen,BOOLEAN SDorder);
HostInfo* DestSourceHashSearch2(MATRIX_CONTROL *matrixcontrol, SNMP_OBJECT *obj, WORD idlen,BOOLEAN SDorder);

HostInfo* SourceDestTopSearch(MATRIX_CONTROL *matrixcontrol,SNMP_OBJECT *obj,WORD idlen);
HostInfo* DestSourceTopSearch(MATRIX_CONTROL *matrixcontrol,SNMP_OBJECT *obj,WORD idlen);


#endif

