#ifndef _IP_ROUTE_H_
#define _IP_ROUTE_H_

#include <dnpap.h>
#include <chain.h>
#include <mac.h>
#include <arp.h>


#define IP_ROUTE_TYPE_OTHER    1
#define IP_ROUTE_TYPE_INVALID  2
#define IP_ROUTE_TYPE_DIRECT   3
#define IP_ROUTE_TYPE_REMOTE   4

#define IP_ROUTE_PROTO_OTHER   1
#define IP_ROUTE_PROTO_LOCAL   2
#define IP_ROUTE_PROTO_MGMT    3
#define IP_ROUTE_PROTO_ICMP    4
#define IP_ROUTE_PROTO_EGP     5
#define IP_ROUTE_PROTO_GGP     6


typedef struct _IP_ROUTE_ENTRY      IP_ROUTE_ENTRY;
typedef struct _IP_ROUTE_ROUTE      IP_ROUTE_ROUTE;


struct _IP_ROUTE_ENTRY
{
    IP_IFACE        *iface;
    DWORD           addr;
    DWORD           addrNextHop;
    DWORD           mask;
    WORD            metric;
    WORD            routingProto;
    WORD            type;
    IP_ROUTE_ENTRY  *next;
};
 

struct _IP_ROUTE_ROUTE
{
    IP_IFACE    *iface;
    DWORD       addr;
    WORD        metric;
    BOOLEAN     broadcast;
};


extern IP_ROUTE_ENTRY *ipRouteList;


BOOLEAN IpRouteIsBroadcast(DWORD addr);
BOOLEAN IpRouteFind(DWORD addr, IP_ROUTE_ROUTE *route);



#endif
