#include <stdio.h>
#include <memory.h>
#include "snordef.h"
#include "snorsem.h"
#include "snordev.h"
#include "snorhdl.h"
#include "snorsub.h"
#include "snorerr.h"
#include "snorrqs.h"


USHORT SnorRqsConfig(SNOR_DESCR *snor)
{
    int	            ret = 0;
	USHORT          i;
	PUCHAR	        p;


    if (snor->tabs.cct == 0)
    {
	    i = sizeof(CCT) + sizeof(MSSC) + sizeof(MSSS) + 100;
	    snor->tabs.cct = SnorSubMalloc(snor, i);
        if (snor->tabs.cct == 0)
            return 2;
    }

    p = (PUCHAR)(snor->tabs.cct);
	if ( SnorDevCall(snor->device, p, NULL, NEUS_GET_CONFIG) == 0 )
	{
		p += *(PUSHORT)p;
		snor->tabs.mssc = (MSSC far *)p;
		p += *(PUSHORT)p;
		snor->tabs.msss = (MSSS far *)p;
	}
	else
		ret = 1;
	return(ret);
}


USHORT SnorRqsGive(SNOR_DESCR *snor)
{
	USHORT  ret = 0;
	USHORT	i;
    HSEM    hsem;
    BYTE    name[16];
    static  USHORT  index = 0;


    i = sizeof(TXSEG) + (snor->selCount-4)*2;
	if ( (snor->tx=SnorSubMalloc(snor,i)) == NULL )
    {
        SnorErrPrint("SnorRqsGive: SnorSubMalloc failed");
		return 2;
    }

	sprintf(name,"\\sem\\snor%d",index++);
    ret = DosCreateSem(CSEM_PUBLIC, &hsem, name);
    if (ret != 0)
    {
        SnorErrPrint("SnorRqsGive: DosCreateSem failed %d", ret);
		return 3;
    }

    snor->tx->hsemRing3=hsem;
    snor->tx->hsemRing0=hsem;
	snor->tx->semRecsAvail = 0L;
    snor->tx->usRecsAvail = 0;
	snor->tx->usTxSize = 0;
	snor->tx->usRcvSegCnt = snor->selCount-1;
	memcpy(snor->tx->awRcvSels, snor->sel+1,
			(snor->selCount-1)*sizeof(SEL));

	if ( SnorSemSet(snor) != 0)
    {
        SnorErrPrint("SnorRqsGive: SnorSemSet failed");
		return 4;
    }
	
    if ( SnorDevCall(snor->device, snor->tx, NULL, NEUS_GIVE) != 0 )
    {
        SnorErrPrint("SnorRqsGive: SnorDevCall failed");
		return 5;
    }

	return ret;
}
                       

USHORT	SnorRqsMotor(SNOR_DESCR *snor)
{
	return( SnorDevCall(snor->device, 0L, 0L, NEUS_MOTOR) );
}


USHORT	SnorRqsResetMAC(SNOR_DESCR *snor)
{
	USHORT	ret;
	SNOR_MH	*msg;
	int	handle;
	IOCPARM	parm;

	if ( (handle=SnorHdlMalloc(snor)) < 0 )
	{
		SnorErrPrint("Handle allocation failed in RequestResetMAC");
		return(0xffff);
	}
	msg = SnorHdl2Ptr(snor, handle);
	msg->usMem1 = ResetMAC;

	parm.usSub = ResetMAC;
	parm.usHandle = (USHORT) handle;
	parm.usDatLen = 0;
	parm.usParam1 = 0;
	parm.ulParam2 = 0L;

	if ( (ret=SnorDevCall(snor->device, 0L, &parm, NEUS_GENREQ)) != 0 )
	{
		SnorHdlFree(snor, handle);
	}
	return( ret );
}








USHORT	SnorRqsCloseAdapter(SNOR_DESCR *snor)
{
	USHORT	ret;
	SNOR_MH	*msg;
	int	handle;
	IOCPARM	parm;

	if ( (handle=SnorHdlMalloc(snor)) < 0 )
	{
		SnorErrPrint("Handle allocation failed in RequestCloseAdapter");
		return(0xffff);
	}
	msg = SnorHdl2Ptr(snor, handle);
	msg->usMem1 = CloseAdapter;

	parm.usSub = CloseAdapter;
	parm.usHandle = (USHORT) handle;
	parm.usDatLen = 0;
	parm.usParam1 = 0;
	parm.ulParam2 = 0L;

	if ( (ret=SnorDevCall(snor->device, 0L, &parm, NEUS_GENREQ)) != 0 )
	{
		SnorHdlFree(snor, handle);
	}
	return( ret );
}

USHORT	SnorRqsOpenAdapter(SNOR_DESCR *snor, USHORT options)
{
	USHORT	ret;
	SNOR_MH	*msg;
	int	handle;
	IOCPARM	parm;

	if ( (handle=SnorHdlMalloc(snor)) < 0 )
	{
		SnorErrPrint("Handle allocation failed in RequestOpenAdapter");
		return(0xffff);
	}
	msg = SnorHdl2Ptr(snor, handle);
	msg->usMem1 = OpenAdapter;

	parm.usSub = OpenAdapter;
	parm.usHandle = (USHORT) handle;
	parm.usDatLen = 0;
	parm.usParam1 = options;
	parm.ulParam2 = 0L;

	if ( (ret=SnorDevCall(snor->device, 0L, &parm, NEUS_GENREQ)) != 0 )
	{
		SnorHdlFree(snor, handle);
	}
	return( ret );
}


USHORT	SnorRqsSetPacketFilter(SNOR_DESCR *snor, USHORT mask)
{
	USHORT	ret;
	SNOR_MH	*msg;
	int	handle;
	IOCPARM	parm;

	if ( (handle=SnorHdlMalloc(snor)) < 0 )
	{
		SnorErrPrint("Handle allocation failed in RequestSetPacketFilter");
		return(0xffff);
	}
	msg = SnorHdl2Ptr(snor, handle);
	msg->usMem1 = SetPacketFilter;

	parm.usSub = SetPacketFilter;
	parm.usHandle = (USHORT) handle;
	parm.usDatLen = 0;
	parm.usParam1 = mask;
	parm.ulParam2 = 0L;

	if ( (ret=SnorDevCall(snor->device, 0L, &parm, NEUS_GENREQ)) != 0 )
	{
		SnorHdlFree(snor, handle);
	}
	return( ret );
}



USHORT	SnorRqsSend(SNOR_DESCR *snor, PUCHAR frame, USHORT length)
{
	USHORT	ret;
	SNOR_MH	*msg;
	int	handle;
	IOCPARM	parm;

	if ( (handle=SnorHdlMalloc(snor)) < 0 )
	{
		SnorErrPrint("Handle allocation failed in RequestSend");
		return(0xffff);
	}
	msg = SnorHdl2Ptr(snor, handle);
	msg->ulMem3 = (ULONG)frame;

	parm.usSub = 0;
	parm.usHandle = (USHORT) handle;
	parm.usDatLen = length;
	parm.usParam1 = 0;
	parm.ulParam2 = 0L;

	if ( (ret=SnorDevCall(snor->device, frame, &parm, NEUS_SEND)) != 0 )
	{
		SnorHdlFree(snor, handle);
	}

	return( ret );
}


VOID SnorRqsFreeSend(SNOR_DESCR *snor, int handle)
{
	SNOR_MH	*msg;

	msg = SnorHdl2Ptr(snor, handle);
	
	SnorSubFree(snor, (PUCHAR)(msg->ulMem3));
	SnorHdlFree(snor, handle);
}




VOID SnorRqsFreeGeneral(SNOR_DESCR *snor, int handle)
{
	SNOR_MH	*msg;

	msg = SnorHdl2Ptr(snor, handle);
	
    switch ( msg->usMem1 )
	{
		case SetFunctionalAddress:
			SnorSubFree(snor, (PUCHAR)msg->ulMem3);
			break;
		case InitiateDiagnostics:
		case ReadErrorLog:
		case SetStationAddress:
		case OpenAdapter:
		case CloseAdapter:
		case ResetMAC:
		case SetPacketFilter:
		case AddMulticastAddress:
		case DeleteMulticastAddress:
		case UpdateStatistics:
		case ClearStatistics:
		case Interrupt:
		case SetLookahead:
			break;
	}

	SnorHdlFree(snor, handle);
}






USHORT SnorRqsTime(SNOR_DESCR *snor, ULONG *t)
{
	USHORT	ret;
	IOCPARM	parm;


	ret=SnorDevCall(snor->device, 0L, &parm, NEUS_HIGHRES_TIME);

    *t=parm.ulParam2;
       
	return( ret );
}





