include gcc_os2.std

SYS     = dnpap
SYSLIB  = dnpap

OBJ = dnpap.o

all: obj doc


install: $(INCDIR)/gcc_os2.std $(INCDIR)/$(SYS).h $(MANDIR)/$(SYS).man $(LIBDIR)/lib$(SYSLIB).a 

$(INCDIR)/gcc_os2.std: gcc_os2.std
	$(CP) gcc_os2.std $(INCDIR)/gcc_os2.std

$(INCDIR)/$(SYS).h: $(SYS).h 
	$(CP) $(SYS).h $(INCDIR)/$(SYS).h

$(MANDIR)/$(SYS).man: $(SYS).man 
	$(CP) $(SYS).man $(MANDIR)/$(SYS).man 

$(LIBDIR)/lib$(SYSLIB).a: $(OBJ) 
	$(AR) $(LIBDIR)/lib$(SYSLIB).a $(OBJ) 

obj: $(OBJ)
       
doc: $(SYS).man

clean:
	- $(RM) *.o
	- $(RM) *.a
	- $(RM) *.exe
	- $(RM) core
	- $(RM) test
	- $(RM) *.man
	- $(RM) *.err
	- $(RM) *.bak

$(SYS).man: dnpap.c
	$(MAN) dnpap.c > $(SYS).man

dnpap.o: dnpap.c $(SYS).h


test.exe: test
	emxbind -bs test

test: test.o $(INC)
	$(LN) $(CFLAGS) -o test test.o $(OBJ) $(LDFLAGS) -ldnpap
