!include standard.mak

SYS     = dnpap
SYSLIB  = dnpap

all: obj doc

install: all $(INCDIR)\standard.mak $(INCDIR)\$(SYS).h $(MANDIR)\$(SYS).man $(LIBDIR)\$(SYSLIB).lib

$(INCDIR)\standard.mak: standard.mak
	$(CP) standard.mak $(INCDIR)\standard.mak

$(INCDIR)\$(SYS).h: $(SYS).h 
	$(CP) $(SYS).h $(INCDIR)\$(SYS).h

$(MANDIR)\$(SYS).man: $(SYS).man 
	$(CP) $(SYS).man $(MANDIR)\$(SYS).man 

$(LIBDIR)\$(SYSLIB).lib: $(SYS).obj 
	$(AR) $(LIBDIR)\$(SYSLIB).lib -+$(SYS).obj;

obj: $(SYS).obj

doc: $(SYS).man

clean:
    - $(RM) *.exe
    - $(RM) *.obj
    - $(RM) *.i
    - $(RM) *.lib
    - $(RM) *.man
    - $(RM) *.err
    - $(RM) *.bak

$(SYS).man: 
    $(MAN) $(SYS).c > $(SYS).man

$(SYS).obj: $(SYS).c $(SYS).h

test.exe: test.obj $(SYS).obj $(SYS).h
	$(LINK) test.obj $(SYS).obj
    markexe windowcompat test.exe
