/**********************************************************************
** MODULE INFORMATION*
**********************
**      FILE     NAME:       msgfile.c
**      SYSTEM   NAME:       FileDevice
**      ORIGINAL AUTHOR(S):  Alfred Kayser
**      VERSION  NUMBER:     1.0
**      CREATION DATE:       91/09/16
**
** DESCRIPTION: FileDevice for transcripts
**              This module doesn't export any functions, but it
**              defines three TRANSDEVICE structures, which can be passed
**              to the TransInit and TransAddDevice functions.
** EXPORTS:     TRANSDEVICE *messageFileDev,
**                          *messageStdioDev,
**                          *messageVioDev,
**                          *messageNullDev;
***********************************************************************
** CHANGES INFORMATION **
*************************
** REVISION: $Revision:  $
** AUTHOR:   $Author:  $
** DATE:     $Date:  $
** LOG:      $Log: $
**
**********************************************************************/
#include <stdio.h>
#include <stdlib.h>
#include <dnpap.h>
#include <config.h>
#include "message.h"


PRIVAT void *FileDevOpen  __((const char *));
PRIVAT void *FileDevOpenStd __((const char *));
PRIVAT void  FileDevPut   __((void *, const char *));
PRIVAT void  FileDevFlush __((void *));
PRIVAT void  FileDevClose __((void *));

PRIVAT void *NullDevOpen  __((const char *));
PRIVAT void  NullDevPut   __((void *, const char *));
PRIVAT void  NullDevFlush __((void *));
PRIVAT void  NullDevClose __((void *));


EXPORT TRANSDEVICE messageFileDev = { "FILE", FileDevOpen, FileDevPut, FileDevFlush, FileDevClose };
EXPORT TRANSDEVICE messageStdioDev = { "STDIO", FileDevOpenStd, FileDevPut, FileDevFlush, FileDevClose };
EXPORT TRANSDEVICE messageNullDev = { "NULL", NullDevOpen, NullDevPut, NullDevFlush, NullDevClose };


/*--------------------- Private Parts ----------------------------*/
/**************************************************************
** NAME:        FileDevOpen
** SYNOPSIS:    PRIVAT void *
**              FileDevOpen(CONST char *name)
** DESCRIPTION: Opens a filedevice and returns the filepointer.
** RETURNS:     file pointer.
**************************************************************/
PRIVAT void *
FileDevOpen(CONST char *name)
{
    return fopen(name,"w");
}


/**************************************************************
** NAME:        FileDevOpenStd
** SYNOPSIS:    PRIVAT void *
**              FileDevOpenStd(CONST char *name)
** DESCRIPTION: Returns the handle of stdout or stderr.
**              Stdout when the first letter of name is 'o'
**              or 'O', stderr when the letter is 'e' or 'E'.
** RETURNS:     Handle to std<out/err>.
**************************************************************/
PRIVAT void *
FileDevOpenStd(CONST char *name)
{                  
    /* Name should begin with 'E' or 'O' */
    switch(name[0])
    {
    case 'E':
    case 'e':return stderr;
    case 'O':       
    case 'o':return stdout;
    default: return NULL;
    }
}


/**************************************************************
** NAME:        FileDevPut
** SYNOPSIS:    PRIVAT void 
**              FileDevPut(void *fp, CONST char *str)
** DESCRIPTION: Puts the string in the filedevice.
** RETURNS:     void
**************************************************************/
PRIVAT void 
FileDevPut(void *fp, CONST char *str)
{                   
    FILE *a=(FILE*)fp;
    fputs(str,a);
}


/**************************************************************
** NAME:        FileDevFlush
** SYNOPSIS:    PRIVAT void
**              FileDevFlush(void *fp)
** DESCRIPTION: Flushes the filedevice.
** RETURNS:     void
**************************************************************/
PRIVAT void
FileDevFlush(void *fp)
{
    fflush((FILE*)fp);
}


/**************************************************************
** NAME:        FileDevClose
** SYNOPSIS:    PRIVAT void
**              FileDevClose(void *fp)
** DESCRIPTION: Closes the filedevice.
** RETURNS:     void
**************************************************************/
PRIVAT void
FileDevClose(void *fp)
{
    fclose((FILE*)fp);
}


PRIVAT void * NullDevOpen(CONST char *name) { return (void*)name; }
PRIVAT void   NullDevPut(void *fp, CONST char *str) { }
PRIVAT void   NullDevFlush(void *fp) { }
PRIVAT void   NullDevClose(void *fp) { }




