include ../../include/gcc_os2.std

SYS     = timer
SYSLIB  = dnpap

OBJ = timer.o 

all: obj doc

install: all $(INCDIR)/$(SYS).h $(MANDIR)/$(SYS).man $(LIBDIR)/lib$(SYSLIB).a 

$(INCDIR)/$(SYS).h: $(SYS).h 
	$(CP) $(SYS).h $(INCDIR)/$(SYS).h

$(MANDIR)/$(SYS).man: $(SYS).man 
	$(CP) $(SYS).man $(MANDIR)/$(SYS).man 

$(LIBDIR)/lib$(SYSLIB).a: $(OBJ) 
	$(AR) $(LIBDIR)/lib$(SYSLIB).a $(OBJ) 

obj: $(OBJ)
       
doc: $(SYS).man

clean:
	- $(RM) *.o
	- $(RM) *.a
	- $(RM) *.exe
	- $(RM) core
	- $(RM) test
	- $(RM) *.man
	- $(RM) *.err
	- $(RM) *.bak

$(SYS).man: timer.c
	$(MAN) timer.c > $(SYS).man

timer.o: timer.c $(SYS).h


test.exe: test
	emxbind -bs test

test: test.o $(INC)
	$(LN) $(CFLAGS) -o test test.o $(OBJ) $(LDFLAGS)
