#include <string.h>
#include <memory.h>
#include "snmp.h"

void main(void)
{
    SNMP_PDU        pdu;
    SNMP_OBJECT      list[1];
    unsigned        listLen;
    BYTE            com[16];
    unsigned        comLen;
    BYTE            *rqsBuffer, *rqs;
    unsigned        rqsLen;
    BOOLEAN         success;
    ULONG           id[]={1,3,6,1,2,1,1,1,0};


    success = FALSE;
    
    pdu.Type = SNMP_PDU_GET;
    pdu.Request.ErrorStatus = SNMP_NOSUCHNAME;
    pdu.Request.ErrorIndex = 1;
    pdu.Request.Id = 93;

    memcpy(list[0].Id,id,sizeof(id));
    list[0].IdLen=sizeof(id)/sizeof(id[0]);
    list[0].Type=SNMP_OCTETSTR;
    strcpy(list[0].Syntax.BufChr,"Dit is een test.");
    list[0].SyntaxLen=16;


    rqsBuffer = DnpapMalloc(1024);

    rqs     = rqsBuffer;
    rqsLen  = 1024;

    success = SnmpEnc(  &rqs,
                        &rqsLen,
                        &pdu,
                        "public",
                        6,
                        list,
                        1);

    success = SnmpDec(  rqs,
                        rqsLen,
                        &pdu,
                        com,
                        sizeof(com),
                        &comLen,
                        list,
                        1,
                        &listLen);


    DnpapFree(rqsBuffer);
}

