#define MAXTABS 16

#define VID_TEXT      0
#define VID_PUSH      1
#define VID_DIAL      2
#define VID_GRAPH     3
#define VID_FRAME     4
#define VID_SCROLL    5

#define T_SIMPLE    0
#define T_TEXT      (2<<VID_TEXT)
#define T_PUSH      (2<<VID_PUSH)
#define T_DIAL      (2<<VID_DIAL)
#define T_GRAPH     (2<<VID_GRAPH)
#define T_FRAME     (2<<VID_FRAME)
#define T_SCROLL    (2<<VID_SCROLL)

#define VIP_WCFORE  0       /* Normal foreground */
#define VIP_WCFOR2  1       /* Special foreground */
#define VIP_WCBACK  2       /* Normal background */
#define VIP_WCBCK2  3       /* Special background */
#define VIP_WCSDW1  4       /* Shadow 1 (the light one) */
#define VIP_WCSDW2  5       /* Shadow 2 (the dark one) */
#define VIP_WCRED   6       /* Special color, attention color */
#define VIP_WCCLRS  7       /* Nr of colors */
#define FOREGROUND(w)  ((w)->colors[VIP_WCFORE])   
#define FOREGROUND2(w) ((w)->colors[VIP_WCFOR2])   
#define BACKGROUND(w)  ((w)->colors[VIP_WCBACK])   
#define BACKGROUND2(w) ((w)->colors[VIP_WCBCK2])   
#define SHADOW1(w)     ((w)->colors[VIP_WCSDW1])   
#define SHADOW2(w)     ((w)->colors[VIP_WCSDW2])   
#define RED(w)         ((w)->colors[VIP_WCRED])   

#define MENUFLAG(w,n,f) ((TEXTLINE(w,n).flags&VIP_MENUF)==(f))
#define TEXTFLAG(w,n,f) ((TEXTLINE(w,n).flags&VIP_TEXTF)==(f))
#define TEXTLINE(w,x)   (TEXTDATA(w,text)[x])

typedef struct _textline TXTLINE;
    struct _textline
    {
        char    *text;
        int      flags;
        LONG     fcol;
        LONG     bcol;
        VOID    *pointer;
    };

#define TEXTDATA(w,n) ((w)->textdata->n)
    struct _textdata
    {
        TXTLINE *text;
        int lines;
        int tsize;
        int offset;
        int flags;
        int mmouse;
        int lastOffset;
        int lastActive;
        POINTL start;
        POINTL origin;
        VIPINFO *submenu;
        VIPINFO *parmenu;
        VIPINFO *vertS;
        VIPINFO *horzS;
        int  tabs;
        SHORT *tabpos;
    };

#define DIALDATA(w,n) (w->dialdata->n)
    struct _dialdata
    {
        LONG min;
        LONG max;
        LONG current;
        LONG prev;
        SHORT stripes;
        VIPINFO *lab1;
        VIPINFO *lab2;
    };

#define GRAPHSET(w,x)  (GRAPHDATA(w,datasets)[x])
typedef struct _graphdataset GRAPHDSET;
    struct _graphdataset
    {
        LONG min;
        LONG max;
        LONG *values;
        int size;
        int offset;
        int last;
        char *legend;
        LONG color;
        VIPINFO *label;
    };

#define MAXSETS 16
#define GRAPHDATA(w,n) (w->graphdata->n)
    struct _graphdata
    {
        GRAPHDSET datasets[MAXSETS];
        int xstripes;
        int ystripes;
    };

#define SCROLLDATA(w,n) (w->scrolldata->n)
    struct _scrolldata
    {
        LONG min;
        LONG max;
        LONG range;
        LONG current;
        LONG size;
        LONG flags;
        RECTL b1, b2, b3;
        LONG action;
        VIPTIMER *timer;
    };

#define FRAMEDATA(w,n) (w->framedata->n)
    struct _framedata
    {
        LONG flags;
        VIPINFO *fix;
    };
