/* ----------------------------------------------------------------------
   cimon - a UNIX command line client for the fli4l imon daemon.
   
   Public domain, 2001-2002, Rene Herman <rene.herman@mail.com>
---------------------------------------------------------------------- */

#include <sys/types.h>                               /* EMX needs this */
#include <netdb.h>

#include "cimon.h"

/* Linux libc5 lacks hstrerror */
const char *herrorstr(int err)
{
    if (err < 0)
        return "Resolver internal error";

    switch (err) {
    case HOST_NOT_FOUND: return "Unknown host";
    case TRY_AGAIN:      return "Host name lookup failure";
    case NO_RECOVERY:    return "Unknown server error";
    case NO_ADDRESS:     return "No address associated with name";
    default:             return "Unknown resolver error";
    }
}
