/*
 *      INSTALL.CMD - V1.0 C.Langanke 2000 fr Team OS/2 Deutschland e.V.
 *
 *      Syntax: INSTALL
 *
 *      Dieses Programm installiert die OS/2 Interneteinwahl.
 */

 call RxFuncAdd    'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
 call SysLoadFuncs

 /* Vorgabewerte */
 '@ECHO OFF';
 env         = 'OS2ENVIRONMENT';
 Redirection = '>NUL 2>&1';
 AppName     = 'ibcos2';
 TmpDir      = VALUE('TMP',,env);
 EtcDir      = VALUE('ETC',,env);
 CallDir     = GetCallDir();
 IconDir     = CallDir'\ico';
 fIsWARP4    = (SysOS2Ver() > '2.30');


 /* Konfigurationsvariablen laden */
 CfgFile = 'provider.cfg';
 DO WHILE (LINES( CfgFile) > 0)
    ThisLine = LINEIN( CfgFile);
    PARSE VAR ThisLine VarKey'='VarValue;
    VarKey = STRIP( VarKey);
    VarValue = STRIP( VarValue);
    INTERPRET( VarKey'="'VarValue'"');

 END;
 rcx = STREAM( CfgFile, 'C', 'CLOSE');

 /* Variablen prfen */
 IF (ProviderId = '') THEN
 DO
    SAY 'Konfigurationsdatei' CfgFile 'nicht gefunden oder fehlerhaft !';
    EXIT(14);
 END;
 IcoDir       = CallDir'\'ProviderId;
 TargetPath   = EtcDir'\'AppName'\'Providerid;
 ObjectIdBase = '<IBCOS2_'ProviderId;

 /* deinstallieren */
 PARSE ARG Parm CallToken .;

 IF (Parm = 'REMOVE') THEN
 DO

    IF (ProceedWith( ProviderName 'Einwahl fr OS/2 deinstallieren')) THEN
    DO
       /* delete user information */
       'CALL' TargetPath'\bin\instdial DELUSER' ProviderId ProviderName;
       IF (rc \= 0) THEN
          EXIT(rc);

       /* delete WPS Objects */
       rc = SysDestroyObject( ObjectIdBase'_INSTALL_SETNOREGUSER>');
       rc = SysDestroyObject( ObjectIdBase'_INSTALL_SETREGUSER>');
       rc = SysDestroyObject( ObjectIdBase'_INSTALL_REMOVE>');
       rc = SysDestroyObject( ObjectIdBase'_INSTALL_FOLDER>');

       rc = SysDestroyObject( ObjectIdBase'_URL_PROVIDER>');
       rc = SysDestroyObject( ObjectIdBase'_URL_TEAMOS2>');
       rc = SysDestroyObject( ObjectIdBase'_URL_FOLDER>');

       rc = SysDestroyObject( ObjectIdBase'_README>');
       rc = SysDestroyObject( ObjectIdBase'_FINISHCONFIGURE>');
       rc = SysDestroyObject( ObjectIdBase'_DIALSLIPPM>');
       rc = SysDestroyObject( ObjectIdBase'_DIALISDNPM>');
       rc = SysDestroyObject( ObjectIdBase'_FOLDER>');

       /* delete files */
       rcx = DIRECTORY('\');
       rcx = DelTree( TargetPath);
       rcx = SysRmDir( EtcDir'\'AppName);
    END;
    EXIT(0);
 END;

 /* Dateien kopieren */
 '@XCOPY' CallDir'\*' TargetPath'\ /S' Redirection;

 /* Icons fr Odrner ermitteln */
 IF (fIsWarp4) THEN
    FolderIcons = 'ICONFILE='IcoDir'\folder4.ico;ICONNFILE=1,'IcoDir'\folder4o.ico;';
 ELSE
    FolderIcons = 'ICONFILE='IcoDir'\folder3.ico;ICONNFILE=1,'IcoDir'\folder3o.ico;';


 CALL CHAROUT, 'Erstelle Ordner fr' ProviderName 'Einwahl fr OS/2 ... ';
 rc = SysCreateObject( 'WPFolder',  ProviderName'^Einwahl fr OS/2',                                     '<WP_DESKTOP>',                  FolderIcons'ALWAYSSORT=YES;OBJECTID='ObjectIdBase'_FOLDER>;', 'U');

 rc = SysCreateObject( 'WPFolder',  'Einrichten/^Deinstallieren',                                        ObjectIdBase'_FOLDER>',              'ICONRESOURCE=90 PMWP;ICONNRESOURCE=1,91,PMWP;ALWAYSSORT=YES;OBJECTID='ObjectIdBase'_INSTALL_FOLDER>;', 'U');
 rc = SysCreateObject( 'WPProgram', ProviderName'^Einwahl fr OS/2^deinstallieren'             ,         ObjectIdBase'_INSTALL_FOLDER>',      'ICONFILE='IconDir'\remove.ico;PROGTYPE=WINDOWABLEVIO;MAXIMIZED=YES;EXENAME='TargetPath'\install.cmd;PARAMETERS=REMOVE;OBJECTID='ObjectIdBase'_INSTALL_REMOVE>;', 'U');
 rc = SysCreateObject( 'WPProgram', ProviderName 'Konfiguration fr^registrierten Benutzer setzen',       ObjectIdBase'_INSTALL_FOLDER>',      'ICONFILE='IconDir'\install.ico;PROGTYPE=WINDOWABLEVIO;MAXIMIZED=YES;EXENAME='TargetPath'\bin\instdial.cmd;PARAMETERS=REGUSER' ProviderId ProviderName';OBJECTID='ObjectIdBase'_INSTALL_SETREGUSER>;', 'U');
 rc = SysCreateObject( 'WPProgram', ProviderName 'Konfiguration fr^nicht registrierten Benutzer setzen', ObjectIdBase'_INSTALL_FOLDER>',      'ICONFILE='IconDir'\install.ico;PROGTYPE=WINDOWABLEVIO;MAXIMIZED=YES;EXENAME='TargetPath'\bin\instdial.cmd;PARAMETERS=NOREGUSER' ProviderId ProviderName';OBJECTID='ObjectIdBase'_INSTALL_SETNOREGUSER>;', 'U');
 rc = SysCreateObject( 'WPProgram', 'Konfiguration abschliessen',                                        ObjectIdBase'_INSTALL_FOLDER>',      'NOTVISIBLE=YES;EXENAME=VIEW.EXE;PARAMETERS='TargetPath'\inf\'ProviderId'.inf Konfiguration abschliessen;OBJECTID='ObjectIdBase'_FINISHCONFIGURE>;', 'U');

 rc = SysCreateObject( 'WPProgram', 'Hilfe zur' ProviderName'^Einwahl fr OS/2',                         ObjectIdBase'_FOLDER>',              'EXENAME=VIEW.EXE;PARAMETERS='TargetPath'\inf\'ProviderId'.inf' ProviderName';OBJECTID='ObjectIdBase'_README>;', 'U');
 rc = SysCreateObject( 'WPPRogram', ProviderName'^Analog-Modem Einwahl',                                 ObjectIdBase'_FOLDER>',              'PROGTYPE=PM;EXENAME=SLIPPM.EXE;PARAMETERS='ProviderId';OBJECTID='ObjectIdBase'_DIALSLIPPM>;', 'U');
 ISDNPM_ProgramFile = SysSearchPath( 'PATH', 'ISDNPM.EXE');
 IF (ISDNPM_ProgramFile \= '') THEN
    rc = SysCreateObject( 'WPPRogram', ProviderName'^ISDN^Einwahl',                                      ObjectIdBase'_FOLDER>',              'PROGTYPE=PM;EXENAME='ISDNPM_ProgramFile';OBJECTID='ObjectIdBase'_DIALISDNPM>;', 'U');

 /* create homepage URLs */
 IF (fIsWARP4) THEN
 DO
    rc = SysCreateObject( 'WPUrlFolder', 'Internet',                                                     ObjectIdBase'_FOLDER>',             'SHOWALLINTREEVIEW=YES;OBJECTID='ObjectIdBase'_URL_FOLDER>;', 'U');
    rc = SysCreateObject( 'WPUrl', ProviderName'^Internetseite',                                         ObjectIdBase'_URL_FOLDER>',         'ICONFILE='IcoDir'\'ProviderId'.ico;LOCATOR='ProviderUrl';OBJECTID='ObjectIdBase'_URL_PROVIDER>;', 'U');
    rc = SysCreateObject( 'WPUrl', 'Team OS/2 Deutschland e.V.^Internetseite',                           ObjectIdBase'_URL_FOLDER>',         'ICONFILE='IconDir'\teamos2.ico;LOCATOR='TeamUrl';OBJECTID='ObjectIdBase'_URL_TEAMOS2>;', 'U');
 END;
 ELSE IF (SysSearchPath( 'PATH', 'NETSCAPE.EXE') \= '') THEN
 DO
    rc = SysCreateObject( 'WPFolder', 'Internet',                                                        ObjectIdBase'_FOLDER>',             'OBJECTID='ObjectIdBase'_URL_FOLDER>;', 'U');
    rc = SysCreateObject( 'WPProgram', ProviderName'^Internetseite',                                     ObjectIdBase'_URL_FOLDER>',         'ICONFILE='IcoDir'\'ProviderId'.ico;EXENAME=NETSCAPE.EXE;PARAMETERS='ProviderUrl';OBJECTID='ObjectIdBase'_URL_PROVIDER>;', 'U');
    rc = SysCreateObject( 'WPProgram', 'Team OS/2 Deutschland e.V.^Internetseite',                       ObjectIdBase'_URL_FOLDER>',         'ICONFILE='IconDir'\teamos2.ico;EXENAME=NETSCAPE.EXE;PARAMETERS='TeamUrl';OBJECTID='ObjectIdBase'_URL_TEAMOS2>;', 'U');
 END;

 /* bring folder to the desktop */
 rc = SysOpenObject( ObjectIdBase'_FINISHCONFIGURE>', 'DEFAULT', 1);
 rc = SysOpenObject( ObjectIdBase'_FINISHCONFIGURE>', 'DEFAULT', 1);
 rc = SysOpenObject( ObjectIdBase'_FOLDER>', 'DEFAULT', 1);
 rc = SysOpenObject( ObjectIdBase'_FOLDER>', 'DEFAULT', 1);

 SAY 'Ok.';

 EXIT(0);

/* ------------------------------------------------------------------------- */
GetCalldir: PROCEDURE
PARSE SOURCE . . CallName
 CallDir = FILESPEC('Drive', CallName)||FILESPEC('Path', CallName);
 RETURN(LEFT(CallDir, LENGTH(CallDir) - 1));

/* ------------------------------------------------------------------------- */
ProceedWith: PROCEDURE
 PARSE ARG Prompt

 ResponseKeys  = 'J N A W I'; /* SysGetMessage(0); */
 Yes           = WORD(ResponseKeys, 1);
 No            = WORD(ResponseKeys, 2);
 ch            = ' ';
 ValidResponse = Yes||No;

 SAY;
 CALL CHAROUT ,Prompt '('Yes'/'No') '
 DO WHILE (POS(ch, ValidResponse) = 0)
    ch = SysGetKey('NOECHO');
    ch = TRANSLATE(ch);
    IF (POS(ch, ValidResponse) = 0) THEN BEEP(800, 200);
 END;
 SAY;
 SAY;
 RETURN(ch = Yes);

/* ========================================================================= */
DelTree: PROCEDURE
 PARSE ARG BaseDir;

 rc = SysFileTree( BaseDir'\*', 'File.', 'FOS',, '-----');
 IF (rc = 0) THEN
 DO i = File.0 TO 1 BY -1
    rcx = SysFileDelete( File.i);
 END;
 rc = SysFileTree( BaseDir'\*', 'Dir.', 'DOS');
 IF (rc = 0) THEN
 DO i = Dir.0 TO 1 BY -1
    rcx = SysRmDir( Dir.i);
 END;
 rcx = SysRmDir( BaseDir);

 RETURN(0);

