#	"Make" the c programs in this directory.
#	Copyright (c) 1989 by Hamilton Laboratories.  All rights reserved.
		
alias compile      cl -AS -G2 -Ox  # Microsoft C switches

# Just discard any wildcards that don't produce matches.
set nonomatch = 2

proc make(cfile)

	# make (i.e., recompile) a given .c file if
	#   a) there's no corresponding .exe, or
	#   b) the .exe is older than the .c file or any of the .h headers (if
	#      there are any).

	set root = $cfile:r
	if (! -e $root.exe || ! `newer $root.exe $i *.h`) then
		compile $cfile
		# mark .exe file as Presentation Manager window-compatible and
		# long filename-aware.
		markexe -tl $root.exe
		rm $root.obj
	end
end

foreach i (*.c)
	make $i
end
