Unit GlobRout;

Interface

USES CLASSES,FORMS,EXTCTRLS,graphics;

TYPE
 FILEDATAR=RECORD
   NAME : ARRAY[1..400] OF STRING[20];  //MAXIMUM LENGTH OF STRING IS 20 CHARACTERS
   NOSFOUND : INTEGER;
 END;

  //STANDARD MANIPULATION & CONVERSION ROUTINES
  FUNCTION SUBSTR(STRINGTOEDIT:STRING;START:INTEGER;LENGTH:INTEGER):STRING;
  FUNCTION NSUBWORD(D:STRING;S:CHAR;O,N:INTEGER):STRING;
  FUNCTION NWORDS(D:STRING;S:CHAR):INTEGER;
  FUNCTION SUBWORD(D:STRING;S:CHAR;O,N:INTEGER):STRING;
  FUNCTION TRANSLATE(DATA:STRING;OLD,NEW:CHAR):STRING;
  FUNCTION TOINT(STRTOCHANGE:STRING):LONGWORD ;
  FUNCTION BTOS(DATA:BOOLEAN):STRING;
  FUNCTION STOB(DATA:STRING[1]):BOOLEAN;

  //DIALOG CONTROL
  FUNCTION GETCOLORDLG(DATA:TCOLOR;FULLRANGE:BOOLEAN):TCOLOR;
  FUNCTION GETSCHEMENAMEDLG(NAME:STRING):STRING;
  FUNCTION SAVESCHEME(SCHEME_NAME:STRING;INDEX:BYTE):BYTE;
  FUNCTION GETSAVENAME(ORIGNAME:STRING):STRING;

  //MISC OS2 FUNCTIONS
  FUNCTION SYSFILETREE(FILESPEC:STRING;OPTIONS:STRING):FILEDATAR;
  FUNCTION OS2INI(INIFILE:STRING;ENTRY:STRING;KEY:STRING;ACTION:STRING;NEWVALUE:CSTRING[255]):STRING;

  //BITMAP RELATED FUNCTIONS
  procedure TileImage(Destination: TBitmap; Source: TBitmap; DESKTOP:BOOLEAN);
  procedure CenterImage(Destination: TBitmap; Source: TBitmap; DESKTOP:BOOLEAN);
  procedure StretchImage(Destination: TBitmap; Source: TBitmap; DESKTOP:BOOLEAN);
  FUNCTION UPDATEBMPPALETTE(PBITMAPMEM:POINTER;NEWCOLOR:TCOLOR):BYTE;
  FUNCTION GET_BMP_FROM_ARRAY(pbitmapmem:pointer;req_x,req_y:byte):BOOLEAN;
  FUNCTION PREVIEW_MOUNTWINCTRLS(FILENAME:STRING;NEWCOLOR:TCOLOR):BYTE;
  FUNCTION GETBITMAP:BOOLEAN;

  //SCHEME MANAGEMENT
  FUNCTION MOUNT_SCHEME:BYTE;
  FUNCTION UNMOUNT_SCHEME:BYTE;

  PROCEDURE REG_VARIABLES;
  FUNCTION CHECKREG2:STRING;
  FUNCTION INIT:BYTE;
  FUNCTION GET_REG_KEY:BYTE;

  //COLOUR MANIPULATION
  FUNCTION TCOLORTORGBSTRING(COLOUR:TCOLOR):STRING;
  FUNCTION DARK(COLOUR:TCOLOR):TCOLOR;
  FUNCTION LIGHT(COLOUR:TCOLOR):TCOLOR;
  FUNCTION EXDARK(COLOUR:TCOLOR):TCOLOR;
  FUNCTION EXLIGHT(COLOUR:TCOLOR):TCOLOR;


TYPE
   FONT_REC=RECORD
     NAME:STRING[30];
     SIZE:BYTE;
     ATTRIBUTES:TFONTATTRIBUTES;
   END;

Type
   CNTRL_TEXT_REC=RECORD
     FONT:FONT_REC;
     FONT_EN,CLR_EN,CHNG_FONT:BOOLEAN;
     COLOR:TCOLOR;
   END;

Type
   CNTRL_BACK_REC=RECORD
     TRANS:BOOLEAN;
     COLOR:TCOLOR;
     TRANS_USED,BITMAP_USED,BITMAP_EN:BOOLEAN;
     BMP_STYLE:BYTE;
     BITMAP_PATH:STRING;
   END;

Type
   CONTROL_REC=Record
     Name:String[30];
     TEXT:CNTRL_TEXT_REC;
     BACK:CNTRL_BACK_REC;
     TEXT_EN,BACK_EN:BOOLEAN;
   End;

TYPE SCHEME_REC=RECORD
     NAME:STRING[20];
     WIN_CTRL_DLL:STRING[20];
     USED:BOOLEAN;
     DATA:ARRAY[1..20] OF CONTROL_REC;
    END;

TYPE WINCTRL_REC=RECORD
       SYS,MAX,MIN,HIDE,CLOSE,BOX:TMEMORYSTREAM;
     END;

Var
  CUR_SCHEME:SCHEME_REC;
  COLOUR_WIN:ARRAY[1..8] OF TCOLOR;
  SCHEME:ARRAY[0..20] OF SCHEME_REC;
  selected_color:tcolor;
  WINCTRL:WINCTRL_REC;
  NEW_BMP_STREAM:TMEMORYSTREAM;
  COLOUR_ARRAY:ARRAY[1..20] OF TCOLOR;

  BOOTDRIVE,FULLNAME,REGCODE,SWITCHES,CURDIR,SELECT_BITMAP:STRING;
  STARTUP,SILENT,SCHEMEAPPLIED,NOREFRESH,CHANGED:BOOLEAN;
  NO_CONTROL_IDS,SCHEME_COUNT,BMP_STYLE,QUERY_RESULT,LASTSCHEMENO,LASTPROPERTYNO:BYTE;
  UPDATE_TEST,DEBUG_WIN_SIZE,WINDOW_CTRL_UPDATES:INTEGER;
  TEST_HANDLE,RES_SIZE,AHAB,DE_INI_HANDLE:LONGWORD;

CONST
  CCT_DIALOGBOX=0;
  CCT_DESKTOP=21;
  CCT_DESKTOPICON=22;
  CCT_FOLDERICON=23;
  DE_INI_LOCATION:STRING='\OS2\DE.INI';
  WIN_CONTROLS_ONLY=10;
  BMP_TILE=1;
  BMP_STRETCH=2;
  BMP_CENTER=3;

Const VERSION='1.11b';

Implementation

Uses pmshl,SYSUTILS,SCHEMESAV_DLG,PMBITMAP,BMP_DLG,BSEDOS,DOS,CLRSEL_DLG,PMWIN,DIALOGS;

// %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
// STANDARD MANIPULATION ROUTINES
// %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

FUNCTION SUBSTR(STRINGTOEDIT:STRING;START:INTEGER;LENGTH:INTEGER):STRING;  /*TAKES A STRING AND RETURNS PART OF IT*/
BEGIN
  RESULT:=COPY(STRINGTOEDIT,START,LENGTH);
END;

FUNCTION SUBWORD(D:STRING;S:CHAR;O,N:INTEGER):STRING;
VAR WORDA:ARRAY[1..100] OF STRING[100];
    L,I,J:INTEGER;
    E:STRING;
    NEW:BOOLEAN;
BEGIN
     E:='';NEW:=FALSE;J:=1;
     FOR I:=1 TO 100 DO WORDA[I]:='';
     L:=LENGTH(D);
     FOR I:=1 TO L DO BEGIN
         IF (COPY(D,I,1)<>S) THEN BEGIN
            WORDA[J]:=WORDA[J]+COPY(D,I,1);
            NEW:=TRUE;
         END
         ELSE IF NEW THEN BEGIN
            INC(J);
            NEW:=FALSE;
         END;
     END;
     IF COPY(D,L,1)=S THEN J:=J-1;
     IF N>1 THEN FOR I:=O TO O+N-1 DO E:=E+WORDA[I]+S
     ELSE E:=WORDA[O];
     RESULT:=E;
END;

FUNCTION NSUBWORD(D:STRING;S:CHAR;O,N:INTEGER):STRING;
VAR WORDA:ARRAY[1..100] OF STRING[100];
    L,I,J:INTEGER;
    E:STRING;
    NEW:BOOLEAN;
BEGIN
     E:='';NEW:=FALSE;J:=1;
     FOR I:=1 TO 100 DO WORDA[I]:='';
     L:=LENGTH(D);
     FOR I:=1 TO L DO BEGIN
         IF (COPY(D,I,1)<>S) THEN BEGIN
            WORDA[J]:=WORDA[J]+COPY(D,I,1);
            NEW:=TRUE;
         END
         ELSE IF NEW THEN BEGIN
            INC(J);
            NEW:=FALSE;
         END;
     END;
     IF COPY(D,L,1)=S THEN J:=J-1;
     IF N>1 THEN FOR I:=O TO O+N-1 DO E:=E+WORDA[I]+S
     ELSE E:=WORDA[O];
     RESULT:=E;
END;


FUNCTION TOINT(STRTOCHANGE:STRING):LONGWORD;
VAR GUNKINT1:INTEGER;
BEGIN
     VAL(STRTOCHANGE,RESULT,GUNKINT1);
END;

FUNCTION NWORDS(D:STRING;S:CHAR):INTEGER;
VAR I,N,L:INTEGER;
BEGIN
     N:=1;
     L:=LENGTH(D);
     FOR I:=1 TO L DO IF (COPY(D,I,1)=S) AND ((COPY(D,I+1,1)<>S)) AND (I<>L) THEN INC(N);
     IF COPY(D,1,1)=S THEN DEC(N);
     IF L=0 THEN DEC(N);
     RESULT:=N;
END;

FUNCTION TRANSLATE(DATA:STRING;OLD,NEW:CHAR):STRING;
VAR FND:INTEGER;
BEGIN
     REPEAT
       FND:=POS(OLD,DATA);
       DELETE(DATA,FND,1);
       IF FND>0 THEN INSERT(NEW,DATA,FND);
     UNTIL FND=0;
     RESULT:=DATA;
END;

FUNCTION BTOS(DATA:BOOLEAN):STRING;
BEGIN
  IF DATA THEN RESULT:='1' ELSE RESULT:='0';
END;

FUNCTION STOB(DATA:STRING[1]):BOOLEAN;
BEGIN
  IF DATA='1' THEN RESULT:=TRUE ELSE RESULT:=FALSE;
END;

// %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
// DIALOG CONTROL
// %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

FUNCTION GETBITMAP:BOOLEAN;
VAR BMPS,DLLS:FILEDATAR;
    GUNKBYTE1:BYTE;
Begin
  //POPULATE THE BITMAPS LISTBOX WITH CONTENTS OF \OS2\BITMAP
  IF (SELECT_BITMAP<>'') and (fileexists(SELECT_BITMAP)) THEN BEGIN
    BITMAP_DLG.RadioButton1.CHECKED:=FALSE;  BITMAP_DLG.RadioButton2.CHECKED:=FALSE; BITMAP_DLG.RadioButton3.CHECKED:=FALSE;
    BITMAP_DLG.DriveComboBox1.drive:=SELECT_BITMAP[1];
    BITMAP_DLG.DirectoryListBox1.drive:=BITMAP_DLG.DriveComboBox1.drive;
    BITMAP_DLG.DirectoryListBox1.directory:=extractfilepath(SELECT_BITMAP);
    BITMAP_DLG.BITMAPCOMBO.text:=extractfilename(SELECT_BITMAP);
    IF BMP_STYLE=1 THEN BITMAP_DLG.RadioButton2.CHECKED:=TRUE ELSE IF BMP_STYLE=2 THEN BITMAP_DLG.RadioButton3.CHECKED:=TRUE ELSE BITMAP_DLG.RadioButton1.CHECKED:=TRUE;
  END
  ELSE BEGIN BITMAP_DLG.DirectoryListBox1.directory:=BOOTDRIVE+'\OS2\BITMAP\';  BITMAP_DLG.BITMAPCOMBO.text:=''; END;
  BITMAP_DLG.BITMAPCOMBO.ONCHANGE(NIL);

  bITMAP_DLG.SHOWMODAL;
  IF BITMAP_DLG.MODALRESULT=CMCANCEL THEN RESULT:=FALSE ELSE RESULT:=TRUE;

  IF BITMAP_DLG.RadioButton1.CHECKED THEN BMP_STYLE:=3;
  IF BITMAP_DLG.RadioButton2.CHECKED THEN BMP_STYLE:=1;
  IF BITMAP_DLG.RadioButton3.CHECKED THEN BMP_STYLE:=2;
  SELECT_BITMAP:=BITMAP_DLG.DirectoryListBox1.directory+'\'+BITMAP_DLG.BITMAPCOMBO.TEXT;
END;

FUNCTION SAVESCHEME(SCHEME_NAME:STRING;INDEX:BYTE):BYTE;
BEGIN
  //SAVE THE SCHEME STATE
  if SCHEME_NAME<>'' then begin
    SCHEME[INDEX]:=CUR_SCHEME;
    SCHEME[INDEX].name:=SCHEME_NAME;
    CUR_SCHEME.NAME:=SCHEME_NAME;
  end;
END;

FUNCTION GETSCHEMENAMEDLG(NAME:STRING):STRING;
BEGIN
  SchSave_DLG.EDIT1.capturefocus;
  SchSave_DLG.SHOWMODAL;
  result:=SchSave_DLG.EDIT1.TEXT;
  IF SchSave_DLG.MODALRESULT=CMCANCEL THEN RESULT:='';
END;

FUNCTION GETCOLORDLG(DATA:TCOLOR;FULLRANGE:BOOLEAN):TCOLOR;
VAR EXTRAlight3d,light3d,dark3d:TCOLOR;
    R,RN,G,GN,B,BN:BYTE;
begin
  WITH CLR_SEL_DLG DO BEGIN
    LIMIT.CHECKED:=NOT FULLRANGE;
    rgbtovalues(DATA,R,G,B);
    IF R+60>255 THEN RN:=255 ELSE RN:=R+60;IF G+60>255 THEN GN:=255 ELSE GN:=G+60;IF B+60>255 THEN BN:=255 ELSE BN:=B+60;
    light3d:=valuestorgb(R+30,G+30,B+30);  DARK3d:=valuestorgb(R-30,G-30,B-30);

    SpeedButton5.color:=DATA;                              //DIALOG COLOR
    SpeedButton6.color:=light3d;                           //DIALOG HIGH
    SpeedButton7.color:=DARK3d;                            //DIALOG LOW
    SpeedButton8.color:=CUR_SCHEME.DATA[1].TEXT.color;     //DIALOG TEXT COLOR
    SpeedButton9.color:=CUR_SCHEME.DATA[8].BACK.color;

    //LOAD THE CUSTOM COLOURS TO AN ARRAY
    SpeedButton15.COLOR:=COLOUR_ARRAY[1];  SpeedButton14.COLOR:=COLOUR_ARRAY[2];  SpeedButton13.COLOR:=COLOUR_ARRAY[3];  SpeedButton12.COLOR:=COLOUR_ARRAY[4];  SpeedButton11.COLOR:=COLOUR_ARRAY[5];
    SpeedButton20.COLOR:=COLOUR_ARRAY[6];  SpeedButton19.COLOR:=COLOUR_ARRAY[7];  SpeedButton18.COLOR:=COLOUR_ARRAY[8];  SpeedButton17.COLOR:=COLOUR_ARRAY[9];  SpeedButton16.COLOR:=COLOUR_ARRAY[10];
    SpeedButton1.COLOR:=COLOUR_ARRAY[11];  SpeedButton2.COLOR:=COLOUR_ARRAY[12];  SpeedButton3.COLOR:=COLOUR_ARRAY[13];  SpeedButton4.COLOR:=COLOUR_ARRAY[14];  SpeedButton10.COLOR:=COLOUR_ARRAY[15];
    SpeedButton25.COLOR:=COLOUR_ARRAY[16];  SpeedButton24.COLOR:=COLOUR_ARRAY[17];  SpeedButton23.COLOR:=COLOUR_ARRAY[18];  SpeedButton22.COLOR:=COLOUR_ARRAY[19];  SpeedButton21.COLOR:=COLOUR_ARRAY[20];

    Red_Scroll.POSITION:=R;
    GREEN_Scroll.POSITION:=G;
    BLUE_Scroll.POSITION:=B;
  END;
  CLR_SEL_DLG.SHOWMODAL;
  if CLR_SEL_DLG.modalresult=cmok then WITH CLR_SEL_DLG DO BEGIN
    result:=VALUESTORGB(Red_Scroll.POSITION,GREEN_Scroll.POSITION,BLUE_Scroll.POSITION);
    //SAVE OUT THE CUSTOM COLOURS TO AN ARRAY
    COLOUR_ARRAY[1]:=SpeedButton15.COLOR;  COLOUR_ARRAY[2]:=SpeedButton14.COLOR;  COLOUR_ARRAY[3]:=SpeedButton13.COLOR;  COLOUR_ARRAY[4]:=SpeedButton12.COLOR;
    COLOUR_ARRAY[5]:=SpeedButton11.COLOR;  COLOUR_ARRAY[6]:=SpeedButton20.COLOR;  COLOUR_ARRAY[7]:=SpeedButton19.COLOR;  COLOUR_ARRAY[8]:=SpeedButton18.COLOR;
    COLOUR_ARRAY[9]:=SpeedButton17.COLOR;  COLOUR_ARRAY[10]:=SpeedButton16.COLOR;  COLOUR_ARRAY[11]:=SpeedButton1.COLOR;  COLOUR_ARRAY[12]:=SpeedButton2.COLOR;
    COLOUR_ARRAY[13]:=SpeedButton3.COLOR;  COLOUR_ARRAY[14]:=SpeedButton4.COLOR;  COLOUR_ARRAY[15]:=SpeedButton10.COLOR;  COLOUR_ARRAY[16]:=SpeedButton25.COLOR;
    COLOUR_ARRAY[17]:=SpeedButton24.COLOR;  COLOUR_ARRAY[18]:=SpeedButton23.COLOR;  COLOUR_ARRAY[19]:=SpeedButton22.COLOR;  COLOUR_ARRAY[20]:=SpeedButton21.COLOR;
  END
  else result:=data;
END;

FUNCTION GETSAVENAME(ORIGNAME:STRING):STRING;
BEGIN
  SchSave_DLG.edit1.text:=ORIGNAME;
  IF ORIGNAME='' THEN SchSave_DLG.Button1.ENABLED:=FALSE ELSE SchSave_DLG.Button1.ENABLED:=TRUE;
  SchSave_DLG.SHOWMODAL;
  IF SchSave_DLG.MODALRESULT=CMOK THEN RESULT:=SchSave_DLG.edit1.text ELSE RESULT:='';
END;


// %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
// MISC OS2 FUNCTIONS
// %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

FUNCTION OS2INI(INIFILE:STRING;ENTRY:STRING;KEY:STRING;ACTION:STRING;NEWVALUE:CSTRING[255]):STRING;
VAR GUNKCSTR1:CSTRING;
    AHAB,DE_HANDLE:LONGWORD;
BEGIN
     RESULT:='';GUNKCSTR1:='';
     IF INIFILE='SYS' THEN BEGIN
        IF ACTION='READ' THEN BEGIN
           PRFQUERYPROFILESTRING(HINI_SYSTEMPROFILE,ENTRY,KEY,NIL,GUNKCSTR1,SIZEOF(GUNKCSTR1));
           RESULT:=GUNKCSTR1;
        END
        ELSE PRFWRITEPROFILESTRING(HINI_SYSTEMPROFILE,ENTRY,KEY,NEWVALUE);
     END;
     IF INIFILE='USER' THEN BEGIN
        IF ACTION='READ' THEN BEGIN
           PRFQUERYPROFILESTRING(HINI_USERPROFILE,ENTRY,KEY,NIL,GUNKCSTR1,SIZEOF(GUNKCSTR1));
           RESULT:=GUNKCSTR1;
        END
        ELSE PRFWRITEPROFILESTRING(HINI_USERPROFILE,ENTRY,KEY,NEWVALUE);
     END;
     IF INIFILE='DE' THEN BEGIN
        DE_HANDLE:=PRFOPENPROFILE(AHAB,'.\CLRMAN2.INI');
        IF ACTION='READ' THEN BEGIN
           PRFQUERYPROFILESTRING(DE_HANDLE,ENTRY,KEY,NIL,GUNKCSTR1,SIZEOF(GUNKCSTR1));
           RESULT:=GUNKCSTR1;
        END
        ELSE PRFWRITEPROFILESTRING(DE_HANDLE,ENTRY,KEY,NEWVALUE);
        PRFCLOSEPROFILE(DE_HANDLE);
     END;
END;

FUNCTION SYSFILETREE(FILESPEC:STRING;OPTIONS:STRING):FILEDATAR;
VAR GUNKINT1:INTEGER=1;
    RC:INTEGER=0;
    FILERET:TSEARCHREC;
    F_SEARCHDATA:FILEDATAR;
BEGIN
      /*OPTIONS ARE : B=FILES AND DIR
                      D=DIRECTORIES ONLY
                      F=FILES ONLY
                      S=SUBFOLDERS ARE RETURNED ALSO*/

      GUNKINT1:=0;
      UPCASESTR(OPTIONS);

      IF POS('D',OPTIONS)<>0 THEN BEGIN
           IF POS('S',OPTIONS)=0 THEN BEGIN
              RC:=FINDFIRST(FILESPEC,FADIRECTORY,FILERET);
              IF RC=0 THEN BEGIN
                 IF FILERET.NAME<>'.' THEN BEGIN
                    INC(GUNKINT1);
                    RESULT.NAME[GUNKINT1]:=FILERET.NAME;
                 END;
                 IF RC=0 THEN BEGIN
                    RC:=FINDNEXT(FILERET);
                    IF (RC=0) AND (FILERET.NAME<>'..') THEN BEGIN
                       INC(GUNKINT1);
                       RESULT.NAME[GUNKINT1]:=FILERET.NAME;
                    END;
                    WHILE RC=0 DO BEGIN
                       RC:=FINDNEXT(FILERET);
                       IF RC=0 THEN BEGIN
                          INC(GUNKINT1);
                          RESULT.NAME[GUNKINT1]:=FILERET.NAME;
                       END;
                    END;
                 END;
              END;
              RESULT.NOSFOUND:=GUNKINT1;
           END;
      END;

      IF POS('B',OPTIONS)<>0 THEN BEGIN
           IF POS('S',OPTIONS)<>0 THEN BEGIN


           END
           ELSE BEGIN
              RC:=FINDFIRST(FILESPEC,FAANYFILE,FILERET);
              IF FILERET.NAME<>'.' THEN BEGIN
                  INC(GUNKINT1);
                  RESULT.NAME[GUNKINT1]:=FILERET.NAME;
              END;
              IF RC=0 THEN BEGIN
                 RC:=FINDNEXT(FILERET);
                 IF (RC=0) AND (FILERET.NAME<>'..') THEN BEGIN
                    INC(GUNKINT1);
                    RESULT.NAME[GUNKINT1]:=FILERET.NAME;
                 END;
                 WHILE RC=0 DO BEGIN
                      RC:=FINDNEXT(FILERET);
                      IF RC=0 THEN BEGIN
                         INC(GUNKINT1);
                         RESULT.NAME[GUNKINT1]:=FILERET.NAME;
                      END;
                 END;
              END;
              RESULT.NOSFOUND:=GUNKINT1;
           END;
      END;
      IF POS('F',OPTIONS)<>0 THEN
      BEGIN
           IF POS('S',OPTIONS)<>0 THEN BEGIN

           END
           ELSE BEGIN
              RC:=FINDFIRST(FILESPEC,FAREADONLY OR FASYSFILE OR FAHIDDEN OR FAARCHIVE,FILERET);
              IF RC=0 THEN BEGIN
                 INC(GUNKINT1);
                 RESULT.NAME[GUNKINT1]:=FILERET.NAME;
                 WHILE RC=0 DO BEGIN
                      RC:=FINDNEXT(FILERET);
                      IF RC=0 THEN BEGIN
                         INC(GUNKINT1);
                         RESULT.NAME[GUNKINT1]:=FILERET.NAME;
                      END;
                 END;
              END;
              RESULT.NOSFOUND:=GUNKINT1;
           END;
      END;
      FINDCLOSE(FILERET);
END;

// %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
// BITMAP RELATED FUNCTIONS
// %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

FUNCTION UPDATEBMPPALETTE(PBITMAPMEM:POINTER;NEWCOLOR:TCOLOR):BYTE;
VAR Pbafh2 : PBITMAPARRAYFILEHEADER2;
    pbfh2  : PBITMAPFILEHEADER2;
    pbih2  : PBITMAPINFOHEADER2;
    pbi  : PBITMAPINFO;
    lColorCount:LONGWORD;
    j:longword;
    IMAGE_COUNT:BYTE;
    R,G,B:BYTE;
    RDIF,GDIF,BDIF:INTEGER;
    NEWPOINTER:POINTER;

BEGIN
  //THIS ROUTINE WILL ONLY PROCESS BITMAP ARRAYS WITH 1.X FORMATTING FOR PBI
  //RETURN CODES:
  // 1 = INVALID COLOUR COUNT
  // 2 = NOT A BITMAP ARRAY!
  // 3 = NOT OS2 1.X FILE FORMAT
  IMAGE_COUNT:=0; RESULT:=0;

  pbafh2:=PBitmapMem;  //REFER THE BITMAP POINTER TO THE ARRAYFILEHEADER STRUCTURE
  IF pbafh2^.USTYPE=BFT_BITMAPARRAY THEN BEGIN REPEAT
    INC(IMAGE_COUNT);
    IF IMAGE_COUNT<>1 THEN pbafh2:=PBitmapMem+pbafh2^.offnext;  //JUMP TO THE NEXT BITMAP OFFSET
    pbfh2:=@pbafh2^.bfh2;  pbih2:=@pbfh2^.bmp2;
    If pbih2^.cbFix = SizeOf(BITMAPINFOHEADER) Then begin  //CHECKS IF IT IS AN OS2 1.X FILE
      pbi:=@pbfh2^.bmp2;
      lColorCount:= pbi^.cPlanes * (LongWord(1) Shl pbi^.cBitCount); //CALCULATES THE COLOUR COUNT OF THE BITMAP
      IF LCOLORCOUNT<257 THEN FOR J:=0 TO lColorCount-1 DO BEGIN     //CYCLES THROUGH THE PALETTE AND OFFSET TO MAGIC COLOR - ASSUMED BASE COLOR IS 204,204,204
        RGBTOVALUES(NEWCOLOR,R,G,B);
        IF R>204 THEN RDIF:=(R-204) ELSE RDIF:=(204-R)*-1;  IF G>204 THEN GDIF:=(G-204) ELSE GDIF:=(204-G)*-1; IF B>204 THEN BDIF:=(B-204) ELSE BDIF:=(204-B)*-1;
        IF (PBI^.ARGBCOLOR[J].BRED+RDIF<255) AND (PBI^.ARGBCOLOR[J].BRED+RDIF>0) THEN PBI^.ARGBCOLOR[J].BRED:=PBI^.ARGBCOLOR[J].BRED+RDIF;
        IF (PBI^.ARGBCOLOR[J].BGREEN+GDIF<255) AND (PBI^.ARGBCOLOR[J].BGREEN+GDIF>0) THEN PBI^.ARGBCOLOR[J].BGREEN:=PBI^.ARGBCOLOR[J].BGREEN+GDIF;
        IF (PBI^.ARGBCOLOR[J].bBLUE+BDIF<255) AND (PBI^.ARGBCOLOR[J].BBLUE+BDIF>0) THEN PBI^.ARGBCOLOR[J].BBLUE:=PBI^.ARGBCOLOR[J].BBLUE+BDIF;
      END
      ELSE RESULT:=1;
    END
    ELSE RESULT:=3;
  UNTIL pbafh2^.offnext=0;
  END
  ELSE RESULT:=2;
END;

FUNCTION GET_BMP_FROM_ARRAY(pbitmapmem:pointer;req_x,req_y:byte):BOOLEAN;
VAR Pbafh2 : PBITMAPARRAYFILEHEADER2;
    pbfh2  : PBITMAPFILEHEADER2;
    pbih2  : PBITMAPINFOHEADER2;
    pbi  : PBITMAPINFO;

    IMAGE_COUNT:BYTE;
    PELOFFSET,LASTBMPOFF,NOS_COLOURS:LONGWORD;
    NEWPOINTER:POINTER;
    DBL_W_BOUND:BYTE;
    TEST:LONGINT;

    FOUND:BOOLEAN;
begin
  //THIS ROUTINE WILL INVESTIGATE THE BMP AND GET ALL THE VITAL STATISTICS REQUIRED TO RIP AN INDIVIDUAL BITMAP
  FOUND:=FALSE;
  IMAGE_COUNT:=0; LASTBMPOFF:=0;
  pbafh2:=PBitmapMem;  //REFER THE BITMAP POINTER TO THE ARRAYFILEHEADER STRUCTURE
  IF pbafh2^.USTYPE=BFT_BITMAPARRAY THEN BEGIN
    REPEAT
      INC(IMAGE_COUNT);
      IF IMAGE_COUNT<>1 THEN pbafh2:=PBitmapMem+pbafh2^.offnext;  //JUMP TO THE NEXT BITMAP OFFSET
      pbfh2:=@pbafh2^.bfh2; pbih2:=@pbfh2^.bmp2;
      If pbih2^.cbFix = SizeOf(BITMAPINFOHEADER) Then begin  //CHECKS IF IT IS AN OS2 1.X FILE
        pbi:=@pbfh2^.bmp2;
        NOS_COLOURS:=pbi^.cPlanes * (LongWord(1) Shl pbi^.cBitCount);
        IF (PBI^.CX=REQ_X) AND (PBI^.CY=REQ_Y) THEN BEGIN  //WE HAVE A MATCH, SAVE THE DATA OUT
          NEW_BMP_STREAM.CREATE;           //CREATE THE MEMORY BLOCK TO WRITE TO
          PELOFFSET:=pbfh2^.offbits;       //WE NEED TO SAVE THE PEL DATA OFFSET AS WE MODIFY IT ON THE NEXT LINE
          NEWPOINTER:=PBitmapMem+LASTBMPOFF+SIZEOF(Pbafh2^)-SIZEOF(Pbfh2^);   //LOCATE THE START OF THE BITMAP INFO HEADER
          pbfh2^.offbits:=SIZEOF(Pbfh2^)-SIZEOF(pbih2^)+SIZEOF(pbi^)+((NOS_COLOURS-1)*3);  //MODIFY THE ENTRY TO REFLECT THE NEW OFFSET FOR THE PEL DATA
          NEW_BMP_STREAM.WRITEBUFFER(NEWPOINTER^,SIZEOF(Pbfh2^)-SIZEOF(pbih2^)+SIZEOF(pbi^)+((NOS_COLOURS-1)*3));    //WRITES OUT THE BITMAP HEADER INFO
          NEWPOINTER:=PBitmapMem+PELOFFSET;                                         //JUMP TO THE PEL DATA BLOCK
          IF (REQ_X MOD 4) <> 0 THEN REPEAT INC(REQ_X); UNTIL (REQ_X MOD 4)=0;      //THE HORIZONTAL BITMAP DATA IS PADDED TO THE NEAREST 4
          TEST:=REQ_X*REQ_Y;
          NEW_BMP_STREAM.WRITEBUFFER(NEWPOINTER^,TEST);                    //WRITES OUT THE BITMAP PEL DATA
          NEW_BMP_STREAM.Position:=0;                                               //WE NEED TO RESET THE FILE POINTER TO THE START OF THE STRING
          FOUND:=TRUE;
        END;
      END;
      LASTBMPOFF:=pbafh2^.offnext;
    UNTIL pbafh2^.offnext=0;
  END;
  RESULT:=FOUND;
END;

FUNCTION PREVIEW_MOUNTWINCTRLS(FILENAME:STRING;NEWCOLOR:TCOLOR):BYTE;            //UPDATES THE DEMO-WINDOW WITH THE NEW WINDOW CONTROLS
VAR BMP_FILE,TEST_FILE:TFILESTREAM;
    PBitmapMem,BUFFER:Pointer;
    RC,I:BYTE;
    MODULEHANDLE,RC2:LONGWORD;
    LOADERROR:cstring;
BEGIN
  IF NOT FILEEXISTS(FILENAME) THEN BEGIN
    MessageBox('Unable to find the requested theme file! Attempting to load DEFAULT!'+chr(13)+chr(13)+FILENAME,mtError,[mbOk]);
    FILENAME:=CURDIR+'\THEMES\ECS.DLL';
    IF NOT FILEEXISTS(FILENAME) THEN BEGIN MessageBox('Unable to find the DEFAULT theme file! Cannot continue!',mtError,[mbOk]); HALT; END;
  END;

  RC2:=DOSLOADMODULE(LOADERROR,SIZEOF(LOADERROR),FILENAME,MODULEHANDLE);
  IF RC2<>0 THEN MessageBox('DOSLOADMODULE Failure! - I am going to crash!',mtError,[mbOk]) ELSE BEGIN

  //CLOSE BUTTON
  IF DOSGETRESOURCE(MODULEHANDLE,2,52,BUFFER)<>0 THEN MessageBox('DOSGETRESOURCE Failure! - I am going to crash!',mtError,[mbOk]);
  DOSQUERYRESOURCESIZE(MODULEHANDLE,2,52,RES_SIZE);
  GETMEM(PBitmapMem,RES_SIZE); SYSTEM.MOVE(BUFFER^,PBitmapMem^,RES_SIZE); DOSFREERESOURCE(BUFFER);
  IF UPDATEBMPPALETTE(PBitmapMem,NEWCOLOR)<>0 THEN MessageBox('UPDATEPALETTE Failure! - I am going to crash!',mtError,[mbOk]);
  IF NOT GET_BMP_FROM_ARRAY(pbitmapmem,18,18) THEN MessageBox('GETBMPFROMARRAY Failure! - I am going to crash!',mtError,[mbOk]);
  FREEMEM(PBitmapMem,RES_SIZE);
  NEW_BMP_STREAM.POSITION:=0; WINCTRL.CLOSE.CLEAR; WINCTRL.CLOSE.COPYFROM(NEW_BMP_STREAM,NEW_BMP_STREAM.SIZE);
  NEW_BMP_STREAM.DESTROY;

  //MIN BUTTON
  RC2:=DOSGETRESOURCE(MODULEHANDLE,2,26,BUFFER);
  DOSQUERYRESOURCESIZE(MODULEHANDLE,2,26,RES_SIZE);
  GETMEM(PBitmapMem,RES_SIZE); SYSTEM.MOVE(BUFFER^,PBitmapMem^,RES_SIZE); DOSFREERESOURCE(BUFFER);
  RC:=UPDATEBMPPALETTE(PBitmapMem,NEWCOLOR); GET_BMP_FROM_ARRAY(pbitmapmem,18,18);
  FREEMEM(PBitmapMem,RES_SIZE);
  NEW_BMP_STREAM.POSITION:=0; WINCTRL.MIN.CLEAR; WINCTRL.MIN.COPYFROM(NEW_BMP_STREAM,NEW_BMP_STREAM.SIZE);
  NEW_BMP_STREAM.DESTROY;

  //MAX BUTTON
  RC2:=DOSGETRESOURCE(MODULEHANDLE,2,27,BUFFER);
  DOSQUERYRESOURCESIZE(MODULEHANDLE,2,27,RES_SIZE);
  GETMEM(PBitmapMem,RES_SIZE); SYSTEM.MOVE(BUFFER^,PBitmapMem^,RES_SIZE); DOSFREERESOURCE(BUFFER);
  RC:=UPDATEBMPPALETTE(PBitmapMem,NEWCOLOR); GET_BMP_FROM_ARRAY(pbitmapmem,18,18);
  FREEMEM(PBitmapMem,RES_SIZE);
  NEW_BMP_STREAM.POSITION:=0; WINCTRL.MAX.CLEAR; WINCTRL.MAX.COPYFROM(NEW_BMP_STREAM,NEW_BMP_STREAM.SIZE);
  NEW_BMP_STREAM.DESTROY;

  //HIDE BUTTON
  RC2:=DOSGETRESOURCE(MODULEHANDLE,2,50,BUFFER);
  DOSQUERYRESOURCESIZE(MODULEHANDLE,2,50,RES_SIZE);
  GETMEM(PBitmapMem,RES_SIZE); SYSTEM.MOVE(BUFFER^,PBitmapMem^,RES_SIZE); DOSFREERESOURCE(BUFFER);
  RC:=UPDATEBMPPALETTE(PBitmapMem,NEWCOLOR); GET_BMP_FROM_ARRAY(pbitmapmem,18,18);
  FREEMEM(PBitmapMem,RES_SIZE);
  NEW_BMP_STREAM.POSITION:=0; WINCTRL.HIDE.CLEAR; WINCTRL.HIDE.COPYFROM(NEW_BMP_STREAM,NEW_BMP_STREAM.SIZE);
  NEW_BMP_STREAM.DESTROY;

  //SYS BUTTON
  RC2:=DOSGETRESOURCE(MODULEHANDLE,2,25,BUFFER);
  DOSQUERYRESOURCESIZE(MODULEHANDLE,2,25,RES_SIZE);
  GETMEM(PBitmapMem,RES_SIZE); SYSTEM.MOVE(BUFFER^,PBitmapMem^,RES_SIZE); DOSFREERESOURCE(BUFFER);
  RC:=UPDATEBMPPALETTE(PBitmapMem,NEWCOLOR); GET_BMP_FROM_ARRAY(pbitmapmem,18,18);
  FREEMEM(PBitmapMem,RES_SIZE);
  NEW_BMP_STREAM.POSITION:=0; WINCTRL.SYS.CLEAR; WINCTRL.SYS.COPYFROM(NEW_BMP_STREAM,NEW_BMP_STREAM.SIZE);
  NEW_BMP_STREAM.DESTROY;

  //CHK & RAD_ON & RAD_OFF BUTTON
  RC2:=DOSGETRESOURCE(MODULEHANDLE,2,48,BUFFER);
  DOSQUERYRESOURCESIZE(MODULEHANDLE,2,48,RES_SIZE);
  GETMEM(PBitmapMem,RES_SIZE); SYSTEM.MOVE(BUFFER^,PBitmapMem^,RES_SIZE); DOSFREERESOURCE(BUFFER);
  RC:=UPDATEBMPPALETTE(PBitmapMem,NEWCOLOR); GET_BMP_FROM_ARRAY(pbitmapmem,64,48);
  FREEMEM(PBitmapMem,RES_SIZE);
  NEW_BMP_STREAM.POSITION:=0; WINCTRL.BOX.CLEAR;      WINCTRL.BOX.COPYFROM(NEW_BMP_STREAM,NEW_BMP_STREAM.SIZE);  NEW_BMP_STREAM.DESTROY;

  //FREE UP THE REMAINING DATA
  DOSFREEMODULE(MODULEHANDLE);
  END;
END;

procedure CenterImage(Destination: TBitmap; Source: TBitmap; DESKTOP:BOOLEAN);
VAR SCALE,NEW_WIDTH,NEW_HEIGHT:INTEGER;
    REC:TRECT;
begin
  IF DESKTOP THEN BEGIN
    //BLOCK FILL THE BITMAP FIRST
    REC.LEFT:=0; REC.RIGHT:=DESTINATION.WIDTH; REC.BOTTOM:=0; REC.TOP:=DESTINATION.HEIGHT;
    destination.CANVAS.FILLRECT(REC,CUR_SCHEME.DATA[2].BACK.COLOR);

    SCALE:=(SCREEN.WIDTH/416)*1000;  //NEED TO CALCULATE THE SCALE FACTOR FIRST
    NEW_WIDTH:=((source.width*1000) DIV SCALE);  NEW_HEIGHT:=((source.HEIGHT*1000) DIV SCALE);
    destination.Canvas.STRETCHDraw((416-NEW_WIDTH) div 2, (312-NEW_HEIGHT) div 2, NEW_WIDTH, NEW_HEIGHT, source)
  END
  ELSE BEGIN
    //BLOCK FILL THE BITMAP FIRST
    REC.LEFT:=0; REC.RIGHT:=DESTINATION.WIDTH; REC.BOTTOM:=0; REC.TOP:=DESTINATION.HEIGHT;
    destination.CANVAS.FILLRECT(REC,CUR_SCHEME.DATA[11].BACK.COLOR);

    SCALE:=(SCREEN.WIDTH/242)*1000;  //NEED TO CALCULATE THE SCALE FACTOR FIRST
    NEW_WIDTH:=((source.width*1000) DIV SCALE);  NEW_HEIGHT:=((source.HEIGHT*1000) DIV SCALE);
    IF NEW_HEIGHT>83 THEN BEGIN  //NEED TO RE-SCALE
      SCALE:=(NEW_HEIGHT/83)*1000;  //NEED TO CALCULATE THE SCALE FACTOR FIRST
      NEW_WIDTH:=((NEW_width*1000) DIV SCALE);  NEW_HEIGHT:=((NEW_HEIGHT*1000) DIV SCALE);
    END;
    destination.Canvas.STRETCHDraw((242-NEW_WIDTH) div 2, (83-NEW_HEIGHT) div 2, NEW_WIDTH, NEW_HEIGHT, source);
  END;
end;

procedure StretchImage(Destination: TBitmap; Source: TBitmap; DESKTOP:BOOLEAN);
begin
  IF DESKTOP THEN destination.Canvas.StretchDraw(0,0,416,312, source) //HARD CODED DUE TO A BUG
  ELSE destination.Canvas.StretchDraw(0,0,242,83, source); //HARD CODED DUE TO A BUG
end;

procedure TileImage(Destination: TBitmap; Source: TBitmap; DESKTOP:BOOLEAN);
var
  X,Y,SCALE,NEW_WIDTH,NEW_HEIGHT:INTEGER;
  REC:TRECT;
begin
  IF DESKTOP THEN BEGIN
    SCALE:=(SCREEN.WIDTH/416)*1000;  //NEED TO CALCULATE THE SCALE FACTOR FIRST
    NEW_WIDTH:=((source.width*1000) DIV SCALE);  NEW_HEIGHT:=((source.HEIGHT*1000) DIV SCALE);

    Y := 0;
    while (Y < 312) do begin
      X := 0;
      while (X < 416) do begin
        destination.Canvas.STRETCHDraw(X, Y, NEW_WIDTH ,NEW_HEIGHT, source);
        Inc(X, NEW_WIDTH);
      end;
      Y:=NEW_HEIGHT+y;
    end;
  END
  ELSE BEGIN
    SCALE:=(SCREEN.WIDTH/242)*1000;  //NEED TO CALCULATE THE SCALE FACTOR FIRST
    NEW_WIDTH:=((source.width*1000) DIV SCALE);  NEW_HEIGHT:=((source.HEIGHT*1000) DIV SCALE);
    IF NEW_HEIGHT>83 THEN BEGIN  //NEED TO RE-SCALE
      SCALE:=(NEW_HEIGHT/83)*1000;  //NEED TO CALCULATE THE SCALE FACTOR FIRST
      NEW_WIDTH:=((NEW_width*1000) DIV SCALE);  NEW_HEIGHT:=((NEW_HEIGHT*1000) DIV SCALE);
    END;
    Y := 0;
    while (Y < 83) do begin
      X := 0;
      while (X < 242) do begin
        destination.Canvas.STRETCHDraw(X, Y, NEW_WIDTH ,NEW_HEIGHT, source);
        Inc(X, NEW_WIDTH);
      end;
      Y:=NEW_HEIGHT+y;
    end;
  END;
end;

// %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
// SCHEME MANAGEMENT
// %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

FUNCTION UNMOUNT_SCHEME:BYTE;
VAR GUNKBYTE1:BYTE;
    SCHEME_FILE:TFILESTREAM;
BEGIN
  SCHEME_FILE.CREATE(CURDIR+'\SCHEMES.DAT',Stream_Create);
  SCHEME_FILE.WRITE(CUR_SCHEME,SIZEOF(CUR_SCHEME));
  FOR GUNKBYTE1:=1 TO SCHEME_COUNT DO SCHEME_FILE.WRITE(SCHEME[GUNKBYTE1],SIZEOF(SCHEME[GUNKBYTE1]));
  FOR GUNKBYTE1:=1 TO 20 DO SCHEME_FILE.WRITE(COLOUR_ARRAY[GUNKBYTE1],SIZEOF(COLOUR_ARRAY[GUNKBYTE1]));
  SCHEME_FILE.DESTROY;
END;

FUNCTION MOUNT_SCHEME:BYTE;
VAR GUNKBYTE1:BYTE;
    SCHEME_FILE:TFILESTREAM;
Begin
  //CHECK TO SEE IF THE FILE EXISTS
  IF NOT FILEEXISTS(CURDIR+'\SCHEMES.DAT') THEN BEGIN MessageBox('Unable to find the SCHEMES.DAT file - Please check that it exists in the CLRMAN/2 folder.',mtError,[mbOk]); HALT; END
  ELSE BEGIN
    SCHEME_FILE.CREATE(CURDIR+'\SCHEMES.DAT',Stream_OpenRead);
    SCHEME_FILE.READ(SCHEME[0],SIZEOF(SCHEME[0]));
    SCHEME_COUNT:=(SCHEME_FILE.SIZE DIV SIZEOF(SCHEME[1]))-1;
    FOR GUNKBYTE1:=1 TO SCHEME_COUNT DO SCHEME_FILE.READ(SCHEME[GUNKBYTE1],SIZEOF(SCHEME[GUNKBYTE1]));
    FOR GUNKBYTE1:=1 TO 20 DO SCHEME_FILE.READ(COLOUR_ARRAY[GUNKBYTE1],SIZEOF(COLOUR_ARRAY[GUNKBYTE1]));
    SCHEME_FILE.DESTROY;

    //REG_VARIABLES;  SCHEME_COUNT:=1; //ONLY USED WHEN WE MAKE A CHANGE TO THE FORMAT OF THE DATA RECORDS
    CUR_SCHEME:=SCHEME[0];
  END;
END;

PROCEDURE REG_VARIABLES;
BEGIN
  SCHEME_COUNT:=1;
  SCHEME[0].NAME:='TEST';
  SCHEME[0].USED:=TRUE;
  SCHEME[0].WIN_CTRL_DLL:='ECS';
  WITH SCHEME[0].DATA[1] DO BEGIN
  NAME:='Dialog Box'; TEXT.CHNG_FONT:=FALSE;BACK_EN:=TRUE;TEXT_EN:=TRUE;TEXT.COLOR:=CLBLACK;BACK.COLOR:=VALUESTORGB(204,204,168);BACK.TRANS_USED:=FALSE; BACK.BITMAP_EN:=FALSE; BACK.BITMAP_USED:=FALSE; BACK.BMP_STYLE:=0; BACK.TRANS:=FALSE; END;
  WITH SCHEME[0].DATA[2] DO BEGIN
  NAME:='Desktop';    TEXT.CHNG_FONT:=FALSE;BACK_EN:=TRUE;TEXT_EN:=FALSE;BACK.COLOR:=CLGREEN;BACK.BITMAP_EN:=TRUE; BACK.TRANS_USED:=FALSE; BACK.BITMAP_USED:=FALSE; BACK.BMP_STYLE:=1; BACK.TRANS:=FALSE; END;
  WITH SCHEME[0].DATA[3] DO BEGIN
  NAME:='Desktop Icon';TEXT.CHNG_FONT:=TRUE;BACK_EN:=TRUE; TEXT_EN:=TRUE;TEXT.COLOR:=CLBLACK;BACK.COLOR:=VALUESTORGB(204,204,168); BACK.BITMAP_EN:=FALSE; BACK.TRANS_USED:=TRUE; BACK.BITMAP_USED:=FALSE; BACK.BMP_STYLE:=0; BACK.TRANS:=FALSE; END;
  WITH SCHEME[0].DATA[4] DO BEGIN
  NAME:='Desktop Shadow Icon';TEXT.CHNG_FONT:=TRUE;BACK_EN:=TRUE;TEXT_EN:=TRUE;TEXT.COLOR:=CLBLACK;BACK.COLOR:=VALUESTORGB(204,204,168); BACK.BITMAP_EN:=FALSE; BACK.TRANS_USED:=TRUE; BACK.BITMAP_USED:=FALSE; BACK.BMP_STYLE:=0; BACK.TRANS:=FALSE; END;
  WITH SCHEME[0].DATA[5] DO BEGIN
  NAME:='Menu';  TEXT.CHNG_FONT:=TRUE;BACK_EN:=TRUE; TEXT_EN:=TRUE;TEXT.COLOR:=CLBLACK;BACK.COLOR:=VALUESTORGB(204,204,168); BACK.BITMAP_EN:=FALSE; BACK.TRANS_USED:=FALSE; BACK.BITMAP_USED:=FALSE; BACK.BMP_STYLE:=0; BACK.TRANS:=FALSE; END;
  WITH SCHEME[0].DATA[6] DO BEGIN
  NAME:='Menu Highlight';TEXT.CHNG_FONT:=FALSE; BACK_EN:=TRUE;TEXT_EN:=TRUE;TEXT.COLOR:=CLWHITE;BACK.COLOR:=CLBLACK; BACK.BITMAP_EN:=FALSE; BACK.TRANS_USED:=FALSE; BACK.BITMAP_USED:=FALSE; BACK.BMP_STYLE:=0; BACK.TRANS:=FALSE; END;
  WITH SCHEME[0].DATA[7] DO BEGIN
  NAME:='Active Title';TEXT.CHNG_FONT:=TRUE;BACK_EN:=TRUE;TEXT_EN:=TRUE;TEXT.COLOR:=CLWHITE;BACK.COLOR:=CLRED; BACK.BITMAP_EN:=FALSE; BACK.TRANS_USED:=FALSE; BACK.BITMAP_USED:=FALSE; BACK.BMP_STYLE:=0; BACK.TRANS:=FALSE; END;
  WITH SCHEME[0].DATA[8] DO BEGIN
  NAME:='Inactive Title'; TEXT.CHNG_FONT:=TRUE;BACK_EN:=TRUE;TEXT_EN:=TRUE;TEXT.COLOR:=CLBLACK;BACK.COLOR:=VALUESTORGB(204,204,168); BACK.BITMAP_EN:=FALSE; BACK.TRANS_USED:=FALSE; BACK.BITMAP_USED:=FALSE; BACK.BMP_STYLE:=0; BACK.TRANS:=FALSE; END;
  WITH SCHEME[0].DATA[9] DO BEGIN
  NAME:='Application Workspace';TEXT.CHNG_FONT:=FALSE; BACK_EN:=TRUE;TEXT_EN:=FALSE;TEXT.COLOR:=CLlime;BACK.COLOR:=CLBLACK; BACK.BITMAP_EN:=FALSE; BACK.TRANS_USED:=FALSE; BACK.BITMAP_USED:=FALSE; BACK.BMP_STYLE:=0; BACK.TRANS:=FALSE; END;
  WITH SCHEME[0].DATA[10] DO BEGIN
  NAME:='Entry Field / Listbox';TEXT.CHNG_FONT:=FALSE;BACK_EN:=TRUE;TEXT_EN:=TRUE;TEXT.COLOR:=CLBLACK;BACK.COLOR:=VALUESTORGB(204,204,168); BACK.BITMAP_EN:=FALSE; BACK.TRANS_USED:=FALSE; BACK.BITMAP_USED:=FALSE; BACK.BMP_STYLE:=0; BACK.TRANS:=FALSE; END;
  WITH SCHEME[0].DATA[11] DO BEGIN
  NAME:='Folder';TEXT.CHNG_FONT:=FALSE; BACK_EN:=TRUE; TEXT_EN:=FALSE;BACK.COLOR:=CLWHITE;BACK.BITMAP_EN:=TRUE;BACK.TRANS_USED:=FALSE;BACK.BITMAP_USED:=FALSE; BACK.BMP_STYLE:=1; BACK.TRANS:=FALSE; END;
  WITH SCHEME[0].DATA[12] DO BEGIN
  NAME:='Folder Icon';TEXT.CHNG_FONT:=TRUE;BACK_EN:=TRUE;TEXT_EN:=TRUE;TEXT.COLOR:=CLBLACK;BACK.COLOR:=VALUESTORGB(204,204,168);BACK.BITMAP_EN:=FALSE; BACK.TRANS_USED:=TRUE; BACK.BITMAP_USED:=FALSE; BACK.BMP_STYLE:=0; BACK.TRANS:=FALSE; END;
  WITH SCHEME[0].DATA[13] DO BEGIN
  NAME:='Folder Shadow Icon';TEXT.CHNG_FONT:=TRUE;BACK_EN:=TRUE; TEXT_EN:=TRUE;TEXT.COLOR:=CLBLACK;BACK.COLOR:=VALUESTORGB(204,204,168);BACK.BITMAP_EN:=FALSE; BACK.TRANS_USED:=TRUE; BACK.BITMAP_USED:=FALSE; BACK.BMP_STYLE:=0; BACK.TRANS:=FALSE; END;
  WITH SCHEME[0].DATA[14] DO BEGIN
  NAME:='Help Panel';TEXT.CHNG_FONT:=FALSE;BACK_EN:=TRUE;TEXT_EN:=TRUE;TEXT.COLOR:=CLBLACK;BACK.COLOR:=VALUESTORGB(204,204,168);BACK.BITMAP_EN:=FALSE; BACK.TRANS_USED:=FALSE; BACK.BITMAP_USED:=FALSE; BACK.BMP_STYLE:=0; BACK.TRANS:=FALSE; END;
  WITH SCHEME[0].DATA[15] DO BEGIN
  NAME:='Button';TEXT.CHNG_FONT:=FALSE;BACK_EN:=TRUE; TEXT_EN:=TRUE;TEXT.COLOR:=CLBLACK;BACK.COLOR:=CLBLUE;BACK.BITMAP_EN:=FALSE;BACK.TRANS_USED:=FALSE; BACK.BITMAP_USED:=FALSE; BACK.BMP_STYLE:=0; BACK.TRANS:=FALSE; END;
  WITH SCHEME[0].DATA[16] DO BEGIN
  NAME:='Selection Highlight';TEXT.CHNG_FONT:=FALSE;BACK_EN:=TRUE; TEXT_EN:=TRUE;  TEXT.COLOR:=CLBLACK;BACK.COLOR:=VALUESTORGB(204,204,168);BACK.BITMAP_EN:=FALSE;  BACK.TRANS_USED:=FALSE; BACK.BITMAP_USED:=FALSE; BACK.BMP_STYLE:=0; BACK.TRANS:=FALSE; END;
  WITH SCHEME[0].DATA[17] DO BEGIN
  NAME:='Help Linked text';TEXT.CHNG_FONT:=FALSE;TEXT_EN:=TRUE;TEXT.COLOR:=CLyellow;BACK.BITMAP_EN:=FALSE;BACK.TRANS_USED:=FALSE; BACK.BITMAP_USED:=FALSE; BACK.BMP_STYLE:=0; BACK.TRANS:=FALSE; END;
END;

FUNCTION CHECKREG2:STRING;
VAR FULLNAMEREV,GENCODE:STRING='';
VAR GUNKINT1,GUNKINT2,GUNKINT3,GUNKINT4,GUNKINT5,GUNKINT6,GUNKINT7,NAMELEN,LEN,GUNKINT10,GUNKINT11:INTEGER;
VAR FNAME:ARRAY [0..25] OF CHAR;
VAR FNAMEN:ARRAY [1..25] OF INTEGER;
BEGIN
     RESULT:='';
     FOR GUNKINT1:=1 TO LENGTH(FULLNAME) DO FULLNAMEREV:=FULLNAMEREV+SUBSTR(FULLNAME,LENGTH(FULLNAME)+1-GUNKINT1,1);     //REVERSE THE NAME
     NAMELEN:=LENGTH(FULLNAME);
     FOR GUNKINT1:=1 TO NAMELEN DO BEGIN
         FNAME[GUNKINT1]:=FULLNAMEREV[GUNKINT1];
         IF (GUNKINT1>0) & (GUNKINT1<4) THEN GUNKINT2:=1;
         IF (GUNKINT1>4) & (GUNKINT1<8) THEN GUNKINT2:=5;
         IF (GUNKINT1>8) & (GUNKINT1<12) THEN GUNKINT2:=8;
         IF (GUNKINT1>12) & (GUNKINT1<16) THEN GUNKINT2:=3;
         IF (GUNKINT1>16) & (GUNKINT1<20) THEN GUNKINT2:=7;
         FNAMEN[GUNKINT1]:=(ORD(FNAME[GUNKINT1]))+GUNKINT2;
         LEN:=LENGTH(TOSTR(FNAMEN[GUNKINT1]));
         VAL((SUBSTR(TOSTR(FNAMEN[GUNKINT1]),LEN,1)),FNAMEN[GUNKINT1],GUNKINT4);
         IF (GUNKINT1=4) | (GUNKINT1=8) | (GUNKINT1=12) | (GUNKINT1=16) THEN FOR GUNKINT3:=1 TO 4 DO FNAMEN[GUNKINT1]:=RANDOM(9);
     END;
     FOR GUNKINT3:=GUNKINT1 TO 20 DO FNAMEN[GUNKINT3]:=RANDOM(9);
     FOR GUNKINT2:=1 TO 22 DO BEGIN
         FNAMEN[21]:=((FNAMEN[4])+(FNAMEN[8])+(FNAMEN[12])+(FNAMEN[16])+(FNAMEN[20]));
         VAL((SUBSTR(TOSTR(FNAMEN[21]),2,1)),FNAMEN[22],GUNKINT4);
         VAL((SUBSTR(TOSTR(FNAMEN[21]),1,1)),FNAMEN[21],GUNKINT4);
         GENCODE:=GENCODE+TOSTR(FNAMEN[GUNKINT2]);
     END;
     GENCODE:=SUBSTR(GENCODE,1,NAMELEN);
     RESULT:='Yes';

     IF LENGTH(FULLNAME)=0 THEN RESULT:='No';

     IF (SUBSTR(GENCODE,1,3)<>SUBSTR(REGCODE,1,3)) AND (LENGTH(FULLNAME)>3) THEN RESULT:='No';
     IF (SUBSTR(GENCODE,5,3)<>SUBSTR(REGCODE,5,3)) AND (LENGTH(FULLNAME)>8) THEN RESULT:='No';
     IF (SUBSTR(GENCODE,9,3)<>SUBSTR(REGCODE,9,3)) AND (LENGTH(FULLNAME)>12) THEN RESULT:='No';
     IF (SUBSTR(GENCODE,13,3)<>SUBSTR(REGCODE,13,3)) AND (LENGTH(FULLNAME)>16) THEN RESULT:='No';
     IF (SUBSTR(GENCODE,17,3)<>SUBSTR(REGCODE,17,3)) AND (LENGTH(FULLNAME)>20) THEN RESULT:='No';

     VAL(SUBSTR(REGCODE,4,1),GUNKINT1,GUNKINT2);
     VAL(SUBSTR(REGCODE,8,1),GUNKINT3,GUNKINT2);
     VAL(SUBSTR(REGCODE,12,1),GUNKINT4,GUNKINT2);
     VAL(SUBSTR(REGCODE,16,1),GUNKINT5,GUNKINT2);
     VAL(SUBSTR(REGCODE,20,1),GUNKINT6,GUNKINT2);
     VAL(SUBSTR(REGCODE,21,2),GUNKINT7,GUNKINT2);
     IF GUNKINT7<>GUNKINT1+GUNKINT5+GUNKINT3+GUNKINT4+GUNKINT6 THEN RESULT:='No';
END;

FUNCTION INIT:BYTE;
VAR rc:longint;
    GUNKCHAR1:CHAR;
    NUMERICBOOTDRIVE:longint;
BEGIN
  //GET THE BOOTDRIVE
  RC:=DOSQUERYSYSINFO(QSV_BOOT_DRIVE,QSV_BOOT_DRIVE,GUNKCHAR1,50);  NUMERICBOOTDRIVE:=ORD(GUNKCHAR1);  BOOTDRIVE:=CHR(NUMERICBOOTDRIVE+ORD('A')-1)+':';

  //INITIALISE THE VARIABLES
  UPDATE_TEST:=0;               //CLEARS THE COUNTER USED TO COUNT THE NUMBER OF SCREEN UPDATES PER PROPERTY CHANGE
  startup:=TRUE;                //TELLS THE UPDATE ROUTINE TO NOT UPDATE DURING STARTUP
  SILENT:=FALSE;
  LASTPROPERTYNO:=1;
  DEBUG_WIN_SIZE:=0;
  WINDOW_CTRL_UPDATES:=0;

  //GET THE CURRENT FOLDER
  GETDIR(0,CURDIR);
  IF POS('\',CURDIR)=LENGTH(CURDIR) THEN CURDIR:=COPY(CURDIR,1,LENGTH(CURDIR)-1);  //GET THE CURRENT DIRECTORY AND STRIP THE LAST \ IF FOUND
END;

FUNCTION GET_REG_KEY:BYTE;
VAR
  GUNKCSTR1:cstring;
BEGIN
  DE_INI_HANDLE:=PRFOPENPROFILE(AHAB,BOOTDRIVE+DE_INI_LOCATION);
  GUNKCSTR1:='';
  PRFQUERYPROFILESTRING(DE_INI_HANDLE,'Dialog_Enhancer','RegName',NIL,GUNKCSTR1,SIZEOF(GUNKCSTR1));
  FULLNAME:=GUNKCSTR1;
  IF FULLNAME<>'' THEN BEGIN
    PRFQUERYPROFILESTRING(DE_INI_HANDLE,'Dialog_Enhancer','RegKey',NIL,GUNKCSTR1,SIZEOF(GUNKCSTR1));
    IF GUNKCSTR1<>'' THEN REGCODE:=GUNKCSTR1;
  END;
END;

FUNCTION TCOLORTORGBSTRING(COLOUR:TCOLOR):STRING;
VAR R,G,B:BYTE;
BEGIN
  rgbtovalues(COLOUR,R,G,B);
  IF R>254 THEN R:=254; IF R<1 THEN R:=1;
  IF G>254 THEN G:=254; IF G<1 THEN G:=1;
  IF B>254 THEN B:=254; IF B<1 THEN B:=1;

  RESULT:=CHR(B)+CHR(G)+CHR(R);             //? ? R
END;

FUNCTION DARK(COLOUR:TCOLOR):TCOLOR;
VAR R,G,B,RN,GN,BN:BYTE;
BEGIN
  RGBTOVALUES(COLOUR,R,G,B);
  IF R<30 THEN RN:=30;
  IF G<30 THEN GN:=30;
  IF B<30 THEN BN:=30;
  RESULT:=valuestorgb(R-30,G-30,B-30);
END;

FUNCTION EXDARK(COLOUR:TCOLOR):TCOLOR;
VAR R,G,B,RN,GN,BN:BYTE;
BEGIN
  RGBTOVALUES(COLOUR,R,G,B);
  IF R<60 THEN RN:=60;
  IF G<60 THEN GN:=60;
  IF B<60 THEN BN:=60;
  RESULT:=valuestorgb(R-60,G-60,B-60);
END;

FUNCTION LIGHT(COLOUR:TCOLOR):TCOLOR;
VAR R,G,B,RN,GN,BN:BYTE;
BEGIN
  RGBTOVALUES(COLOUR,R,G,B);
  IF R+30>255 THEN RN:=255-30;
  IF G+30>255 THEN GN:=255-30;
  IF B+30>255 THEN BN:=255-30;
  RESULT:=valuestorgb(R+30,G+30,B+30);
END;

FUNCTION EXLIGHT(COLOUR:TCOLOR):TCOLOR;
VAR R,G,B,RN,GN,BN:BYTE;
BEGIN
  RGBTOVALUES(COLOUR,R,G,B);
  IF R+60>255 THEN RESULT:=CLWHITE
  ELSE IF G+60>255 THEN RESULT:=CLWHITE
  ELSE IF B+60>255 THEN RESULT:=CLWHITE
  ELSE RESULT:=valuestorgb(R+60,G+60,B+60);
END;



Initialization
End.
