#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2025 tyzef <stefan@tyzef.infini.fr>

set -o errexit

###
# Flatout
# send your bug reports to bugs@dotslashplay.it
###

script_version=20250331.1

PLAYIT_COMPATIBILITY_LEVEL='2.32'

GAME_ID='flatout'
GAME_NAME='FlatOut'

#ARCHIVE_BASE_2_NAME='flatout_2_gog_3_23461.sh'
#ARCHIVE_BASE_2_MD5='5529dcd679eae03f23d9807efd22a182'
#ARCHIVE_BASE_2_SIZE='3800000'
#ARCHIVE_BASE_2_VERSION='1.2-gog23461'
#ARCHIVE_BASE_2_URL='https://www.gog.com/game/flatout_2'

#ARCHIVE_BASE_1_NAME='gog_flatout_2_2.1.0.6.sh'
#ARCHIVE_BASE_1_MD5='77cbd07105aa202ef808edebda15833a'
#ARCHIVE_BASE_1_SIZE='3400000'
#ARCHIVE_BASE_1_VERSION='1.2-gog2.1.0.6'

ARCHIVE_BASE_0_NAME='flatout.exe'
ARCHIVE_BASE_0_MD5='7704c0100400d767b1c2b01073534382'
ARCHIVE_BASE_0_TYPE='innosetup'
ARCHIVE_BASE_0_SIZE='3489772'
#ARCHIVE_BASE_0_VERSION='1.2-gog2.0.0.4'
ARCHIVE_BASE_2_URL='https://www.gog.com/en/game/flatout'

CONTENT_PATH_DEFAULT='app'
CONTENT_GAME_BIN_FILES='
flatout.exe
*.dll'
CONTENT_GAME_DATA_FILES='
data'
#filesystem
#patch
#flatout2.ico
#*.bfs'
#CONTENT_DOC_DATA_FILES='
#readme.htm
#*.pdf'

#USER_PERSISTENT_DIRECTORIES='
#savegame'

## TODO: Check if this winetricks verb is required.
WINE_WINETRICKS_VERBS='d3dx9'

APP_MAIN_EXE='flatout.exe'
#APP_MAIN_ICON='goggame-1207658693.ico'

PACKAGES_LIST='
PKG_BIN
PKG_DATA'

PKG_DATA_ID="${GAME_ID}-data"
PKG_DATA_DESCRIPTION='data'

PKG_BIN_ARCH='32'

# Load common functions

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
# shellcheck source=libplayit2.sh
. "$PLAYIT_LIB2"

# Run the default initialization actions

initialization_default "$@"

# Extract game data

archive_extraction_default
(
	cd "${PLAYIT_WORKDIR}/gamedata/$(content_path_default)"

	## Convert file paths to lower case.
	tolower .
)

# Include game data

set_current_package 'PKG_DATA'
# shellcheck disable=SC2119
icons_inclusion
content_inclusion_default

# Write launchers

set_current_package 'PKG_BIN'
# shellcheck disable=SC2119
launchers_write

# Build packages

packages_generation
print_instructions

# Clean up

rm --recursive "$PLAYIT_WORKDIR"

exit 0