# frozen_string_literal: true

describe CMSScanner::Vulnerability do
  subject(:vuln)   { described_class.new(title, references: references, cvss: cvss) }
  let(:title)      { 'Test Vuln' }
  let(:references) { {} }
  let(:cvss)       { nil }

  it_behaves_like CMSScanner::References

  describe '#new' do
    its(:title)         { should eql title }
    its(:references)    { should eql({}) }
    its(:type)          { should eql nil }
    its(:fixed_in)      { should eql nil }
    its(:introduced_in) { should eql nil }
    its(:cvss)          { should eql nil }

    context 'when CVSS' do
      let(:cvss) { { score: '5.4', vector: 'spec', y: 'key should not be added' } }

      its(:cvss) { should eql({ score: '5.4', vector: 'spec' }) }
    end
  end

  describe '#==' do
    context 'when the same vuln' do
      let(:cvss) { { score: '5.4', vector: 'spec' } }

      it 'returns true' do
        expect(vuln).to eq vuln.dup
      end
    end

    context 'when not equal' do
      it 'returns false' do
        expect(vuln).to_not eq described_class.new('not eq')
      end
    end
  end
end
