#!/usr/bin/env python

import re,sys

try:
    maketrans = str.maketrans
except AttributeError:
    # For python2
    from string import maketrans

pats = [
 [ r"__InClUdE__(.*)", r"#include\1" ],
 [ r"__IfDeF__ (XEN_HAVE.*)", r"#ifdef \1" ],
 [ r"__ElSe__", r"#else" ],
 [ r"__EnDif__", r"#endif" ],
 [ r"__DeFiNe__", r"#define" ],
 [ r"__UnDeF__", r"#undef" ],
 [ r"\"xen-compat.h\"", r"<public/xen-compat.h>" ],
 [ r"(struct|union|enum)\s+(xen_?)?(\w)", r"\1 compat_\3" ],
 [ r"typedef(.*)@KeeP@((xen_?)?)([\w]+)([^\w])",
   r"typedef\1\2\4 __attribute__((__aligned__(__alignof(\1compat_\4))))\5" ],
 [ r"_t([^\w]|$)", r"_compat_t\1" ],
 [ r"int(8|16|32|64_aligned)_compat_t([^\w]|$)", r"int\1_t\2" ],
 [ r"(\su?int64(_compat)?)_T([^\w]|$)", r"\1_t\3" ],
 [ r"(^|[^\w])xen_?(\w*)_compat_t([^\w]|$$)", r"\1compat_\2_t\3" ],
 [ r"(^|[^\w])XEN_?", r"\1COMPAT_" ],
 [ r"(^|[^\w])Xen_?", r"\1Compat_" ],
 [ r"(^|[^\w])COMPAT_HANDLE_64\(", r"\1XEN_GUEST_HANDLE_64(" ],
 [ r"(^|[^\w])long([^\w]|$$)", r"\1int\2" ]
];

output_filename = sys.argv[1]

# tr '[:lower:]-/.' '[:upper:]___'
header_id = '_' + \
    output_filename.upper().translate(maketrans('-/.','___'))

header = """#ifndef {0}
#define {0}
#include <xen/compat.h>""".format(header_id)

print(header)

if not re.match("compat/arch-.*.h$", output_filename):
    x = output_filename.replace("compat/","public/")
    print('#include <%s>' % x)

last_line_empty = False
for line in sys.stdin.readlines():
    line = line.rstrip()

    # Remove linemarkers generated by the preprocessor.
    if re.match(r"^# \d", line):
        continue

    # De-duplicate empty lines.
    if len(line) == 0:
        if not last_line_empty:
            print(line)
            last_line_empty = True
        continue
    else:
        last_line_empty = False

    for pat in pats:
        line = re.sub(pat[0], pat[1], line)
    print(line)

print("#endif /* %s */" % header_id)
