/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.viper.model;

import com.nvidia.viper.MathUtil;
import com.nvidia.viper.StringUtils;
import com.nvidia.viper.ViperException;
import com.nvidia.viper.activity.CuptiActivityKernel;
import com.nvidia.viper.activity.ICuptiActivity;
import com.nvidia.viper.analysis.AnalysisScope;
import com.nvidia.viper.model.Analysis;
import com.nvidia.viper.model.ITimelineInterval;
import com.nvidia.viper.model.ProfileDataModel;
import com.nvidia.viper.model.Session;
import com.nvidia.viper.model.Timeline;
import com.nvidia.viper.model.TimelineContext;
import com.nvidia.viper.model.TimelineDevice;
import com.nvidia.viper.model.TimelineIntervalKernel;
import com.nvidia.viper.model.TimelineKind;
import com.nvidia.viper.model.TimelineStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SessionFilter
implements Serializable {
    private static final long serialVersionUID = 8505004806061039004L;
    private Integer deviceId;
    private String contextName;
    private Integer contextId;
    private String streamName;
    private Integer streamId;
    private String kernelName;
    private int kernelInstanceCount;

    public SessionFilter(Session session, Analysis analysis) throws ViperException {
        this(analysis != null ? analysis.getActiveScopeInterval() : null, session);
    }

    public SessionFilter(ITimelineInterval analysisScopeInterval, Session session) throws ViperException {
        TimelineContext contextTl;
        TimelineDevice deviceTl;
        TimelineIntervalKernel kernel;
        Timeline kernelTl;
        if (AnalysisScope.KERNEL_INSTANCE.isEnabled(analysisScopeInterval) && (kernelTl = (kernel = (TimelineIntervalKernel)analysisScopeInterval).getPrimaryTimeline()) != null && (deviceTl = (TimelineDevice)kernelTl.getAncestor(TimelineKind.DEVICE)) != null && (contextTl = (TimelineContext)kernelTl.getAncestor(TimelineKind.CONTEXT)) != null) {
            int streamId = kernel.getStreamId();
            List<Timeline> streamTls = contextTl.getDescendants(TimelineKind.STREAM);
            TimelineStream streamTl = null;
            for (Timeline tl : streamTls) {
                if (((TimelineStream)tl).getId() != streamId) continue;
                streamTl = (TimelineStream)tl;
                break;
            }
            if (streamTl != null) {
                String kernelName = kernel.getName();
                int instanceCount = -1;
                int i = 0;
                while (i < streamTl.getIntervalIds().length) {
                    ICuptiActivity activity = session.getActivity(streamTl.getIntervalIds()[i]);
                    if (activity instanceof CuptiActivityKernel) {
                        CuptiActivityKernel kernelActivity = (CuptiActivityKernel)activity;
                        if (kernelName.equals(kernelActivity.name)) {
                            ++instanceCount;
                        }
                        if (streamTl.getIntervalIds()[i] == kernel.getID()) break;
                    }
                    ++i;
                }
                if (instanceCount >= 0) {
                    this.deviceId = deviceTl.getId();
                    this.contextId = contextTl.getId();
                    this.contextName = contextTl.getCustomName();
                    this.streamId = streamTl.getId();
                    this.streamName = streamTl.getCustomName();
                    this.kernelName = kernelName;
                    this.kernelInstanceCount = instanceCount + 1;
                    return;
                }
            }
        }
        throw new ViperException("analysis scope does not specify single kernel instance");
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof SessionFilter) {
            SessionFilter filter = (SessionFilter)obj;
            return MathUtil.equals(filter.deviceId, this.deviceId) && MathUtil.equals(filter.contextId, this.contextId) && StringUtils.equals(filter.contextName, this.contextName) && MathUtil.equals(filter.streamId, this.streamId) && StringUtils.equals(filter.streamName, this.streamName) && StringUtils.equals(filter.kernelName, this.kernelName) && filter.kernelInstanceCount == this.kernelInstanceCount;
        }
        return false;
    }

    public SessionFilter(Object context, Object stream, Object kernel, Object invocation) {
        if (context != null) {
            if (context instanceof String) {
                this.contextName = (String)context;
            } else if (context instanceof Integer) {
                this.contextId = (Integer)context;
            }
        }
        if (stream != null) {
            if (stream instanceof String) {
                this.streamName = (String)stream;
            } else if (stream instanceof Integer) {
                this.streamId = (Integer)stream;
            }
        }
        if (kernel != null && kernel instanceof String) {
            this.kernelName = (String)kernel;
        }
        this.kernelInstanceCount = invocation != null && invocation instanceof Integer ? (Integer)invocation : 0;
    }

    public Integer getDeviceId() {
        return this.deviceId;
    }

    public Integer getContextId() {
        if (this.contextName != null) {
            return null;
        }
        return this.contextId;
    }

    public String getContextName() {
        return this.contextName;
    }

    public Integer getStreamId() {
        if (this.streamName != null) {
            return null;
        }
        return this.streamId;
    }

    public String getStreamName() {
        return this.streamName;
    }

    public String getKernelName() {
        return this.kernelName;
    }

    public int getKernelInstanceCount() {
        return this.kernelInstanceCount;
    }

    public boolean isSingleKernelInstance() {
        return !(this.deviceId == null || this.contextId == null && this.contextName == null || this.streamId == null && this.streamName == null || this.kernelName == null || this.kernelInstanceCount < 0);
    }

    public boolean isMultipleKernelsInstance() {
        if (!this.isSingleKernelInstance()) {
            return this.contextId != null || this.contextName != null || this.streamId != null || this.streamName != null || this.kernelName != null || this.kernelInstanceCount > 0;
        }
        return false;
    }

    private TimelineContext getContextTimeline(List<Timeline> tls) {
        for (Timeline tl : tls) {
            if (!(tl instanceof TimelineContext) || (this.contextName == null || !this.contextName.equals(tl.getCustomName())) && (this.contextName != null || ((TimelineContext)tl).getId() != this.contextId.intValue())) continue;
            return (TimelineContext)tl;
        }
        return null;
    }

    private List<TimelineIntervalKernel> getKernelIntervals(Session session, List<TimelineContext> contextTLs, boolean matchStreamName, boolean matchStreamId, boolean matchKernelName, boolean matchSubstring, boolean matchKernelInstance) {
        List<CuptiActivityKernel> kernels = this.getKernelActivities(session, null, contextTLs, null, matchStreamName, matchStreamId, matchKernelName, matchSubstring, matchKernelInstance);
        ArrayList<TimelineIntervalKernel> kernelIntervals = new ArrayList<TimelineIntervalKernel>();
        if (session != null) {
            for (CuptiActivityKernel kernel : kernels) {
                kernelIntervals.add((TimelineIntervalKernel)session.loadInterval(kernel.getID(), true));
            }
        }
        return kernelIntervals;
    }

    private List<CuptiActivityKernel> getKernelActivities(Session session, ProfileDataModel pdm, List<TimelineContext> contextTLs, Map<Timeline, List<Timeline>> contextStreamMap, boolean matchStreamName, boolean matchStreamId, boolean matchKernelName, boolean matchSubstring, boolean matchKernelInstance) {
        int foundInstanceCount = 0;
        ArrayList<CuptiActivityKernel> kernels = new ArrayList<CuptiActivityKernel>();
        HashMap<String, Integer> kernelInstanceMap = new HashMap<String, Integer>();
        for (TimelineContext contextTL : contextTLs) {
            List<Timeline> streamTLs = contextStreamMap != null && contextStreamMap.containsKey(contextTL) ? contextStreamMap.get(contextTL) : contextTL.getDescendants(TimelineKind.STREAM);
            block1: for (Timeline streamTL : streamTLs) {
                if (!(streamTL instanceof TimelineStream) || (matchStreamName ? !this.streamName.equals(streamTL.getCustomName()) : matchStreamId && ((TimelineStream)streamTL).getId() != this.streamId.intValue())) continue;
                long[] lArray = streamTL.getIntervalIds();
                int n = lArray.length;
                int n2 = 0;
                while (n2 < n) {
                    ICuptiActivity activity;
                    long intervalId = lArray[n2];
                    ICuptiActivity iCuptiActivity = activity = pdm != null ? pdm.getActivity(intervalId) : session.getActivity(intervalId);
                    if (activity instanceof CuptiActivityKernel) {
                        CuptiActivityKernel kernel = (CuptiActivityKernel)activity;
                        if (matchKernelName && matchKernelInstance) {
                            if (matchSubstring && kernel.name.contains(this.kernelName) || this.kernelName.equals(kernel.name)) {
                                ++foundInstanceCount;
                            }
                            if (foundInstanceCount == this.kernelInstanceCount) {
                                kernels.add(kernel);
                                continue block1;
                            }
                        } else if (matchKernelName) {
                            if (matchSubstring && kernel.name.contains(this.kernelName) || this.kernelName.equals(kernel.name)) {
                                kernels.add(kernel);
                            }
                        } else if (matchKernelInstance) {
                            Integer instanceCount = (Integer)kernelInstanceMap.get(kernel.name);
                            instanceCount = instanceCount == null ? Integer.valueOf(1) : Integer.valueOf(instanceCount + 1);
                            if (instanceCount == this.kernelInstanceCount) {
                                kernels.add(kernel);
                            }
                            kernelInstanceMap.put(kernel.name, 1);
                        } else {
                            kernels.add(kernel);
                        }
                    }
                    ++n2;
                }
            }
        }
        kernelInstanceMap.clear();
        return kernels;
    }

    public TimelineIntervalKernel getSingleKernelInstance(Session session) {
        if (!this.isSingleKernelInstance()) {
            return null;
        }
        List<Timeline> deviceTls = session.getTimelines(TimelineKind.DEVICE);
        Timeline deviceTl = null;
        for (Timeline tl : deviceTls) {
            if (((TimelineDevice)tl).getId() != this.deviceId.intValue()) continue;
            deviceTl = (TimelineDevice)tl;
            break;
        }
        if (deviceTl == null) {
            return null;
        }
        List<Timeline> contextTls = deviceTl.getDescendants(TimelineKind.CONTEXT);
        TimelineContext contextTl = this.getContextTimeline(contextTls);
        if (contextTl == null) {
            return null;
        }
        List<TimelineIntervalKernel> kernelIntervals = this.getKernelIntervals(session, Arrays.asList(contextTl), this.streamName != null, this.streamId != null, true, false, true);
        if (kernelIntervals != null && !kernelIntervals.isEmpty()) {
            return kernelIntervals.get(0);
        }
        return null;
    }

    private List<TimelineIntervalKernel> getMultipleKernelsInstance(Session session) {
        if (!this.isMultipleKernelsInstance()) {
            return null;
        }
        List<Timeline> tls = session.getTimelines(TimelineKind.CONTEXT);
        ArrayList<TimelineContext> contextTLs = new ArrayList<TimelineContext>();
        if (this.contextId != null || this.contextName != null) {
            TimelineContext contextTL = this.getContextTimeline(tls);
            if (contextTL == null) {
                return null;
            }
            contextTLs.add(contextTL);
        } else {
            for (Timeline tl : tls) {
                if (!(tl instanceof TimelineContext)) continue;
                contextTLs.add((TimelineContext)tl);
            }
        }
        List<TimelineIntervalKernel> scopeKernelIntervals = this.getKernelIntervals(session, contextTLs, this.streamName != null, this.streamId != null, this.kernelName != null, true, this.kernelInstanceCount > 0);
        return scopeKernelIntervals;
    }

    public List<TimelineIntervalKernel> getMultipleKernelsInstance(Session session, Timeline sessionStream) {
        if (!(sessionStream instanceof TimelineStream)) {
            return null;
        }
        List<TimelineIntervalKernel> kernelIntervals = this.getMultipleKernelsInstance(session);
        ArrayList<TimelineIntervalKernel> sessionKernelIntervals = new ArrayList<TimelineIntervalKernel>();
        for (TimelineIntervalKernel kernelInterval : kernelIntervals) {
            if (!kernelInterval.getStreamName().equals(((TimelineStream)sessionStream).getDisplayName(true))) continue;
            sessionKernelIntervals.add(kernelInterval);
        }
        Collections.sort(sessionKernelIntervals, new Comparator<TimelineIntervalKernel>(){

            @Override
            public int compare(TimelineIntervalKernel kernel1, TimelineIntervalKernel kernel2) {
                if (kernel1.start < kernel2.start) {
                    return -1;
                }
                if (kernel1.start == kernel2.start) {
                    return 0;
                }
                return 1;
            }
        });
        return sessionKernelIntervals;
    }

    public List<CuptiActivityKernel> getMultipleKernelActivities(ProfileDataModel pdm, Map<Timeline, List<Timeline>> contextStreamMap, Timeline stream) {
        ArrayList<Timeline> pdmContextTls = new ArrayList<Timeline>();
        pdmContextTls.addAll(contextStreamMap.keySet());
        ArrayList<TimelineContext> contextTLs = new ArrayList<TimelineContext>();
        if (!(stream instanceof TimelineStream)) {
            return null;
        }
        if (this.contextId != null || this.contextName != null) {
            TimelineContext contextTL = this.getContextTimeline(pdmContextTls);
            if (contextTL == null) {
                return null;
            }
            contextTLs.add(contextTL);
        } else {
            for (Timeline tl : pdmContextTls) {
                if (!(tl instanceof TimelineContext)) continue;
                contextTLs.add((TimelineContext)tl);
            }
        }
        List<CuptiActivityKernel> kernels = this.getKernelActivities(null, pdm, contextTLs, contextStreamMap, this.streamName != null, this.streamId != null, this.kernelName != null, true, this.kernelInstanceCount > 0);
        ArrayList<CuptiActivityKernel> streamKernels = new ArrayList<CuptiActivityKernel>();
        for (CuptiActivityKernel kernel : kernels) {
            if (kernel.streamId != ((TimelineStream)stream).getId()) continue;
            streamKernels.add(kernel);
        }
        kernels.clear();
        Collections.sort(streamKernels, new Comparator<CuptiActivityKernel>(){

            @Override
            public int compare(CuptiActivityKernel kernel1, CuptiActivityKernel kernel2) {
                if (kernel1.start < kernel2.start) {
                    return -1;
                }
                if (kernel1.start == kernel2.start) {
                    return 0;
                }
                return 1;
            }
        });
        return streamKernels;
    }

    public String getNvprofCommandLine() {
        StringBuilder args = new StringBuilder(" --kernels \"");
        if (this.getContextId() != null) {
            args.append(this.getContextId());
        } else {
            args.append(this.getContextName());
        }
        args.append(":");
        if (this.getStreamId() != null) {
            args.append(this.getStreamId());
        } else {
            args.append(this.getStreamName());
        }
        args.append(":").append(this.getKernelName());
        args.append(":").append(this.getKernelInstanceCount()).append("\"");
        return args.toString();
    }

    public String getRebelCommandLine() {
        StringBuilder args = new StringBuilder(" -f ");
        args.append(" --kernel-name-base mangled");
        String kernelId = String.format(" --kernel-id %d:%d:%s:%d ", this.contextId, this.streamId, this.kernelName, this.kernelInstanceCount);
        args.append(kernelId);
        return args.toString();
    }
}

