/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.actions;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import org.eclipse.cdt.internal.ui.actions.ActionMessages;
import org.eclipse.cdt.internal.ui.util.SelectionUtil;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.osgi.util.TextProcessor;
import org.eclipse.swt.SWTError;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.part.ViewPart;

public class CopyTreeAction
extends Action {
    private static final char INDENTATION = '\t';
    private ViewPart fView;
    private TreeViewer fViewer;

    public CopyTreeAction(String label, ViewPart view, TreeViewer viewer) {
        super(label);
        this.fView = view;
        this.fViewer = viewer;
    }

    public boolean canActionBeAdded() {
        Object element = SelectionUtil.getSingleElement(this.getSelection());
        return element != null;
    }

    private ISelection getSelection() {
        ISelectionProvider provider = this.fView.getSite().getSelectionProvider();
        if (provider != null) {
            return provider.getSelection();
        }
        return null;
    }

    public void run() {
        StringBuilder buf = new StringBuilder();
        this.addChildren(this.fViewer.getTree().getSelection()[0], 0, buf);
        TextTransfer plainTextTransfer = TextTransfer.getInstance();
        Clipboard clipboard = new Clipboard(this.fView.getSite().getShell().getDisplay());
        try {
            try {
                clipboard.setContents((Object[])new String[]{CopyTreeAction.convertLineTerminators(buf.toString())}, new Transfer[]{plainTextTransfer});
            }
            catch (SWTError e) {
                if (e.code != 2002) {
                    throw e;
                }
                if (MessageDialog.openQuestion((Shell)this.fView.getViewSite().getShell(), (String)ActionMessages.CopyTreeAction_problem, (String)ActionMessages.CopyTreeAction_clipboard_busy)) {
                    this.run();
                }
                clipboard.dispose();
            }
        }
        finally {
            clipboard.dispose();
        }
    }

    private void addChildren(TreeItem item, int indent, StringBuilder buf) {
        int i = 0;
        while (i < indent) {
            buf.append('\t');
            ++i;
        }
        buf.append(TextProcessor.deprocess((String)item.getText()));
        buf.append('\n');
        if (item.getExpanded()) {
            TreeItem[] items;
            TreeItem[] treeItemArray = items = item.getItems();
            int n = items.length;
            int n2 = 0;
            while (n2 < n) {
                TreeItem item2 = treeItemArray[n2];
                this.addChildren(item2, indent + 1, buf);
                ++n2;
            }
        }
    }

    static String convertLineTerminators(String in) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        StringReader stringReader = new StringReader(in);
        BufferedReader bufferedReader = new BufferedReader(stringReader);
        try {
            String line = bufferedReader.readLine();
            while (line != null) {
                printWriter.print(line);
                line = bufferedReader.readLine();
                if (line == null || line.length() == 0) continue;
                printWriter.println();
            }
        }
        catch (IOException iOException) {
            return in;
        }
        return stringWriter.toString();
    }
}

