/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.refactoring;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.index.IIndex;
import org.eclipse.cdt.core.parser.util.CharArrayUtils;
import org.eclipse.cdt.internal.ui.refactoring.IndexToASTNameHelper;

class BindingToAstNameMatcher
extends ASTVisitor {
    private List<IASTName> results = new ArrayList<IASTName>();
    private IBinding bindingToFind;
    private char[] toFindName;
    private IIndex index;

    public BindingToAstNameMatcher(IBinding binding, IIndex index) {
        super(true);
        this.bindingToFind = index.adaptBinding(binding);
        this.index = index;
        this.toFindName = binding.getNameCharArray();
        this.shouldVisitImplicitNames = true;
        this.shouldVisitImplicitNameAlternates = true;
    }

    public int visit(IASTName candidate) {
        if (!IndexToASTNameHelper.shouldConsiderName(candidate)) {
            return 3;
        }
        if (this.isEquivalent(candidate)) {
            this.results.add(candidate);
        }
        return 3;
    }

    private boolean isEquivalent(IASTName candidate) {
        return CharArrayUtils.equals((char[])candidate.getSimpleID(), (char[])this.toFindName) && this.bindingToFind.equals(this.index.adaptBinding(candidate.resolveBinding()));
    }

    public List<IASTName> getMatches() {
        return this.results;
    }
}

