/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.internal.ui.actions;

import java.util.ArrayList;
import org.eclipse.rse.core.RSECorePlugin;
import org.eclipse.rse.core.model.IHost;
import org.eclipse.rse.core.model.ISystemRegistry;
import org.eclipse.rse.core.subsystems.ISubSystem;
import org.eclipse.rse.internal.ui.SystemResources;
import org.eclipse.rse.ui.actions.SystemBaseAction;
import org.eclipse.swt.widgets.Shell;

public class SystemDisconnectAllSubSystemsAction
extends SystemBaseAction {
    private ISystemRegistry sr = null;

    public SystemDisconnectAllSubSystemsAction(Shell shell) {
        super(SystemResources.ACTION_DISCONNECTALLSUBSYSTEMS_LABEL, SystemResources.ACTION_DISCONNECTALLSUBSYSTEMS_TOOLTIP, shell);
        this.allowOnMultipleSelection(true);
        this.setContextMenuGroup("group.connection");
        this.sr = RSECorePlugin.getTheSystemRegistry();
    }

    private static ISubSystem[] getDisconnectableSubsystems(Object element) {
        ISubSystem[] result = null;
        if (element instanceof IHost) {
            IHost host = (IHost)element;
            ISystemRegistry sr = RSECorePlugin.getTheSystemRegistry();
            ISubSystem[] ss = sr.getSubSystems(host);
            ArrayList<ISubSystem> l = new ArrayList<ISubSystem>();
            int i = 0;
            while (i < ss.length) {
                if (ss[i].isConnected() && ss[i].getSubSystemConfiguration().supportsSubSystemConnect()) {
                    l.add(ss[i]);
                }
                ++i;
            }
            result = l.toArray(new ISubSystem[l.size()]);
        }
        return result;
    }

    public boolean checkObjectType(Object obj) {
        if (!(obj instanceof IHost) || !this.sr.isAnySubSystemConnected((IHost)obj)) {
            return false;
        }
        ISubSystem[] ss = SystemDisconnectAllSubSystemsAction.getDisconnectableSubsystems(obj);
        return ss != null && ss.length > 0;
    }

    public void run() {
        for (Object item : this.getSelection()) {
            if (!(item instanceof IHost)) continue;
            try {
                this.sr.disconnectAllSubSystems((IHost)item);
            }
            catch (Exception exception) {}
        }
    }
}

