/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.script;

import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.core.script.JavascriptEvalUtil;
import org.eclipse.birt.data.engine.impl.DataSetRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;

public class JSInputParams
extends ScriptableObject {
    private static final long serialVersionUID = 24556334211698002L;
    private DataSetRuntime dataSet;

    public JSInputParams(DataSetRuntime dataSet) {
        this.dataSet = dataSet;
    }

    public String getClassName() {
        return "InputParams";
    }

    public Object get(int index, Scriptable scope) {
        return NOT_FOUND;
    }

    public Object get(String name, Scriptable scope) {
        try {
            Object paramValue = this.dataSet.getInputParameterValue(name);
            if (paramValue == DataSetRuntime.UNSET_VALUE) {
                return NOT_FOUND;
            }
            return JavascriptEvalUtil.convertToJavascriptValue((Object)paramValue, (Scriptable)this.dataSet.getSharedScope());
        }
        catch (BirtException birtException) {
            return NOT_FOUND;
        }
    }

    public boolean has(int index, Scriptable start) {
        return super.has(index, start);
    }

    public boolean has(String name, Scriptable start) {
        if (this.dataSet.hasInputParameter(name)) {
            return true;
        }
        return super.has(name, start);
    }

    public void put(int index, Scriptable scope, Object value) {
        throw new IllegalArgumentException("Put value on output parameter object is not supported.");
    }

    public void put(String name, Scriptable scope, Object value) {
        try {
            this.dataSet.setInputParameterValue(name, value);
        }
        catch (BirtException birtException) {}
    }
}

