/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.utils.elf.parser;

import java.io.EOFException;
import java.io.IOException;
import org.eclipse.cdt.core.AbstractCExtension;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.IBinaryParser;
import org.eclipse.cdt.utils.AR;
import org.eclipse.cdt.utils.elf.Elf;
import org.eclipse.cdt.utils.elf.parser.ElfBinaryArchive;
import org.eclipse.cdt.utils.elf.parser.ElfBinaryExecutable;
import org.eclipse.cdt.utils.elf.parser.ElfBinaryObject;
import org.eclipse.cdt.utils.elf.parser.ElfBinaryShared;
import org.eclipse.core.runtime.IPath;

public class ElfParser
extends AbstractCExtension
implements IBinaryParser {
    @Override
    public IBinaryParser.IBinaryFile getBinary(IPath path) throws IOException {
        return this.getBinary(null, path);
    }

    @Override
    public IBinaryParser.IBinaryFile getBinary(byte[] hints, IPath path) throws IOException {
        IBinaryParser.IBinaryFile binary;
        block17: {
            if (path == null) {
                throw new IOException(CCorePlugin.getResourceString("Util.exception.nullPath"));
            }
            binary = null;
            if (hints != null && AR.isARHeader(hints)) {
                binary = this.createBinaryArchive(path);
            } else {
                try {
                    Elf.Attribute attribute = null;
                    if (hints != null && Elf.isElfHeader(hints)) {
                        try {
                            attribute = Elf.getAttributes(hints);
                        }
                        catch (EOFException eOFException) {}
                    }
                    if (attribute == null) {
                        attribute = Elf.getAttributes(path.toOSString());
                    }
                    if (attribute != null) {
                        switch (attribute.getType()) {
                            case 1: {
                                binary = this.createBinaryExecutable(path);
                                break;
                            }
                            case 2: {
                                binary = this.createBinaryShared(path);
                                break;
                            }
                            case 3: {
                                binary = this.createBinaryObject(path);
                                break;
                            }
                            case 4: {
                                binary = this.createBinaryCore(path);
                            }
                        }
                        if (binary instanceof ElfBinaryObject) {
                            ((ElfBinaryObject)binary).setElfAttributes(attribute);
                        }
                    }
                }
                catch (IOException iOException) {
                    if (hints != null) break block17;
                    binary = this.createBinaryArchive(path);
                }
            }
        }
        return binary;
    }

    @Override
    public String getFormat() {
        return "ELF";
    }

    @Override
    public boolean isBinary(byte[] array, IPath path) {
        return Elf.isElfHeader(array) || AR.isARHeader(array);
    }

    @Override
    public int getHintBufferSize() {
        return 128;
    }

    protected IBinaryParser.IBinaryArchive createBinaryArchive(IPath path) throws IOException {
        return new ElfBinaryArchive(this, path);
    }

    protected IBinaryParser.IBinaryObject createBinaryObject(IPath path) throws IOException {
        return new ElfBinaryObject((IBinaryParser)this, path, 1);
    }

    protected IBinaryParser.IBinaryExecutable createBinaryExecutable(IPath path) throws IOException {
        return new ElfBinaryExecutable(this, path);
    }

    protected IBinaryParser.IBinaryShared createBinaryShared(IPath path) throws IOException {
        return new ElfBinaryShared(this, path);
    }

    protected IBinaryParser.IBinaryObject createBinaryCore(IPath path) throws IOException {
        return new ElfBinaryObject((IBinaryParser)this, path, 16);
    }
}

