/*
 * Decompiled with CFR 0.152.
 */
package oracle.streams;

import java.util.HashMap;
import java.util.Map;
import oracle.sql.CHAR;
import oracle.sql.DATE;
import oracle.sql.NUMBER;
import oracle.streams.LCR;
import oracle.streams.StreamsException;

public abstract class AbstractLCR
implements LCR {
    protected String sourceDatabaseName = null;
    protected String commandType = null;
    protected String objectOwner = null;
    protected String objectName = null;
    protected byte[] tag = null;
    protected byte[] position = null;
    protected String transactionId = null;
    protected DATE sourceTime = null;
    protected NUMBER scn = null;
    protected NUMBER cscn = null;
    protected HashMap<Object, Object> attributes = new HashMap();
    private static final String MESSAGE_TRACKING_LABEL = "MESSAGE_TRACKING_LABEL";
    private static final String ROOT_NAME = "ROOT_NAME";

    @Override
    public void setSourceDatabaseName(String string) {
        this.sourceDatabaseName = string;
    }

    @Override
    public void setCommandType(String string) {
        this.commandType = string;
    }

    @Override
    public void setObjectOwner(String string) {
        this.objectOwner = string;
    }

    @Override
    public void setObjectName(String string) {
        this.objectName = string;
    }

    @Override
    public void setTag(byte[] byArray) {
        this.tag = byArray;
    }

    @Override
    public void setPosition(byte[] byArray) {
        this.position = byArray;
    }

    @Override
    public void setTransactionId(String string) {
        this.transactionId = string;
    }

    @Override
    public void setSourceTime(DATE dATE) {
        this.sourceTime = dATE;
    }

    @Override
    public void setAttribute(Object object, Object object2) {
        this.attributes.put(object, object2);
    }

    public void setMessageTrackingLabel(String string) throws StreamsException {
        if (null != string) {
            try {
                CHAR cHAR = new CHAR(string, null);
                this.setAttribute(MESSAGE_TRACKING_LABEL, cHAR);
            }
            catch (Exception exception) {
                throw new StreamsException("fail to set message tracking label", exception);
            }
        }
    }

    @Override
    public String getSourceDatabaseName() {
        return this.sourceDatabaseName;
    }

    @Override
    public String getCommandType() {
        return this.commandType;
    }

    @Override
    public String getObjectOwner() {
        return this.objectOwner;
    }

    @Override
    public String getObjectName() {
        return this.objectName;
    }

    @Override
    public byte[] getTag() {
        return this.tag;
    }

    @Override
    public byte[] getPosition() {
        return this.position;
    }

    @Override
    public String getTransactionId() {
        return this.transactionId;
    }

    @Override
    public DATE getSourceTime() {
        return this.sourceTime;
    }

    @Override
    public Object getAttribute(Object object) {
        return this.attributes.get(object);
    }

    public NUMBER getSCN() {
        return this.scn;
    }

    public NUMBER getCommitSCN() {
        return this.cscn;
    }

    public int getNumAttributes() {
        return this.attributes.size();
    }

    public Object[] getAttributesList() {
        return this.attributes.entrySet().toArray();
    }

    public Object getAttributeName(int n) {
        return ((Map.Entry)this.attributes.entrySet().toArray()[n]).getKey();
    }

    public Object getAttributeValue(int n) {
        return ((Map.Entry)this.attributes.entrySet().toArray()[n]).getValue();
    }

    public String getMessageTrackingLabel() throws StreamsException {
        try {
            Object object = this.getAttribute(MESSAGE_TRACKING_LABEL);
            if (object != null) {
                return ((CHAR)object).toString();
            }
        }
        catch (Exception exception) {
            throw new StreamsException("fail to get message tracking label", exception);
        }
        return null;
    }

    public String getRootName() throws StreamsException {
        try {
            Object object = this.getAttribute(ROOT_NAME);
            if (object != null) {
                return ((CHAR)object).toString();
            }
        }
        catch (Exception exception) {
            throw new StreamsException("fail to get root name", exception);
        }
        return null;
    }

    public void setRootName(String string) throws StreamsException {
        if (null != string) {
            try {
                CHAR cHAR = new CHAR(string, null);
                this.setAttribute(ROOT_NAME, cHAR);
            }
            catch (Exception exception) {
                throw new StreamsException("fail to set root name", exception);
            }
        }
    }
}

