/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver.json.tree;

import java.sql.SQLException;
import java.sql.Wrapper;
import java.util.AbstractList;
import java.util.List;
import javax.json.JsonArray;
import javax.json.JsonNumber;
import javax.json.JsonObject;
import javax.json.JsonString;
import javax.json.JsonValue;
import oracle.jdbc.driver.json.tree.OracleJsonArrayImpl;
import oracle.sql.json.OracleJsonArray;
import oracle.sql.json.OracleJsonNumber;
import oracle.sql.json.OracleJsonValue;

public class JsonpArrayImpl
extends AbstractList<JsonValue>
implements JsonArray,
Wrapper {
    OracleJsonArrayImpl wrapped;

    JsonpArrayImpl(OracleJsonArrayImpl oracleJsonArrayImpl) {
        this.wrapped = oracleJsonArrayImpl;
    }

    public JsonValue.ValueType getValueType() {
        return JsonValue.ValueType.ARRAY;
    }

    @Override
    public int size() {
        return this.wrapped.size();
    }

    @Override
    public boolean isEmpty() {
        return this.wrapped.isEmpty();
    }

    @Override
    public JsonValue get(int n2) {
        OracleJsonValue oracleJsonValue = this.wrapped.get(n2);
        return oracleJsonValue.wrap(JsonValue.class);
    }

    @Override
    public List<JsonValue> subList(int n2, int n3) {
        return (List)this.wrapped.subList(n2, n3).wrap(JsonArray.class);
    }

    public boolean getBoolean(int n2) {
        return this.wrapped.getBoolean(n2);
    }

    public boolean getBoolean(int n2, boolean bl) {
        if (n2 < 0 || n2 >= this.wrapped.size()) {
            return bl;
        }
        OracleJsonValue oracleJsonValue = this.wrapped.get(n2);
        if (OracleJsonValue.TRUE.equals(oracleJsonValue)) {
            return true;
        }
        if (OracleJsonValue.FALSE.equals(oracleJsonValue)) {
            return false;
        }
        return bl;
    }

    public int getInt(int n2) {
        return this.wrapped.getInt(n2);
    }

    public int getInt(int n2, int n3) {
        if (n2 < 0 || n2 >= this.wrapped.size()) {
            return n3;
        }
        OracleJsonValue oracleJsonValue = this.wrapped.get(n2);
        if (oracleJsonValue instanceof OracleJsonNumber) {
            return ((OracleJsonNumber)oracleJsonValue).intValue();
        }
        return n3;
    }

    public JsonArray getJsonArray(int n2) {
        return this.wrapped.get(n2).asJsonArray().wrap(JsonArray.class);
    }

    public JsonNumber getJsonNumber(int n2) {
        return ((OracleJsonNumber)this.wrapped.get(n2)).wrap(JsonNumber.class);
    }

    public JsonObject getJsonObject(int n2) {
        return this.wrapped.get(n2).asJsonObject().wrap(JsonObject.class);
    }

    public JsonString getJsonString(int n2) {
        return this.wrapped.get(n2).wrap(JsonString.class);
    }

    public <T extends JsonValue> List<T> getValuesAs(Class<T> clazz) {
        return new AbstractList<T>(){

            @Override
            public T get(int n2) {
                return JsonpArrayImpl.this.get(n2);
            }

            @Override
            public int size() {
                return JsonpArrayImpl.this.wrapped.size();
            }
        };
    }

    public String getString(int n2) {
        return ((JsonString)this.get(n2)).getString();
    }

    public String getString(int n2, String string) {
        if (n2 < 0 || n2 >= this.wrapped.size()) {
            return string;
        }
        OracleJsonValue oracleJsonValue = this.wrapped.get(n2);
        switch (oracleJsonValue.getOracleJsonType()) {
            case BINARY: 
            case DATE: 
            case INTERVALDS: 
            case INTERVALYM: 
            case STRING: 
            case TIMESTAMP: {
                return oracleJsonValue.wrap(JsonString.class).getString();
            }
        }
        return string;
    }

    public boolean isNull(int n2) {
        return this.wrapped.isNull(n2);
    }

    @Override
    public boolean isWrapperFor(Class<?> clazz) throws SQLException {
        return clazz.isAssignableFrom(OracleJsonArray.class);
    }

    @Override
    public <T> T unwrap(Class<T> clazz) throws SQLException {
        try {
            return clazz.cast(this.wrapped);
        }
        catch (ClassCastException classCastException) {
            throw new SQLException(classCastException.getMessage(), classCastException);
        }
    }
}

