/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj;

import java.util.Iterator;
import java.util.List;
import java.util.Set;
import net.sf.mpxj.CustomField;
import net.sf.mpxj.FieldType;
import net.sf.mpxj.FieldTypeClass;
import net.sf.mpxj.ProjectCalendar;
import net.sf.mpxj.ProjectEntityWithIDContainer;
import net.sf.mpxj.ProjectFile;
import net.sf.mpxj.Resource;
import net.sf.mpxj.ResourceAssignment;
import net.sf.mpxj.ResourceField;
import net.sf.mpxj.common.NumberHelper;
import net.sf.mpxj.common.PopulatedFields;

public class ResourceContainer
extends ProjectEntityWithIDContainer<Resource> {
    public ResourceContainer(ProjectFile projectFile) {
        super(projectFile);
    }

    @Override
    public void removed(Resource resource) {
        this.m_uniqueIDMap.remove(resource.getUniqueID());
        this.m_idMap.remove(resource.getID());
        Iterator iter = this.m_projectFile.getResourceAssignments().iterator();
        Integer resourceUniqueID = resource.getUniqueID();
        while (iter.hasNext()) {
            ResourceAssignment assignment = (ResourceAssignment)iter.next();
            if (!NumberHelper.equals(assignment.getResourceUniqueID(), resourceUniqueID)) continue;
            assignment.getTask().removeResourceAssignment(assignment);
            iter.remove();
        }
        ProjectCalendar calendar = resource.getCalendar();
        if (calendar != null) {
            calendar.remove();
        }
    }

    public Resource add() {
        Resource resource = new Resource(this.m_projectFile);
        this.add(resource);
        return resource;
    }

    public void updateStructure() {
        if (this.size() > 1) {
            this.m_projectFile.getChildResources().clear();
            this.stream().forEach(r -> r.getChildResources().clear());
            this.stream().forEach(r -> {
                Resource parent = r.getParentResource();
                if (parent == null) {
                    this.m_projectFile.getChildResources().add((Resource)r);
                } else {
                    parent.addChildResource((Resource)r);
                }
            });
        }
    }

    public Set<ResourceField> getPopulatedFields() {
        return new PopulatedFields<ResourceField, Resource>(this.m_projectFile, ResourceField.class, this).getPopulatedFields();
    }

    public List<CustomField> getCustomFields() {
        return this.m_projectFile.getCustomFields().getCustomFieldsByFieldTypeClass(FieldTypeClass.RESOURCE);
    }

    public FieldType getFieldTypeByAlias(String alias) {
        return this.m_projectFile.getCustomFields().getFieldTypeByAlias(FieldTypeClass.RESOURCE, alias);
    }
}

