/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.asta;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import net.sf.mpxj.DayType;
import net.sf.mpxj.MPXJException;
import net.sf.mpxj.ProjectFile;
import net.sf.mpxj.asta.AstaDatabaseException;
import net.sf.mpxj.asta.AstaReader;
import net.sf.mpxj.asta.MapRow;
import net.sf.mpxj.asta.Row;
import net.sf.mpxj.asta.RowComparator;
import net.sf.mpxj.reader.AbstractProjectFileReader;

abstract class AbstractDatabaseReader
extends AbstractProjectFileReader {
    private AstaReader m_reader;
    private Integer m_projectID;
    private Map<String, Integer> m_projectKey;

    AbstractDatabaseReader() {
    }

    public Map<Integer, String> listProjects() throws MPXJException {
        try {
            HashMap<Integer, String> result = new HashMap<Integer, String>();
            List<Row> rows = this.getRows("project_summary", Collections.emptyMap());
            for (Row row : rows) {
                Integer id = row.getInteger("PROJID");
                String name = row.getString("SHORT_NAME");
                result.put(id, name);
            }
            return result;
        }
        catch (AstaDatabaseException ex) {
            throw new MPXJException("Error reading file", ex);
        }
    }

    public ProjectFile read() throws MPXJException {
        try {
            this.m_reader = new AstaReader();
            ProjectFile project = this.m_reader.getProject();
            this.addListenersToProject(project);
            this.processProjectProperties();
            this.processCalendars();
            this.processResources();
            this.processTasks();
            this.processPredecessors();
            this.processAssignments();
            this.m_reader = null;
            ProjectFile projectFile = project;
            return projectFile;
        }
        catch (AstaDatabaseException ex) {
            throw new MPXJException("Error reading file", ex);
        }
        finally {
            this.releaseResources();
        }
    }

    private void processProjectProperties() throws AstaDatabaseException {
        List<Row> projectSummaryRows = this.getRows("project_summary", this.m_projectKey);
        List<Row> progressPeriodRows = this.getRows("progress_period", this.m_projectKey);
        List<Row> userSettingsRows = this.getRows("userr", this.m_projectKey);
        Row projectSummary = projectSummaryRows.isEmpty() ? null : projectSummaryRows.get(0);
        Row userSettings = userSettingsRows.isEmpty() ? null : userSettingsRows.get(0);
        List<Row> progressPeriods = progressPeriodRows.isEmpty() ? null : progressPeriodRows;
        this.m_reader.processProjectProperties(projectSummary, userSettings, progressPeriods);
    }

    private void processCalendars() throws AstaDatabaseException {
        List<Row> rows = this.getRows("exceptionn", Collections.emptyMap());
        Map<Integer, DayType> exceptionMap = this.m_reader.createExceptionTypeMap(rows);
        rows = this.getRows("work_pattern", Collections.emptyMap());
        Map<Integer, Row> workPatternMap = this.m_reader.createWorkPatternMap(rows);
        rows = this.getRows("work_pattern_assignment", Collections.emptyMap());
        Map<Integer, List<Row>> workPatternAssignmentMap = this.m_reader.createWorkPatternAssignmentMap(rows);
        rows = this.sortRows(this.getRows("exception_assignment", Collections.emptyMap()), "EXCEPTION_ASSIGNMENT_ID", "ORDF");
        Map<Integer, List<Row>> exceptionAssignmentMap = this.m_reader.createExceptionAssignmentMap(rows);
        rows = this.sortRows(this.getRows("time_entry", Collections.emptyMap()), "TIME_ENTRYID", "ORDF");
        Map<Integer, List<Row>> timeEntryMap = this.m_reader.createTimeEntryMap(rows);
        rows = this.sortRows(this.getRows("calendar", this.m_projectKey), "CALENDARID");
        for (Row row : rows) {
            this.m_reader.processCalendar(row, workPatternMap, workPatternAssignmentMap, exceptionAssignmentMap, timeEntryMap, exceptionMap);
        }
        this.m_reader.getProject().getProjectConfig().updateUniqueCounters();
    }

    private void processResources() throws AstaDatabaseException {
        List<Row> permanentRows = this.sortRows(this.getRows("permanent_resource", this.m_projectKey), "PERMANENT_RESOURCEID");
        List<Row> consumableRows = this.sortRows(this.getRows("consumable_resource", this.m_projectKey), "CONSUMABLE_RESOURCEID");
        this.m_reader.processResources(permanentRows, consumableRows);
    }

    private void processTasks() throws AstaDatabaseException {
        List<Row> bars = this.getRows("bar", this.m_projectKey);
        List<Row> expandedTasks = this.getRows("expanded_task", this.m_projectKey);
        List<Row> tasks = this.getRows("task", this.m_projectKey);
        List<Row> milestones = this.getRows("milestone", this.m_projectKey);
        this.m_reader.processTasks(bars, expandedTasks, tasks, milestones);
    }

    private void processPredecessors() throws AstaDatabaseException {
        List<Row> rows = this.sortRows(this.getRows("link", this.m_projectKey), "LINKID");
        List<Row> completedSections = this.getRows("task_completed_section", this.m_projectKey);
        this.m_reader.processPredecessors(rows, completedSections);
    }

    private void processAssignments() throws AstaDatabaseException {
        List<Row> allocationRows = this.getRows("permanent_schedul_allocation", this.m_projectKey);
        List<Row> skillRows = this.getRows("perm_resource_skill", this.m_projectKey);
        List<Row> permanentAssignments = this.sortRows(this.joinRows(allocationRows, "ALLOCATIOP_OF", "PERM_RESOURCE_SKILL", skillRows, "PERM_RESOURCE_SKILLID"), "PERMANENT_SCHEDUL_ALLOCATIONID");
        this.m_reader.processAssignments(permanentAssignments);
    }

    public void setProjectID(int projectID) {
        this.m_projectID = projectID;
        this.m_projectKey = Collections.singletonMap("PROJID", this.m_projectID);
    }

    @Override
    public ProjectFile read(File file) throws MPXJException {
        try {
            this.allocateResources(file);
            this.setProjectID(0);
            ProjectFile projectFile = this.read();
            return projectFile;
        }
        catch (AstaDatabaseException ex) {
            throw new MPXJException("Error reading file", ex);
        }
        finally {
            this.releaseResources();
        }
    }

    @Override
    public List<ProjectFile> readAll(File file) throws MPXJException {
        try {
            this.allocateResources(file);
            ArrayList<ProjectFile> result = new ArrayList<ProjectFile>();
            Set<Integer> ids = this.listProjects().keySet();
            Object object = ids.iterator();
            while (object.hasNext()) {
                Integer id;
                this.m_projectID = id = object.next();
                result.add(this.read());
            }
            object = result;
            return object;
        }
        catch (AstaDatabaseException ex) {
            throw new MPXJException("Error reading file", ex);
        }
        finally {
            this.releaseResources();
        }
    }

    protected abstract List<Row> getRows(String var1, Map<String, Integer> var2) throws AstaDatabaseException;

    protected abstract void allocateResources(File var1) throws AstaDatabaseException;

    protected abstract void releaseResources();

    private List<Row> sortRows(List<Row> rows, String ... columnNames) {
        Comparator<Row> comparator = Comparator.comparing(r -> r.getInt(columnNames[0]));
        if (columnNames.length > 1) {
            for (int index = 1; index < columnNames.length; ++index) {
                String columnName = columnNames[index];
                comparator = comparator.thenComparing(r -> r.getInt(columnName));
            }
        }
        rows.sort(comparator);
        return rows;
    }

    private List<Row> joinRows(List<Row> leftRows, String leftColumn, String rightTable, List<Row> rightRows, String rightColumn) {
        ArrayList<Row> result = new ArrayList<Row>();
        RowComparator leftComparator = new RowComparator(leftColumn);
        RowComparator rightComparator = new RowComparator(rightColumn);
        leftRows.sort(leftComparator);
        rightRows.sort(rightComparator);
        ListIterator<Row> rightIterator = rightRows.listIterator();
        Row rightRow = rightIterator.hasNext() ? rightIterator.next() : null;
        for (Row leftRow : leftRows) {
            Integer leftValue = leftRow.getInteger(leftColumn);
            boolean match = false;
            while (rightRow != null) {
                Integer rightValue = rightRow.getInteger(rightColumn);
                int comparison = leftValue.compareTo(rightValue);
                if (comparison == 0) {
                    match = true;
                    break;
                }
                if (comparison < 0) {
                    if (!rightIterator.hasPrevious()) break;
                    rightRow = rightIterator.previous();
                    break;
                }
                rightRow = rightIterator.next();
            }
            if (!match || rightRow == null) continue;
            HashMap<String, Object> newMap = new HashMap<String, Object>(((MapRow)leftRow).getMap());
            for (Map.Entry<String, Object> entry : ((MapRow)rightRow).getMap().entrySet()) {
                String key = entry.getKey();
                if (newMap.containsKey(key)) {
                    key = rightTable + "." + key;
                }
                newMap.put(key, entry.getValue());
            }
            result.add(new MapRow(newMap));
        }
        return result;
    }
}

