/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.common;

import java.io.File;

public final class JdbcOdbcHelper {
    private static final boolean JDBC_ODBC_AVAILABLE;

    public static boolean jdbcOdbcAvailable() {
        return JDBC_ODBC_AVAILABLE;
    }

    public static String getMicrosoftAccessJdbcUrl(File file) {
        return JdbcOdbcHelper.getMicrosoftAccessJdbcUrl(file.getAbsolutePath());
    }

    public static String getMicrosoftAccessJdbcUrl(String filename) {
        if (!JDBC_ODBC_AVAILABLE) {
            throw new RuntimeException("JDBC-ODBC Bridge not available");
        }
        return "jdbc:odbc:DRIVER=Microsoft Access Driver (*.mdb);DBQ=" + filename;
    }

    static {
        boolean available = false;
        try {
            Class.forName("sun.jdbc.odbc.JdbcOdbcDriver");
            available = true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        JDBC_ODBC_AVAILABLE = available;
    }
}

